<?php
require_once 'db.php';
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'Utilisateur non connecté']);
    exit;
}

// Récupérer l'ID de l'utilisateur connecté
$user_id = $_SESSION['user_id'];

try {
    // Obtenir la connexion à la base de données
    $db1 = getDB1Connection();
    
    // Vérifier si la colonne roleinimators existe
    $checkColumn = $db1->query("SHOW COLUMNS FROM utilisateurs LIKE 'roleinimators'");
    
    if ($checkColumn->rowCount() == 0) {
        // La colonne n'existe pas, on la crée
        $db1->exec("ALTER TABLE utilisateurs ADD COLUMN roleinimators VARCHAR(255) DEFAULT NULL");
        echo json_encode(['status' => 'success', 'message' => 'Colonne roleinimators créée avec succès']);
    } else {
        // La colonne existe, vérifier si la valeur est présente pour l'utilisateur
        $stmt = $db1->prepare("SELECT roleinimators FROM utilisateurs WHERE id = :id");
        $stmt->bindParam(':id', $user_id);
        $stmt->execute();
        
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($result && $result['roleinimators']) {
            // La valeur existe déjà
            $_SESSION['roleinimators'] = $result['roleinimators'];
            echo json_encode(['status' => 'success', 'message' => 'roleinimators récupéré avec succès', 'value' => $result['roleinimators']]);
        } else {
            // La valeur n'existe pas pour cet utilisateur
            echo json_encode(['status' => 'warning', 'message' => 'roleinimators non défini pour cet utilisateur']);
        }
    }
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Erreur de base de données: ' . $e->getMessage()]);
}
?>