<?php
$token = bin2hex(random_bytes(32));

session_start();
require 'db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$message = '';

function sendUpdateEmail($email, $type) {
    $to = $email;
    $subject = 'Update to Your Imators Account';
    $message = '
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Imators Account Update</title>
        <style>
            body { font-family: "Space Grotesk", sans-serif; line-height: 1.6; color: #e0e0e0; background-color: #121212; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background-color: #1a202c; color: #ffffff; padding: 20px; text-align: center; border-radius: 8px 8px 0 0; }
            .content { background-color: #1e293b; padding: 30px; border-radius: 0 0 8px 8px; }
            .button { display: inline-block; padding: 12px 24px; background-color: rgba(255,255,255,0.1); color: #ffffff; text-decoration: none; border-radius: 8px; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <img src="https://cdn.imators.com/logo.png" alt="Imators Logo" style="max-height: 50px;">
                <h1>Account Update Notification</h1>
            </div>
            <div class="content">
                <p>Hello,</p>
                <p>Your ' . $type . ' has been updated on your Imators account.</p>
                <p>If you did not make this change, please contact support immediately.</p>
                <p style="text-align: center;">
                    <a href="https://imators.com/contact-support" class="button">Contact Support</a>
                </p>
            </div>
        </div>
    </body>
    </html>';

    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8\r\n";
    $headers .= 'From: Imators <no-reply@imators.com>\r\n';

    mail($to, $subject, $message, $headers);
}

// Fetch user data including the client column
$sql = "SELECT username, email, created_at, client, client_data FROM utilisateurs WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

$username = $user['username'];
$email = $user['email'];
$client = $user['client'];
$client_data = json_decode($user['client_data'], true);
$created_at = new DateTime($user['created_at']);
$now = new DateTime();
$account_age = $created_at->diff($now)->days;

$stmt->close();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['update_info']) && $_POST['csrf_token'] === $_SESSION['csrf_token']) {
        $new_username = trim($_POST['username']);
        $new_email = trim($_POST['email']);

        if (!empty($new_username) && !empty($new_email)) {
            $sql = "UPDATE utilisateurs SET username = ?, email = ? WHERE id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssi", $new_username, $new_email, $user_id);

            if ($stmt->execute()) {
                sendUpdateEmail($new_email, 'account information');
                $message = 'Information updated successfully!';
                $username = $new_username;
                $email = $new_email;
            } else {
                $message = 'Failed to update information.';
            }
            $stmt->close();
        } else {
            $message = 'Both username and email fields are required.';
        }
    }

    if (isset($_POST['change_password']) && $_POST['csrf_token'] === $_SESSION['csrf_token']) {
        $new_password = trim($_POST['password']);

        if (!empty($new_password)) {
            $password_hash = password_hash($new_password, PASSWORD_DEFAULT);
            $sql = "UPDATE utilisateurs SET password = ? WHERE id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("si", $password_hash, $user_id);

            if ($stmt->execute()) {
                sendUpdateEmail($email, 'password');
                $message = 'Password changed successfully!';
            } else {
                $message = 'Failed to change password.';
            }
            $stmt->close();
        } else {
            $message = 'The password field is required.';
        }
    }
}

$_SESSION['csrf_token'] = $token;

if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY'] > 1800)) {
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit();
}
$_SESSION['LAST_ACTIVITY'] = time();

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #111827;
            color: #e0e0e0;
        }
        .fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        .input-effect {
            position: relative;
            margin-bottom: 30px;
        }
        .input-effect input {
            width: 100%;
            padding: 12px;
            background-color: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            color: #fff;
            transition: all 0.3s ease;
        }
        .input-effect input:focus {
            border-color: #3B82F6;
            background-color: rgba(255, 255, 255, 0.1);
            outline: none;
        }
    </style>
</head>
<body class="min-h-screen">
    <div class="container mx-auto px-4 py-12">
        <!-- Header Section -->
        <header class="text-center mb-16">
            <img src="https://cdn.imators.com/logo.png" alt="Imators Logo" class="h-16 mx-auto mb-8">
            <h1 class="text-4xl font-light tracking-wide text-white mb-2">Welcome, <?php echo htmlspecialchars($username); ?></h1>
            <p class="text-gray-400">Manage your Imators account</p>
        </header>

        <?php if (!empty($message)): ?>
            <div class="max-w-2xl mx-auto mb-8 bg-blue-500/10 border border-blue-500/20 text-blue-400 p-4 rounded-lg fade-in">
                <?php echo $message; ?>
            </div>
        <?php endif; ?>

        <!-- Main Content -->
        <div class="max-w-4xl mx-auto space-y-8">
            <!-- Connected Services Section - Only shows if client is not NULL -->
            <?php if ($client !== NULL): ?>
            <section class="bg-black/40 backdrop-blur-sm p-8 rounded-xl">
                <div class="flex items-center space-x-4">
                    <img src="<?php echo htmlspecialchars($client_data['logo_url']); ?>" 
                         alt="<?php echo htmlspecialchars($client); ?> Logo" 
                         class="w-12 h-12 rounded-full">
                    <div>
                        <h2 class="text-xl font-light text-white">Connected to <?php echo htmlspecialchars($client); ?></h2>
                        <p class="text-sm text-gray-400"><?php echo htmlspecialchars($client_data['description']); ?></p>
                    </div>
                </div>
            </section>
            <?php endif; ?>

            <!-- Account Overview -->
            <section class="bg-black/40 backdrop-blur-sm p-8 rounded-xl">
                <h2 class="text-2xl font-light mb-6 text-white">Account Overview</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <div>
                        <p class="text-sm text-gray-400 mb-1">Account Age</p>
                        <p class="text-3xl font-light text-white"><?php echo $account_age; ?> days</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-400 mb-1">Email Address</p>
                        <p class="text-lg text-white"><?php echo htmlspecialchars($email); ?></p>
                    </div>
                </div>
            </section>

            <!-- Update Information -->
            <section class="bg-black/40 backdrop-blur-sm p-8 rounded-xl">
                <h2 class="text-2xl font-light mb-6 text-white">Update Information</h2>
                <form method="POST" action="" class="space-y-6">
                    <input type="hidden" name="csrf_token" value="<?php echo $token; ?>">
                    <div class="space-y-4">
                        <div class="input-effect">
                            <input type="text" id="username" name="username" placeholder="New Username" class="w-full">
                        </div>
                        <div class="input-effect">
                            <input type="email" id="email" name="email" placeholder="New Email" class="w-full">
                        </div>
                        <button type="submit" name="update_info" 
                                class="w-full py-3 px-6 bg-white/5 hover:bg-white/10 text-white rounded-lg transition duration-300">
                            Update Information
                        </button>
                    </div>
                </form>
            </section>

            <!-- Change Password -->
            <section class="bg-black/40 backdrop-blur-sm p-8 rounded-xl">
                <h2 class="text-2xl font-light mb-6 text-white">Change Password</h2>
                <form method="POST" action="" class="space-y-6">
                    <input type="hidden" name="csrf_token" value="<?php echo $token; ?>">
                    <div class="input-effect">
                        <input type="password" id="password" name="password" placeholder="New Password" class="w-full">
                    </div>
                    <button type="submit" name="change_password" 
                            class="w-full py-3 px-6 bg-white/5 hover:bg-white/10 text-white rounded-lg transition duration-300">
                        Change Password
                    </button>
                </form>
            </section>
        </div>

        <!-- Footer -->
        <footer class="mt-16 text-center text-gray-400">
            <a href="/" class="text-blue-400 hover:text-blue-300 transition duration-300">Log out</a>
            <p class="mt-4 text-sm">&copy; <?php echo date('Y'); ?> Imators LLC. All rights reserved.</p>
        </footer>
    </div>
</body>
</html>