<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Parade Display - Imators</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(to bottom, white, #e0f0ff);
            min-height: 100vh;
        }
        .fade-blur {
            transition: all 0.5s ease;
        }
        .fade-blur.hidden {
            opacity: 0;
            filter: blur(10px);
        }
    </style>
</head>
<body>
    <div id="defaultContent" class="flex flex-col items-center justify-center min-h-screen p-8">
        <div class="flex items-center space-x-4 mb-8 fade-blur">
            <img src="theframe.png" alt="Image centrale" class="w-64 h-auto">
            <div class="w-px h-16 bg-gray-300"></div>
            <img src="https://cdn.imators.com/logo.png" alt="Imators Logo" class="w-32 h-auto">
        </div>
        <div class="text-2xl text-gray-700 fade-blur">Presented by</div>
    </div>

    <video id="videoPlayer" class="hidden fixed inset-0 w-full h-full object-cover"></video>

    <script>
    async function checkSchedule() {
        try {
            const response = await fetch('data.json');
            const data = await response.json();
            
            if (data.url && data.startTime) {
                const now = new Date();
                const startTime = new Date(data.startTime);
                const prepTime = (data.prepTime || 15) * 1000;
                const timeUntilStart = startTime - now;

                if (timeUntilStart <= prepTime && timeUntilStart > 0) {
                    const elements = document.querySelectorAll('.fade-blur');
                    elements.forEach(el => el.classList.add('hidden'));
                    
                    setTimeout(() => {
                        const video = document.getElementById('videoPlayer');
                        video.src = data.url;
                        video.classList.remove('hidden');
                        
                        setTimeout(() => {
                            video.play();
                            
                            video.onended = () => {
                                video.classList.add('hidden');
                                elements.forEach(el => el.classList.remove('hidden'));
                            };
                        }, timeUntilStart);
                    }, 500);
                }
            }
        } catch (error) {
            console.error('Erreur lors de la lecture du fichier data.json:', error);
        }
    }

    setInterval(checkSchedule, 1000);
    checkSchedule();
    </script>
</body>
</html>