<?php
// Assurez-vous que la session est démarrée
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Si l'utilisateur est connecté, récupérer ses informations
$user = null;
if (isset($_SESSION['user_id']) && isset($db)) {
    try {
        $user_query = "SELECT first_name, last_name, role FROM users WHERE id = :user_id";
        $user_stmt = $db->prepare($user_query);
        $user_stmt->execute([':user_id' => $_SESSION['user_id']]);
        $user = $user_stmt->fetch();
    } catch (Exception $e) {
        // Gérer silencieusement l'erreur
    }
}
?>

<header class="fixed w-full top-0 z-50">
    <div class="bg-white bg-opacity-80 backdrop-blur-md border-b border-gray-100">
        <div class="max-w-6xl mx-auto px-4 sm:px-6">
            <nav class="flex items-center justify-between h-20">
                <!-- Logo -->
                <a href="/" class="text-xl font-medium tracking-tight text-gray-900">Peerkinton</a>
                
                <!-- Navigation principale - visible sur desktop -->
                <div class="hidden lg:flex items-center space-x-10">                        
                    <a href="/search/data" class="text-gray-600 text-sm hover:text-gray-900 relative after:absolute after:bottom-0 after:left-0 after:h-0.5 after:w-0 hover:after:w-full after:bg-gray-900 after:transition-all after:duration-300">Search Data</a>
                    <a href="/search/profile" class="text-gray-600 text-sm hover:text-gray-900 relative after:absolute after:bottom-0 after:left-0 after:h-0.5 after:w-0 hover:after:w-full after:bg-gray-900 after:transition-all after:duration-300">Search Profile</a>
                    <a href="/about" class="text-gray-600 text-sm hover:text-gray-900 relative after:absolute after:bottom-0 after:left-0 after:h-0.5 after:w-0 hover:after:w-full after:bg-gray-900 after:transition-all after:duration-300">Enterprise</a>
                </div>

                <!-- Auth - visible sur desktop -->
                <div class="hidden lg:flex items-center space-x-6">
                    <?php if (isset($_SESSION['user_id'])): ?>
                        <div class="relative group">
                            <button class="flex items-center space-x-2 text-sm text-gray-700 hover:text-gray-900 focus:outline-none">
                                <span class="font-medium">
                                    <?php echo htmlspecialchars($user['first_name'] ?? 'Member'); ?>
                                </span>
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-gray-500 group-hover:text-gray-700" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                                </svg>
                            </button>
                            
                            <!-- Dropdown menu -->
                            <div class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg py-1 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition duration-200 z-50">
                                <a href="/dashboard.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Dashboard</a>
                                <a href="/dashboard-files.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Member records</a>
                                <a href="/dashboard-profile.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Profile</a>
                                <?php if (isset($user['role']) && $user['role'] === 'writer'): ?>
                                <a href="/dashboard-write.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Editorial</a>
                                <?php endif; ?>
                                <div class="border-t border-gray-100 my-1"></div>
                                <a href="/logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100">Logout</a>
                            </div>
                        </div>
                    <?php else: ?>
                        <a href="/login.php" class="text-gray-600 text-sm hover:text-gray-900">Sign in</a>
                        <a href="/signup.php" class="bg-gray-900 px-5 py-2 text-sm text-white rounded-full transition-transform hover:-translate-y-0.5">
                            Become a member
                        </a>
                    <?php endif; ?>
                </div>

                <!-- Menu mobile toggle -->
                <button id="menu-toggle" class="lg:hidden text-gray-500 hover:text-gray-900 focus:outline-none">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 6h16M4 12h16M4 18h16"/>
                    </svg>
                </button>
            </nav>
        </div>
    </div>

    <!-- Menu mobile -->
    <div id="mobile-menu" class="fixed inset-0 bg-white z-50 transform translate-x-full transition-transform duration-300 ease-in-out lg:hidden">
        <div class="container h-full flex flex-col">
            <!-- Header avec bouton fermeture -->
            <div class="flex justify-between items-center p-4 border-b">
                <a href="/" class="text-xl font-medium tracking-tight text-gray-900">Peerkinton</a>
                <button id="close-menu" class="text-gray-500 hover:text-gray-900 focus:outline-none">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                </button>
            </div>
            
            <!-- Contenu menu mobile -->
            <div class="flex-1 overflow-y-auto pt-8 px-6">
                <nav class="flex flex-col space-y-6">
                    <a href="/search/data" class="text-lg text-gray-800 hover:text-gray-900">Search Data</a>
                    <a href="/search/profile" class="text-lg text-gray-800 hover:text-gray-900">Search Profile</a>
                    <a href="/about" class="text-lg text-gray-800 hover:text-gray-900">Enterprise</a>
                </nav>
                
                <div class="mt-10 pt-6 border-t border-gray-100">
                    <?php if (isset($_SESSION['user_id'])): ?>
                        <div class="flex flex-col space-y-4">
                            <span class="font-medium text-gray-900">
                                <?php echo htmlspecialchars($user['first_name'] ?? 'Member'); ?>
                            </span>
                            <a href="/dashboard.php" class="text-gray-700 hover:text-gray-900">Dashboard</a>
                            <a href="/dashboard-files.php" class="text-gray-700 hover:text-gray-900">Member records</a>
                            <a href="/dashboard-profile.php" class="text-gray-700 hover:text-gray-900">Profile</a>
                            <?php if (isset($user['role']) && $user['role'] === 'writer'): ?>
                            <a href="/dashboard-write.php" class="text-gray-700 hover:text-gray-900">Editorial</a>
                            <?php endif; ?>
                            <div class="pt-2"></div>
                            <a href="/logout.php" class="text-red-600 hover:text-red-700">Logout</a>
                        </div>
                    <?php else: ?>
                        <div class="flex flex-col space-y-4">
                            <a href="/login.php" class="text-gray-700 hover:text-gray-900">Sign in</a>
                            <a href="/signup.php" class="bg-gray-900 text-center px-5 py-3 text-white rounded-full">
                                Become a member
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</header>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const menuToggle = document.getElementById('menu-toggle');
        const closeMenu = document.getElementById('close-menu');
        const mobileMenu = document.getElementById('mobile-menu');
        
        // Ouvrir le menu
        menuToggle.addEventListener('click', function() {
            mobileMenu.classList.remove('translate-x-full');
            document.body.style.overflow = 'hidden';
        });
        
        // Fermer le menu
        closeMenu.addEventListener('click', function() {
            mobileMenu.classList.add('translate-x-full');
            document.body.style.overflow = '';
        });
    });
</script>