<?php
require_once 'config.php';

if(isset($_POST['signup'])) {
    $username = $_POST['username'];
    $email = $_POST['email'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $adult_check = isset($_POST['adult']) ? 1 : 0;

    if(!$adult_check) {
        $error = "You must confirm that you are over 18 years old";
    } else {
        try {
            $stmt = $pdo->prepare("INSERT INTO users (username, email, password, adult_verified) VALUES (?, ?, ?, ?)");
            $stmt->execute([$username, $email, $password, $adult_check]);
            
            $_SESSION['user_id'] = $pdo->lastInsertId();
            $_SESSION['username'] = $username;
            header('Location: index.php');
            exit;
        } catch(PDOException $e) {
            $error = "Username or email already exists";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sign Up - ForMore</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Titillium+Web:wght@200;300;400;600;700;900&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Titillium Web', sans-serif;
        }
        .form-container {
            animation: slideUp 0.5s ease-out;
        }
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        .formore {
            font-weight: 900;
            letter-spacing: 2px;
            text-transform: uppercase;
            background: linear-gradient(to right, #3b82f6, #1d4ed8);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.1);
        }
        .input-field {
            @apply w-full bg-gray-700 border border-gray-600 rounded-lg px-4 py-3 focus:outline-none focus:border-blue-500 transition-colors;
        }
        .password-strength {
            height: 4px;
            transition: width 0.3s ease;
        }
    </style>
</head>
<body class="bg-gradient-to-br from-black to-blue-900 min-h-screen flex items-center justify-center p-4">
    <div class="form-container w-full max-w-md">
        <a href="index.php" class="text-4xl formore block text-center mb-8">ForMore</a>
        
        <form method="POST" class="bg-gray-800 rounded-xl shadow-2xl p-8 space-y-6">
            <?php if(isset($error)): ?>
                <div class="bg-red-500/80 backdrop-blur-sm text-white p-4 rounded-lg text-center">
                    <?= $error ?>
                </div>
            <?php endif; ?>

            <div>
                <label class="block text-gray-300 font-semibold mb-2">Username</label>
                <input type="text" name="username" required minlength="3"
                    class="input-field"
                    placeholder="Choose your username">
            </div>

            <div>
                <label class="block text-gray-300 font-semibold mb-2">Email</label>
                <input type="email" name="email" required 
                    class="input-field"
                    placeholder="Enter your email">
            </div>

            <div>
                <label class="block text-gray-300 font-semibold mb-2">Password</label>
                <input type="password" name="password" required minlength="8"
                    class="input-field"
                    placeholder="Choose a strong password"
                    id="password">
                <div class="mt-2 bg-gray-700 rounded">
                    <div class="password-strength bg-red-500 rounded" id="passwordStrength"></div>
                </div>
                <p class="text-xs text-gray-400 mt-1">At least 8 characters</p>
            </div>

            <div class="flex items-start space-x-2">
                <input type="checkbox" name="adult" required id="adult"
                    class="mt-1 w-4 h-4 bg-gray-700 border-gray-600 rounded focus:ring-blue-500">
                <label for="adult" class="text-sm text-gray-300">
                    I confirm that I am over 18 years old and understand that ForMore is a platform intended for adult content only. 
                    I agree to comply with all terms of service and content guidelines.
                </label>
            </div>

            <div class="space-y-4">
                <button type="submit" name="signup" 
                    class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-4 rounded-lg transition-colors">
                    Create Account
                </button>
                
                <div class="relative">
                    <div class="absolute inset-0 flex items-center">
                        <div class="w-full border-t border-gray-600"></div>
                    </div>
                    <div class="relative flex justify-center text-sm">
                        <span class="px-2 bg-gray-800 text-gray-400">Or sign up with</span>
                    </div>
                </div>

                <div class="grid grid-cols-2 gap-4">
                    <button type="button" class="flex items-center justify-center px-4 py-2 border border-gray-600 rounded-lg hover:bg-gray-700 transition-colors">
                        <svg class="w-5 h-5 mr-2" viewBox="0 0 24 24">
                            <path fill="currentColor" d="M12 2C6.477 2 2 6.477 2 12c0 4.418 2.865 8.166 6.839 9.489.5.092.682-.217.682-.482 0-.237-.008-.866-.013-1.7-2.782.603-3.369-1.34-3.369-1.34-.454-1.156-1.11-1.464-1.11-1.464-.908-.62.069-.608.069-.608 1.003.07 1.531 1.03 1.531 1.03.892 1.529 2.341 1.087 2.91.831.092-.646.35-1.086.636-1.336-2.22-.253-4.555-1.11-4.555-4.943 0-1.091.39-1.984 1.029-2.683-.103-.253-.446-1.27.098-2.647 0 0 .84-.269 2.75 1.026A9.564 9.564 0 0112 6.844c.85.004 1.705.115 2.504.337 1.909-1.295 2.747-1.026 2.747-1.026.546 1.377.203 2.394.1 2.647.64.699 1.028 1.592 1.028 2.683 0 3.842-2.339 4.687-4.566 4.935.359.309.678.919.678 1.852 0 1.336-.012 2.415-.012 2.743 0 .267.18.578.688.481C19.138 20.164 22 16.418 22 12c0-5.523-4.477-10-10-10z"/>
                        </svg>
                        GitHub
                    </button>
                    <button type="button" class="flex items-center justify-center px-4 py-2 border border-gray-600 rounded-lg hover:bg-gray-700 transition-colors">
                        <svg class="w-5 h-5 mr-2" viewBox="0 0 24 24">
                            <path fill="currentColor" d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5.36 14.3c-.78-.45-1.26-.78-1.26-1.44 0-.43.27-.8.79-1.24.77-.64 1.11-1.53 1.11-2.62 0-.86-.2-1.62-.59-2.28h.27c.06 0 .1-.02.14-.02l1.92-1.92c.1-.1.14-.22.14-.36v-.04c0-.28-.22-.5-.5-.5h-4.42c-.98-.29-2.03-.44-3.16-.44-1.72 0-3.32.44-4.58 1.32-.02.02-.04.04-.06.05-.63.45-1.13 1.02-1.49 1.71-.36.7-.54 1.46-.54 2.28 0 1.11.29 2.08.88 2.91.58.82 1.38 1.46 2.4 1.92 1.02.45 2.13.68 3.33.68 1.32 0 2.46-.27 3.42-.8v.06c0 .34.03.66.1.96.07.31.17.59.3.84l-1.72 1.72c-.1.1-.14.22-.14.36v.04c0 .28.22.5.5.5h5.98c.28 0 .5-.22.5-.5v-5.98c0-.28-.22-.5-.5-.5h-.32l-1.26.1c-.1-.2-.18-.42-.24-.66-.06-.24-.08-.49-.08-.75 0-.66.48-.99 1.26-1.44.78-.45 1.26-.78 1.26-1.44 0-.66-.48-.99-1.26-1.44-.78-.45-1.26-.78-1.26-1.44s.48-.99 1.26-1.44c.78-.45 1.26-.78 1.26-1.44 0-.88-.7-1.32-2.1-1.32-1.4 0-2.1.44-2.1 1.32 0 .66.48.99 1.26 1.44.78.45 1.26.78 1.26 1.44s-.48.99-1.26 1.44c-.78.45-1.26.78-1.26 1.44s.48.99 1.26 1.44z"/>
                        </svg>
                        Google
                    </button>
                </div>
            </div>

            <p class="text-center text-gray-400">
                Already have an account?
                <a href="login.php" class="text-blue-400 hover:text-blue-300 transition-colors font-semibold ml-1">
                    Sign in
                </a>
            </p>
        </form>
    </div>

    <script>
        const passwordInput = document.getElementById('password');
        const strengthIndicator = document.getElementById('passwordStrength');

        passwordInput.addEventListener('input', function(e) {
            const password = e.target.value;
            let strength = 0;
            
            if(password.length >= 8) strength += 25;
            if(password.match(/[A-Z]/)) strength += 25;
            if(password.match(/[0-9]/)) strength += 25;
            if(password.match(/[^A-Za-z0-9]/)) strength += 25;

            strengthIndicator.style.width = strength + '%';
            
            if(strength <= 25) {
                strengthIndicator.className = 'password-strength bg-red-500 rounded';
            } else if(strength <= 50) {
                strengthIndicator.className = 'password-strength bg-orange-500 rounded';
            } else if(strength <= 75) {
                strengthIndicator.className = 'password-strength bg-yellow-500 rounded';
            } else {
                strengthIndicator.className = 'password-strength bg-green-500 rounded';
            }
        });
    </script>
</body>
</html>