<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

$sites = [
    'https://imators.com',
    'https://imators.be',
    'https://imators.fr',
    'https://imators.eu',
    'https://imators.ae',
    'https://imators.nl',
    'https://imators.jp',
    'https://imators.ch',
    'https://imators.uk',
    'https://imators.co.uk',
    'https://imators.ch',
    'https://imators.systems'
     
];

$searchTag = '<meta name="imators-verification" content="verified">';
$results = [];

function checkSite($url) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 5,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_USERAGENT => 'Imators-Verification/1.0',
        CURLOPT_HTTPHEADER => [
            'Accept: text/html,application/xhtml+xml',
            'Accept-Language: en-US,en;q=0.5'
        ]
    ]);

    $content = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);

    return [
        'content' => $content,
        'httpCode' => $httpCode,
        'error' => $error
    ];
}

foreach ($sites as $site) {
    try {
        $check = checkSite($site);
        
        if ($check['error']) {
            $results[] = [
                'url' => $site,
                'status' => false,
                'error' => 'Connection error: ' . $check['error'],
                'timestamp' => date('Y-m-d H:i:s')
            ];
            continue;
        }

        if ($check['httpCode'] !== 200) {
            $results[] = [
                'url' => $site,
                'status' => false,
                'error' => "HTTP Status: " . $check['httpCode'],
                'timestamp' => date('Y-m-d H:i:s')
            ];
            continue;
        }

        $hasTag = strpos($check['content'], $searchTag) !== false;
        
        $results[] = [
            'url' => $site,
            'status' => $hasTag,
            'error' => null,
            'timestamp' => date('Y-m-d H:i:s'),
            'statusCode' => $check['httpCode']
        ];

    } catch (Exception $e) {
        $results[] = [
            'url' => $site,
            'status' => false,
            'error' => $e->getMessage(),
            'timestamp' => date('Y-m-d H:i:s')
        ];
    }
}

$response = [
    'results' => $results,
    'meta' => [
        'total_sites' => count($sites),
        'verified_sites' => count(array_filter($results, function($r) { return $r['status'] === true; })),
        'check_timestamp' => date('Y-m-d H:i:s')
    ]
];

echo json_encode($response, JSON_PRETTY_PRINT);