<?php
require_once 'functions.php';
checkLogin();

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$action = $_GET['action'] ?? '';

if ($action === 'delete') {
    if (deleteProfile($id)) {
        header("Location: search.php");
        exit();
    }
}

$profile = getProfile($id);

if (!$profile) {
    header("Location: search.php");
    exit();
}

$activityLogs = $db->prepare("
    SELECT a.*, u.username 
    FROM activity_logs a 
    LEFT JOIN users u ON a.user_id = u.id 
    WHERE a.details LIKE ? 
    ORDER BY a.created_at DESC 
    LIMIT 20
");
$activityLogs->execute(["%ID #$id%"]);
$logs = $activityLogs->fetchAll();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peerkinton - Profil de <?php echo htmlspecialchars($profile['full_name']); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Montserrat', sans-serif;
            font-weight: 300;
        }
    </style>
</head>
<body class="bg-white text-gray-800">
    <div class="min-h-screen flex flex-col">
        <header class="bg-white shadow-sm">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 flex justify-between items-center">
                <div class="flex items-center">
                    <h1 class="text-2xl font-light">PEERKINTON</h1>
                </div>
                <nav class="flex space-x-8">
                    <a href="index.php" class="text-gray-600 hover:text-blue-600 font-light">Accueil</a>
                    <a href="search.php" class="text-gray-600 hover:text-blue-600 font-light">Recherche</a>
                    <a href="logout.php" class="text-gray-600 hover:text-red-600 font-light">Déconnexion</a>
                </nav>
            </div>
        </header>

        <main class="flex-grow max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
            <div class="mb-8 flex items-center justify-between">
                <h2 class="text-2xl font-light">Profil de <?php echo htmlspecialchars($profile['full_name']); ?></h2>
                <div class="flex space-x-4">
                    <a href="edit.php?id=<?php echo $profile['id']; ?>" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-md text-sm font-light">
                        Modifier
                    </a>
                    <button 
                        onclick="if(confirm('Êtes-vous sûr de vouloir supprimer ce profil ?')) { window.location.href = '?id=<?php echo $profile['id']; ?>&action=delete'; }" 
                        class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-md text-sm font-light"
                    >
                        Supprimer
                    </button>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <div class="lg:col-span-2">
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <p class="text-sm text-gray-500 mb-1">Nom complet</p>
                                <p class="text-lg font-light"><?php echo htmlspecialchars($profile['full_name']); ?></p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500 mb-1">Email</p>
                                <p class="text-lg font-light"><?php echo htmlspecialchars($profile['email']); ?></p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500 mb-1">Téléphone</p>
                                <p class="text-lg font-light"><?php echo htmlspecialchars($profile['phone']); ?></p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500 mb-1">Date de naissance</p>
                                <p class="text-lg font-light"><?php echo !empty($profile['birth_date']) ? date('d/m/Y', strtotime($profile['birth_date'])) : '-'; ?></p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500 mb-1">Profession</p>
                                <p class="text-lg font-light"><?php echo htmlspecialchars($profile['occupation']); ?></p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500 mb-1">Adresse</p>
                                <p class="text-lg font-light"><?php echo htmlspecialchars($profile['address']); ?></p>
                            </div>
                        </div>

                        <div class="mt-8">
                            <p class="text-sm text-gray-500 mb-1">Notes</p>
                            <div class="bg-gray-50 p-4 rounded-md">
                                <?php if (empty($profile['notes'])): ?>
                                    <p class="text-gray-500 italic">Aucune note</p>
                                <?php else: ?>
                                    <p class="whitespace-pre-line"><?php echo htmlspecialchars($profile['notes']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="mt-8 grid grid-cols-2 gap-4 text-sm text-gray-500">
                            <div>
                                <p>Créé le: <?php echo date('d/m/Y H:i', strtotime($profile['created_at'])); ?></p>
                            </div>
                            <div>
                                <p>Dernière mise à jour: <?php echo date('d/m/Y H:i', strtotime($profile['updated_at'])); ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <div>
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                        <h3 class="text-lg font-light mb-4">Historique des activités</h3>
                        
                        <?php if (empty($logs)): ?>
                            <p class="text-gray-500">Aucune activité enregistrée</p>
                        <?php else: ?>
                            <div class="space-y-4">
                                <?php foreach ($logs as $log): ?>
                                    <div class="flex items-start space-x-3">
                                        <div class="w-2 h-2 rounded-full bg-blue-500 mt-2"></div>
                                        <div class="flex-1">
                                            <p class="text-sm">
                                                <span class="font-medium"><?php echo htmlspecialchars($log['username'] ?? 'Système'); ?></span>
                                                <?php 
                                                switch ($log['action']) {
                                                    case 'create_profile':
                                                        echo 'a créé ce profil';
                                                        break;
                                                    case 'update_profile':
                                                        echo 'a mis à jour ce profil';
                                                        break;
                                                    default:
                                                        echo htmlspecialchars($log['action']);
                                                }
                                                ?>
                                            </p>
                                            <p class="text-xs text-gray-400 mt-1"><?php echo date('d/m/Y H:i:s', strtotime($log['created_at'])); ?></p>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </main>

        <footer class="bg-white border-t border-gray-200 py-6 mt-10">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <p class="text-center text-sm text-gray-500">
                    &copy; <?php echo date('Y'); ?> Peerkinton - Centre privé d'analyse de profils - Tous droits réservés
                </p>
            </div>
        </footer>
    </div>
</body>
</html>