<?php
require 'vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['generate_pdf'])) {
    $options = new Options();
    $options->set('isHtml5ParserEnabled', true);
    
    $dompdf = new Dompdf($options);
    $dompdf->loadHtml($_POST['pdfContent']);
    $dompdf->setPaper('A4', 'landscape');
    $dompdf->render();
    $dompdf->stream("MyDayBetter.pdf", ["Attachment" => true]);
    exit;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MyDayBetter</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4">
        <div id="plannerContent">
            <h1 class="text-3xl font-bold text-center mb-8">MyDayBetter</h1>
            
            <div class="grid gap-4">
                <?php 
                $jours = ['Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi', 'Dimanche'];
                foreach($jours as $jour): ?>
                    <div class="bg-white p-6 rounded-lg shadow-lg">
                        <div class="flex justify-between items-center mb-6">
                            <h2 class="text-2xl font-semibold"><?= $jour ?></h2>
                            <div class="space-x-4">
                                <label class="inline-flex items-center">
                                    <input type="checkbox" class="form-checkbox h-5 w-5 text-blue-600 weekendCheck">
                                    <span class="ml-2">Weekend</span>
                                </label>
                                <label class="inline-flex items-center">
                                    <input type="checkbox" class="form-checkbox h-5 w-5 text-green-600 congeCheck">
                                    <span class="ml-2">Congé</span>
                                </label>
                            </div>
                        </div>
                        
                        <div class="grid gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Rappel</label>
                                <input type="text" class="w-full border-gray-300 rounded-md shadow-sm p-2">
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Devoir</label>
                                <div class="w-8 h-8 border-2 border-gray-400 rounded"></div>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Motivation</label>
                                <textarea rows="2" class="w-full border-gray-300 rounded-md shadow-sm p-2"></textarea>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Humeur</label>
                                <div class="flex space-x-6">
                                    <label class="cursor-pointer">
                                        <input type="radio" name="humeur_<?= $jour ?>" value="good" class="hidden">
                                        <span class="text-2xl opacity-50 hover:opacity-100">😊</span>
                                    </label>
                                    <label class="cursor-pointer">
                                        <input type="radio" name="humeur_<?= $jour ?>" value="neutral" class="hidden">
                                        <span class="text-2xl opacity-50 hover:opacity-100">😐</span>
                                    </label>
                                    <label class="cursor-pointer">
                                        <input type="radio" name="humeur_<?= $jour ?>" value="bad" class="hidden">
                                        <span class="text-2xl opacity-50 hover:opacity-100">😔</span>
                                    </label>
                                </div>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Tâches</label>
                                <div class="space-y-2 task-container">
                                    <input type="text" class="w-full border-gray-300 rounded-md shadow-sm p-2 mb-2 new-task" placeholder="Nouvelle tâche">
                                    <div class="task-list"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <div class="mt-8 flex justify-center">
            <form method="POST" id="pdfForm">
                <input type="hidden" name="pdfContent" id="pdfContent">
                <button type="submit" name="generate_pdf" class="bg-blue-500 text-white px-6 py-2 rounded-lg hover:bg-blue-600">
                    Imprimer en PDF
                </button>
            </form>
        </div>
    </div>

    <script>
        document.querySelectorAll('[type="radio"]').forEach(radio => {
            radio.addEventListener('change', function() {
                const container = this.closest('.flex.space-x-6');
                container.querySelectorAll('span').forEach(span => span.style.opacity = '0.5');
                this.nextElementSibling.style.opacity = '1';
            });
        });

        document.querySelectorAll('.new-task').forEach(input => {
            input.addEventListener('keypress', function(e) {
                if (e.key === 'Enter' && this.value.trim()) {
                    const taskList = this.nextElementSibling;
                    const taskDiv = document.createElement('div');
                    taskDiv.className = 'flex items-center space-x-2 mb-2';
                    taskDiv.innerHTML = `
                        <input type="checkbox" class="form-checkbox h-4 w-4">
                        <span class="flex-1">${this.value}</span>
                        <button type="button" onclick="this.parentElement.remove()" class="text-red-500">&times;</button>
                    `;
                    taskList.appendChild(taskDiv);
                    this.value = '';
                }
            });
        });

        document.querySelector('form').addEventListener('submit', function(e) {
            const content = document.getElementById('plannerContent').innerHTML;
            document.getElementById('pdfContent').value = `
                <html>
                    <head>
                        <style>
                            body { font-family: Arial; }
                            .day { margin-bottom: 20px; padding: 10px; border: 1px solid #ccc; }
                            .task { margin: 5px 0; }
                        </style>
                    </head>
                    <body>
                        ${content}
                    </body>
                </html>
            `;
        });

        const saveToLocalStorage = () => {
            const data = {};
            document.querySelectorAll('.bg-white').forEach((day, index) => {
                const dayName = day.querySelector('h2').textContent;
                data[dayName] = {
                    weekend: day.querySelector('.weekendCheck').checked,
                    conge: day.querySelector('.congeCheck').checked,
                    rappel: day.querySelector('input[type="text"]').value,
                    motivation: day.querySelector('textarea').value,
                    humeur: Array.from(day.querySelectorAll('[type="radio"]')).find(r => r.checked)?.value,
                    tasks: Array.from(day.querySelectorAll('.task-list div')).map(task => ({
                        text: task.querySelector('span').textContent,
                        done: task.querySelector('[type="checkbox"]').checked
                    }))
                };
            });
            localStorage.setItem('mydaybetter', JSON.stringify(data));
        };

        const loadFromLocalStorage = () => {
            const data = JSON.parse(localStorage.getItem('mydaybetter') || '{}');
            Object.entries(data).forEach(([dayName, dayData]) => {
                const dayElement = Array.from(document.querySelectorAll('.bg-white'))
                    .find(day => day.querySelector('h2').textContent === dayName);
                if (dayElement) {
                    dayElement.querySelector('.weekendCheck').checked = dayData.weekend;
                    dayElement.querySelector('.congeCheck').checked = dayData.conge;
                    dayElement.querySelector('input[type="text"]').value = dayData.rappel;
                    dayElement.querySelector('textarea').value = dayData.motivation;
                    if (dayData.humeur) {
                        const radio = dayElement.querySelector(`[value="${dayData.humeur}"]`);
                        if (radio) {
                            radio.checked = true;
                            radio.dispatchEvent(new Event('change'));
                        }
                    }
                    dayData.tasks.forEach(task => {
                        const taskList = dayElement.querySelector('.task-list');
                        const taskDiv = document.createElement('div');
                        taskDiv.className = 'flex items-center space-x-2 mb-2';
                        taskDiv.innerHTML = `
                            <input type="checkbox" class="form-checkbox h-4 w-4" ${task.done ? 'checked' : ''}>
                            <span class="flex-1">${task.text}</span>
                            <button type="button" onclick="this.parentElement.remove()" class="text-red-500">&times;</button>
                        `;
                        taskList.appendChild(taskDiv);
                    });
                }
            });
        };

        document.body.addEventListener('change', saveToLocalStorage);
        document.body.addEventListener('keyup', saveToLocalStorage);
        window.addEventListener('load', loadFromLocalStorage);
    </script>
</body>
</html>