
<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

$host = 'mysql4.ouiheberg.com';
$dbname = 's9104_peerkinton';
$username = 'u9104_v7kuXn4gCe';
$password = '.72c0PS3NYY+g=JnY8E=vuA3';

$auth_codes = [
    'MASTER' => ['role' => 'admin', 'code' => 'IMATORS2024'],
    'SUPPORT' => ['role' => 'support', 'code' => 'SUPPORT2024']
];

function connect_db() {
    global $host, $dbname, $username, $password;
    try {
        $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $pdo;
    } catch(PDOException $e) {
        die("Erreur de connexion : " . $e->getMessage());
    }
}

function format_number($number) {
    return number_format($number, 2, ',', ' ') . ' €';
}

function time_ago($datetime) {
    $time = strtotime($datetime);
    $time_diff = time() - $time;
    
    if($time_diff < 60) return "À l'instant";
    if($time_diff < 3600) return floor($time_diff/60) . " min";
    if($time_diff < 86400) return floor($time_diff/3600) . " h";
    if($time_diff < 604800) return floor($time_diff/86400) . " j";
    return date('d/m/Y', $time);
}

if(isset($_GET['logout'])) {
    session_destroy();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

if(isset($_POST['auth_submit'])) {
    $code = $_POST['auth_code'];
    $found = false;
    
    foreach($auth_codes as $level => $data) {
        if($data['code'] === $code) {
            $_SESSION['auth'] = true;
            $_SESSION['role'] = $data['role'];
            $_SESSION['level'] = $level;
            $found = true;
            break;
        }
    }
    
    if(!$found) {
        $error = "Code d'autorisation invalide";
    }
}

if(isset($_POST['action']) && isset($_SESSION['auth'])) {
    $pdo = connect_db();
    
    switch($_POST['action']) {
        case 'block':
            if($_SESSION['role'] === 'admin') {
                $stmt = $pdo->prepare("UPDATE users SET blocked_account = 'true' WHERE userid = ?");
                $stmt->execute([$_POST['userid']]);
            }
            break;
            
        case 'unblock':
            if($_SESSION['role'] === 'admin') {
                $stmt = $pdo->prepare("UPDATE users SET blocked_account = 'false' WHERE userid = ?");
                $stmt->execute([$_POST['userid']]);
            }
            break;
            
        case 'mark_safe':
            if($_SESSION['role'] === 'admin') {
                $stmt = $pdo->prepare("UPDATE transactions SET status = 'safe' WHERE id = ?");
                $stmt->execute([$_POST['transid']]);
            }
            break;
            
        case 'mark_suspicious':
            if($_SESSION['role'] === 'admin') {
                $stmt = $pdo->prepare("UPDATE transactions SET status = 'suspicious' WHERE id = ?");
                $stmt->execute([$_POST['transid']]);
            }
            break;
    }
    
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

if(!isset($_SESSION['auth'])) {
    include 'login.php';
    exit;
}

$pdo = connect_db();

$stats = [
    'total_balance' => $pdo->query("SELECT SUM(balance) as total FROM users")->fetch()['total'],
    'blocked_accounts' => $pdo->query("SELECT COUNT(*) as count FROM users WHERE blocked_account = 'true'")->fetch()['count'],
    'suspicious_amount' => $pdo->query("SELECT SUM(amount) as total FROM transactions WHERE amount >= 500000")->fetch()['total'],
    'total_users' => $pdo->query("SELECT COUNT(*) as count FROM users")->fetch()['count']
];

$users = $pdo->query("
    SELECT u.*, 
           COUNT(t.id) as transaction_count,
           SUM(CASE WHEN t.amount >= 500000 THEN 1 ELSE 0 END) as suspicious_transactions
    FROM users u
    LEFT JOIN transactions t ON u.userid = t.sender_id
    GROUP BY u.userid
    ORDER BY u.balance DESC
")->fetchAll(PDO::FETCH_ASSOC);

$transactions = $pdo->query("
    SELECT t.*, 
           s.firstname as sender_firstname, s.lastname as sender_lastname,
           r.firstname as recipient_firstname, r.lastname as recipient_lastname
    FROM transactions t
    LEFT JOIN users s ON t.sender_id = s.userid
    LEFT JOIN users r ON t.recipient_id = r.userid
    WHERE t.amount >= 500000
    ORDER BY t.created_at DESC
    LIMIT 50
")->fetchAll(PDO::FETCH_ASSOC);

include 'dashboard.php';
?>