<!DOCTYPE html>
<html lang="en" class="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Izhak Aktas</title>
    <link rel="icon" type="image/x-icon" href="https://forchange.me/profile_picture.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://api.fontshare.com/v2/css?f[]=clash-display@400,500,700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;700&display=swap');
        
        :root {
            --light-bg: #ffffff;
            --light-text: #111827;
            --light-accent: #4f46e5;
            --light-accent-soft: #c7d2fe;
            
            --dark-bg: #0d1117;
            --dark-text: #f3f4f6;
            --dark-accent: #818cf8;
            --dark-accent-soft: #1e1b4b;
        }
        
        .light {
            --bg: var(--light-bg);
            --text: var(--light-text);
            --accent: var(--light-accent);
            --accent-soft: var(--light-accent-soft);
        }
        
        .dark {
            --bg: var(--dark-bg);
            --text: var(--dark-text);
            --accent: var(--dark-accent);
            --accent-soft: var(--dark-accent-soft);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--bg);
            color: var(--text);
            line-height: 1.6;
            transition: background-color 0.3s, color 0.3s;
        }
        
        h1, h2, h3, h4, h5, h6 {
            font-family: 'Clash Display', sans-serif;
            font-weight: 500;
        }
        
        .grain {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: 100vw;
            pointer-events: none;
            z-index: 1000;
            opacity: 0.3;
            background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 250 250' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noiseFilter'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.8' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noiseFilter)' opacity='0.3'/%3E%3C/svg%3E");
        }
        
        /* Nouveau layout avec sidebar */
        .layout {
            display: grid;
            grid-template-columns: 1fr;
            min-height: 100vh;
            position: relative;
        }
        
        @media (min-width: 1024px) {
            .layout {
                grid-template-columns: 300px 1fr;
            }
        }
        
        /* Sidebar */
        .sidebar {
            position: fixed;
            width: 100%;
            height: 60px;
            background-color: var(--bg);
            border-bottom: 1px solid rgba(128, 128, 128, 0.1);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 1.5rem;
            z-index: 50;
        }
        
        @media (min-width: 1024px) {
            .sidebar {
                width: 300px;
                height: 100vh;
                flex-direction: column;
                align-items: flex-start;
                justify-content: flex-start;
                border-right: 1px solid rgba(128, 128, 128, 0.1);
                border-bottom: none;
                padding: 2rem;
                overflow-y: auto;
            }
        }
        
        /* Main content */
        .main-content {
            padding-top: 60px;
            width: 100%;
        }
        
        @media (min-width: 1024px) {
            .main-content {
                padding-top: 0;
                overflow-y: auto;
                height: 100vh;
            }
        }
        
        /* Sidebar content */
        .sidebar-logo {
            display: flex;
            align-items: center;
        }
        
        .logo-text {
            font-weight: 700;
            font-size: 1.25rem;
        }
        
        .sidebar-nav {
            display: none;
        }
        
        @media (min-width: 1024px) {
            .sidebar-nav {
                display: flex;
                flex-direction: column;
                width: 100%;
                margin-top: 3rem;
                gap: 0.25rem;
            }
        }
        
        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            text-decoration: none;
            color: var(--text);
            transition: all 0.2s;
            font-size: 0.875rem;
            opacity: 0.8;
        }
        
        .nav-link:hover {
            background-color: rgba(128, 128, 128, 0.1);
            opacity: 1;
        }
        
        .nav-link.active {
            background-color: var(--accent-soft);
            color: var(--accent);
            opacity: 1;
        }
        
        .light .nav-link.active {
            color: var(--accent);
        }
        
        .dark .nav-link.active {
            color: white;
        }
        
        .sidebar-footer {
            margin-top: auto;
            width: 100%;
            display: none;
        }
        
        @media (min-width: 1024px) {
            .sidebar-footer {
                display: block;
                margin-top: 3rem;
                padding-top: 1.5rem;
                border-top: 1px solid rgba(128, 128, 128, 0.1);
            }
        }
        
        /* Sections */
        .page-section {
            padding: 3rem 1rem;
            scroll-margin-top: 60px;
        }
        
        @media (min-width: 1024px) {
            .page-section {
                padding: 5rem 4rem;
                scroll-margin-top: 0;
                min-height: 100vh;
                display: flex;
                flex-direction: column;
                justify-content: center;
            }
        }
        
        .section-title {
            font-size: 2rem;
            margin-bottom: 1.5rem;
            font-weight: 600;
            line-height: 1.2;
        }
        
        @media (min-width: 768px) {
            .section-title {
                font-size: 3rem;
            }
        }
        
        /* Cards */
        .card {
            background-color: var(--bg);
            border: 1px solid rgba(128, 128, 128, 0.1);
            border-radius: 0.5rem;
            padding: 1.5rem;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px -5px rgba(0, 0, 0, 0.1);
        }
        
        /* Tags */
        .tag {
            display: inline-block;
            padding: 0.25rem 0.75rem;
            border-radius: 9999px;
            font-size: 0.75rem;
            background-color: var(--accent-soft);
            color: var(--accent);
        }
        
        .light .tag {
            color: var(--accent);
        }
        
        .dark .tag {
            color: white;
        }
        
        /* Hero section */
        .hero-section {
            position: relative;
            overflow: hidden;
        }
        
        .hero-bg {
            position: absolute;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            background: linear-gradient(to bottom right, rgba(79, 70, 229, 0.1), transparent);
            opacity: 0.5;
            z-index: -1;
        }
        
        .dark .hero-bg {
            background: linear-gradient(to bottom right, rgba(129, 140, 248, 0.1), transparent);
        }
        
        /* Mobile menu */
        .mobile-nav-toggle {
            display: block;
            background: none;
            border: none;
            color: var(--text);
            font-size: 1.5rem;
            cursor: pointer;
        }
        
        @media (min-width: 1024px) {
            .mobile-nav-toggle {
                display: none;
            }
        }
        
        .mobile-nav {
            position: fixed;
            top: 60px;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: var(--bg);
            padding: 1.5rem;
            z-index: 40;
            transform: translateX(-100%);
            transition: transform 0.3s;
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }
        
        .mobile-nav.open {
            transform: translateX(0);
        }
        
        .mobile-nav .nav-link {
            padding: 1rem;
            border-radius: 0.5rem;
        }
        
        /* Theme toggle */
        .theme-toggle {
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 0.5rem;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: transparent;
            border: 1px solid rgba(128, 128, 128, 0.1);
            color: var(--text);
            cursor: pointer;
        }
        
        /* Image styles */
        .img-container {
            overflow: hidden;
            border-radius: 0.5rem;
        }
        
        .img-zoom {
            transition: transform 0.5s;
        }
        
        .img-container:hover .img-zoom {
            transform: scale(1.05);
        }
        
        /* Buttons */
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1.5rem;
            border-radius: 0.5rem;
            font-weight: 500;
            transition: all 0.2s;
            text-decoration: none;
        }
        
        .btn-primary {
            background-color: var(--accent);
            color: white;
        }
        
        .btn-primary:hover {
            opacity: 0.9;
        }
        
        .btn-outline {
            border: 1px solid rgba(128, 128, 128, 0.3);
            color: var(--text);
        }
        
        .btn-outline:hover {
            border-color: var(--accent);
            color: var(--accent);
        }
        
        /* Animations */
        @keyframes fadeUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .animate-fade-up {
            opacity: 0;
            animation: fadeUp 0.6s ease forwards;
        }
        
        .delay-100 { animation-delay: 0.1s; }
        .delay-200 { animation-delay: 0.2s; }
        .delay-300 { animation-delay: 0.3s; }
        .delay-400 { animation-delay: 0.4s; }
        .delay-500 { animation-delay: 0.5s; }
    </style>
</head>
<body>
    <div class="grain"></div>
    
    <div class="layout">
        <!-- Sidebar/Header -->
        <aside class="sidebar">
            <div class="sidebar-logo">
                <h1 class="logo-text">Izhak<span class="text-indigo-600 dark:text-indigo-400">.</span></h1>
            </div>
            
            <button class="mobile-nav-toggle" aria-label="Toggle navigation menu">
                <i class="fas fa-bars"></i>
            </button>
            
            <nav class="sidebar-nav">
                <a href="#home" class="nav-link active">
                    <i class="fas fa-home"></i>
                    <span>Home</span>
                </a>
                <a href="#about" class="nav-link">
                    <i class="fas fa-user"></i>
                    <span>About</span>
                </a>
                <a href="#projects" class="nav-link">
                    <i class="fas fa-briefcase"></i>
                    <span>Projects</span>
                </a>
                <a href="#skills" class="nav-link">
                    <i class="fas fa-code"></i>
                    <span>Skills</span>
                </a>
                <a href="#media" class="nav-link">
                    <i class="fas fa-music"></i>
                    <span>Media</span>
                </a>
                <a href="#contact" class="nav-link">
                    <i class="fas fa-envelope"></i>
                    <span>Contact</span>
                </a>
            </nav>
            
            <div class="sidebar-footer">
                <div class="flex items-center justify-between mb-6">
                    <p class="text-sm opacity-60">Theme</p>
                    <button class="theme-toggle">
                        <i class="fas fa-moon dark:hidden"></i>
                        <i class="fas fa-sun hidden dark:block"></i>
                    </button>
                </div>
                
                <div class="flex flex-col gap-2">
                    <p class="text-sm opacity-80">Connect with me</p>
                    <div class="flex gap-2 mt-2">
                        <a href="#" class="w-9 h-9 rounded-full flex items-center justify-center border border-gray-200 dark:border-gray-700 hover:border-indigo-500 dark:hover:border-indigo-400 transition-colors">
                            <i class="fab fa-discord"></i>
                        </a>
                        <a href="#" class="w-9 h-9 rounded-full flex items-center justify-center border border-gray-200 dark:border-gray-700 hover:border-indigo-500 dark:hover:border-indigo-400 transition-colors">
                            <i class="fab fa-github"></i>
                        </a>
                        <a href="#" class="w-9 h-9 rounded-full flex items-center justify-center border border-gray-200 dark:border-gray-700 hover:border-indigo-500 dark:hover:border-indigo-400 transition-colors">
                            <i class="fab fa-linkedin"></i>
                        </a>
                    </div>
                </div>
            </div>
        </aside>
        
        <!-- Mobile Navigation -->
        <div class="mobile-nav">
            <a href="#home" class="nav-link active">
                <i class="fas fa-home"></i>
                <span>Home</span>
            </a>
            <a href="#about" class="nav-link">
                <i class="fas fa-user"></i>
                <span>About</span>
            </a>
            <a href="#projects" class="nav-link">
                <i class="fas fa-briefcase"></i>
                <span>Projects</span>
            </a>
            <a href="#skills" class="nav-link">
                <i class="fas fa-code"></i>
                <span>Skills</span>
            </a>
            <a href="#media" class="nav-link">
                <i class="fas fa-music"></i>
                <span>Media</span>
            </a>
            <a href="#contact" class="nav-link">
                <i class="fas fa-envelope"></i>
                <span>Contact</span>
            </a>
            
            <div class="mt-auto pt-4 border-t border-gray-200 dark:border-gray-700">
                <div class="flex items-center justify-between mb-4">
                    <p class="text-sm opacity-60">Theme</p>
                    <button class="theme-toggle">
                        <i class="fas fa-moon dark:hidden"></i>
                        <i class="fas fa-sun hidden dark:block"></i>
                    </button>
                </div>
                
                <div class="flex flex-col gap-2">
                    <p class="text-sm opacity-80">Connect with me</p>
                    <div class="flex gap-2 mt-2">
                        <a href="#" class="w-9 h-9 rounded-full flex items-center justify-center border border-gray-200 dark:border-gray-700 hover:border-indigo-500 dark:hover:border-indigo-400 transition-colors">
                            <i class="fab fa-discord"></i>
                        </a>
                        <a href="#" class="w-9 h-9 rounded-full flex items-center justify-center border border-gray-200 dark:border-gray-700 hover:border-indigo-500 dark:hover:border-indigo-400 transition-colors">
                            <i class="fab fa-github"></i>
                        </a>
                        <a href="#" class="w-9 h-9 rounded-full flex items-center justify-center border border-gray-200 dark:border-gray-700 hover:border-indigo-500 dark:hover:border-indigo-400 transition-colors">
                            <i class="fab fa-linkedin"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Main Content -->
        <main class="main-content">
            <!-- Hero Section -->
            <section id="home" class="page-section hero-section">
                <div class="hero-bg"></div>
                <div class="max-w-4xl">
                    <div class="animate-fade-up">
                        <span class="inline-block py-1 px-3 rounded-full text-xs font-medium bg-indigo-100 text-indigo-700 dark:bg-indigo-900 dark:text-indigo-300 mb-4">Web Developer & CEO</span>
                    </div>
                    
                    <h1 class="text-4xl md:text-6xl font-bold mb-6 animate-fade-up delay-100">Building <span class="text-indigo-600 dark:text-indigo-400">digital experiences</span> that matter.</h1>
                    
                    <p class="text-lg md:text-xl opacity-80 max-w-2xl mb-8 animate-fade-up delay-200">
                        For me, every day makes us learn something new or enjoy everyday life. My goal has always been to share, observe and appreciate the moment day by day.
                    </p>
                    
                    <div class="flex flex-wrap gap-4 animate-fade-up delay-300">
                        <a href="#projects" class="btn btn-primary">
                            View My Work
                            <i class="fas fa-arrow-right"></i>
                        </a>
                        <a href="https://discord.com/users/866001325657292801" class="btn btn-outline">
                            <i class="fab fa-discord"></i>
                            Connect on Discord
                        </a>
                    </div>
                </div>
            </section>

            <!-- About Section -->
            <section id="about" class="page-section">
                <h2 class="section-title">About Me</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-16">
                    <div class="flex flex-col justify-center">
                        <span class="text-sm font-medium text-indigo-600 dark:text-indigo-400 mb-2">My Journey</span>
                        <h3 class="text-2xl font-semibold mb-4">From Curiosity to Creation</h3>
                        <p class="opacity-80 mb-4">
                            I'm a web developer and entrepreneur based in Europe. My journey in tech started with a simple curiosity about how websites work, and it has evolved into a passion for creating digital experiences that matter.
                        </p>
                        <p class="opacity-80">
                            As the CEO of Imators, I lead a team dedicated to developing technology that enhances daily life without compromising human connection. We believe in innovation that serves people, not the other way around.
                        </p>
                    </div>
                    
                    <div class="card p-6 md:p-8">
                        <div class="flex items-center justify-center mb-6">
                            <div class="w-12 h-12 rounded-full bg-indigo-100 dark:bg-indigo-900 flex items-center justify-center text-indigo-600 dark:text-indigo-400">
                                <i class="fas fa-lightbulb"></i>
                            </div>
                        </div>
                        
                        <h3 class="text-xl font-semibold mb-4 text-center">My Approach</h3>
                        
                        <div class="space-y-6">
                            <div class="flex gap-4 items-start">
                                <div class="w-8 h-8 rounded-full bg-indigo-100 dark:bg-indigo-900 flex items-center justify-center text-indigo-600 dark:text-indigo-400 flex-shrink-0">
                                    <i class="fas fa-user-friends text-sm"></i>
                                </div>
                                <div>
                                    <h4 class="font-medium mb-1">Human-Centered</h4>
                                    <p class="text-sm opacity-80">I go beyond the project by entering the mindset of customers to really understand their needs.</p>
                                </div>
                            </div>
                            
                            <div class="flex gap-4 items-start">
                                <div class="w-8 h-8 rounded-full bg-indigo-100 dark:bg-indigo-900 flex items-center justify-center text-indigo-600 dark:text-indigo-400 flex-shrink-0">
                                    <i class="fas fa-code text-sm"></i>
                                </div>
                                <div>
                                    <h4 class="font-medium mb-1">Clean Code</h4>
                                    <p class="text-sm opacity-80">I believe in writing clean, maintainable code that's built to last and easy to understand.</p>
                                </div>
                            </div>
                            
                            <div class="flex gap-4 items-start">
                                <div class="w-8 h-8 rounded-full bg-indigo-100 dark:bg-indigo-900 flex items-center justify-center text-indigo-600 dark:text-indigo-400 flex-shrink-0">
                                    <i class="fas fa-rocket text-sm"></i>
                                </div>
                                <div>
                                    <h4 class="font-medium mb-1">Fast & Efficient</h4>
                                    <p class="text-sm opacity-80">I prioritize performance and efficiency in everything I build, creating smooth experiences.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="card p-6 md:p-8">
                    <div class="flex flex-wrap md:flex-nowrap gap-8 items-center">
                        <div class="text-center md:text-left">
                            <h3 class="text-2xl font-semibold mb-4">Years of Experience</h3>
                            <p class="text-4xl md:text-6xl font-bold text-indigo-600 dark:text-indigo-400">3+</p>
                        </div>
                        
                        <div class="w-full md:w-px h-px md:h-20 bg-gray-200 dark:bg-gray-700"></div>
                        
                        <div class="text-center md:text-left">
                            <h3 class="text-2xl font-semibold mb-4">Projects Completed*</h3>
                            <p class="text-4xl md:text-6xl font-bold text-indigo-600 dark:text-indigo-400">257+</p>
                        </div>
                        
                        <div class="w-full md:w-px h-px md:h-20 bg-gray-200 dark:bg-gray-700"></div>
                        
                        <div class="text-center md:text-left">
                            <h3 class="text-2xl font-semibold mb-4">Companies Founded</h3>
                            <p class="text-4xl md:text-6xl font-bold text-indigo-600 dark:text-indigo-400">1</p>
                        </div>
                    </div>
                </div>
            </section>
            
            <!-- Projects Section -->
            <section id="projects" class="page-section bg-gray-50 dark:bg-slate-900">
                <div class="mb-16">
                    <h2 class="section-title">Featured Projects</h2>
                    <p class="text-lg opacity-80 max-w-2xl">A collection of projects I've worked on, from company websites to personal passion projects.</p>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <div class="card overflow-hidden flex flex-col">
                        <div class="img-container h-60">
                            <img src="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001" 
                                 alt="Imators Platform" class="w-full h-full object-cover img-zoom">
                        </div>
                        
                        <div class="p-6 flex-grow flex flex-col">
                            <div class="flex justify-between items-start mb-4">
                                <h3 class="text-xl font-semibold">Imators</h3>
                                <span class="tag">2022</span>
                            </div>
                            
                            <p class="text-sm opacity-80 mb-4 flex-grow">
                                Imators is my company. When I set up the company, I had the overriding objective of never using AI for automation or any other purpose. Our aim is to preserve the human being and push him forward by letting him be the actor of what he owns.
                            </p>
                            
                            <div class="flex flex-wrap gap-2 mb-6">
                                <span class="tag">PHP</span>
                                <span class="tag">HTML</span>
                                <span class="tag">JS</span>
                            </div>
                            
                            <a href="https://imators.com" class="btn btn-outline w-full">
                                Visit Website
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                    
                    <div class="card overflow-hidden flex flex-col">
                        <div class="img-container h-60">
                            <img src="https://www.worldclassweddingvenues.com/Images/worldclassweddingvenues/User_0/Venue_17816/villattitude-exterieur-11-copie.jpg" 
                                 alt="Vert Chasseur" class="w-full h-full object-cover img-zoom">
                        </div>
                        
                        <div class="p-6 flex-grow flex flex-col">
                            <div class="flex justify-between items-start mb-4">
                                <h3 class="text-xl font-semibold">Vert Chasseur</h3>
                                <span class="tag">2025</span>
                            </div>
                            
                            <p class="text-sm opacity-80 mb-4 flex-grow">
                                The aim of this site is to provide a little hobby. I designed it for the area where I spend most of my days. I'm going to make it progress little by little but it's not my priority, just a little occupation.
                            </p>
                            
                            <div class="flex flex-wrap gap-2 mb-6">
                                <span class="tag">PHP</span>
                                <span class="tag">HTML</span>
                                <span class="tag">JS</span>
                                <span class="tag">SQL</span>
                            </div>
                            
                            <a href="https://vertchasseur.com" class="btn btn-outline w-full">
                                Visit Website
                                <i class="fas fa-arrow-right"></i>
                                </a>
                        </div>
                    </div>
                    
                    <div class="card overflow-hidden flex flex-col">
                        <div class="img-container h-60">
                            <img src="https://opengraph.b-cdn.net/production/images/7d08cca6-56aa-42d1-a641-f9f44914ea12.png?token=jXDBoGRjIgGiGA3pNhDAtPJ8odoJIiQ_1zznvH6RNR0&height=630&width=1200&expires=33258602552" 
                                 alt="Gemance" class="w-full h-full object-cover img-zoom">
                        </div>
                        
                        <div class="p-6 flex-grow flex flex-col">
                            <div class="flex justify-between items-start mb-4">
                                <h3 class="text-xl font-semibold">Gemance</h3>
                                <span class="tag">2023</span>
                            </div>
                            
                            <p class="text-sm opacity-80 mb-4 flex-grow">
                                For a brief moment, I was thinking of selling the stones I was collecting. Unfortunately this project was going to take me too much time. So I left them on display.
                            </p>
                            
                            <div class="flex flex-wrap gap-2 mb-6">
                                <span class="tag">HTML</span>
                                <span class="tag">JS</span>
                                <span class="tag">StripeAPI</span>
                            </div>
                            
                            <a href="https://www.gemance.com/" class="btn btn-outline w-full">
                                Visit Website
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                    
                    <div class="card overflow-hidden flex flex-col">
                        <div class="img-container h-60">
                            <img src="peerkinton_image.png" 
                                 alt="Peerkinton" class="w-full h-full object-cover img-zoom">
                        </div>
                        
                        <div class="p-6 flex-grow flex flex-col">
                            <div class="flex justify-between items-start mb-4">
                                <h3 class="text-xl font-semibold">Peerkinton</h3>
                                <span class="tag">2025</span>
                            </div>
                            
                            <p class="text-sm opacity-80 mb-4 flex-grow">
                                Peerkinton was founded in England in 2016. The aim was to create an institution dedicated to technological learning and study by offering our members high-end digital access.
                            </p>
                            
                            <div class="flex flex-wrap gap-2 mb-6">
                                <span class="tag">PHP</span>
                                <span class="tag">HTML</span>
                                <span class="tag">JS</span>
                                <span class="tag">SQL</span>
                            </div>
                            
                            <a href="https://peerkinton.com" class="btn btn-outline w-full">
                                Visit Website
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </section>
            
            <!-- Skills Section -->
            <section id="skills" class="page-section">
                <h2 class="section-title">Skills & Technologies</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                    <div class="card p-6">
                        <div class="flex items-center justify-center mb-6">
                            <div class="w-12 h-12 rounded-full bg-indigo-100 dark:bg-indigo-900 flex items-center justify-center text-indigo-600 dark:text-indigo-400">
                                <i class="fas fa-code"></i>
                            </div>
                        </div>
                        
                        <h3 class="text-xl font-semibold mb-4 text-center">Frontend</h3>
                        
                        <div class="grid grid-cols-2 gap-4">
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>HTML</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>CSS</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>JavaScript</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>React</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>Tailwind CSS</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>jQuery</span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card p-6">
                        <div class="flex items-center justify-center mb-6">
                            <div class="w-12 h-12 rounded-full bg-indigo-100 dark:bg-indigo-900 flex items-center justify-center text-indigo-600 dark:text-indigo-400">
                                <i class="fas fa-server"></i>
                            </div>
                        </div>
                        
                        <h3 class="text-xl font-semibold mb-4 text-center">Backend</h3>
                        
                        <div class="grid grid-cols-2 gap-4">
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>PHP</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>SQL</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>Node.js</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>Python</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>MySQL</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>REST APIs</span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card p-6">
                        <div class="flex items-center justify-center mb-6">
                            <div class="w-12 h-12 rounded-full bg-indigo-100 dark:bg-indigo-900 flex items-center justify-center text-indigo-600 dark:text-indigo-400">
                                <i class="fas fa-tools"></i>
                            </div>
                        </div>
                        
                        <h3 class="text-xl font-semibold mb-4 text-center">Tools & Others</h3>
                        
                        <div class="grid grid-cols-2 gap-4">
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>Git</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>Apache</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>Linux</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>Figma</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>VS Code</span>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-2 h-2 rounded-full bg-indigo-500"></div>
                                <span>C++</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="mt-16">
                    <h3 class="text-2xl font-semibold mb-8">What I'm Currently Learning</h3>
                    
                    <div class="card p-6">
                        <div class="flex flex-col md:flex-row gap-8 items-center">
                            <div class="md:w-1/3 text-center">
                                <div class="w-20 h-20 rounded-full bg-indigo-100 dark:bg-indigo-900 flex items-center justify-center text-indigo-600 dark:text-indigo-400 mx-auto">
                                    <i class="fab fa-react text-3xl"></i>
                                </div>
                                <h4 class="text-xl font-medium mt-4">React Native</h4>
                                <p class="text-sm opacity-70 mt-2">Mobile app development</p>
                            </div>
                            
                            <div class="md:w-1/3 text-center">
                                <div class="w-20 h-20 rounded-full bg-indigo-100 dark:bg-indigo-900 flex items-center justify-center text-indigo-600 dark:text-indigo-400 mx-auto">
                                    <i class="fas fa-cubes text-3xl"></i>
                                </div>
                                <h4 class="text-xl font-medium mt-4">Three.js</h4>
                                <p class="text-sm opacity-70 mt-2">3D web experiences</p>
                            </div>
                            
                            <div class="md:w-1/3 text-center">
                                <div class="w-20 h-20 rounded-full bg-indigo-100 dark:bg-indigo-900 flex items-center justify-center text-indigo-600 dark:text-indigo-400 mx-auto">
                                    <i class="fas fa-shield-alt text-3xl"></i>
                                </div>
                                <h4 class="text-xl font-medium mt-4">Cybersecurity</h4>
                                <p class="text-sm opacity-70 mt-2">Web application security</p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            
            <!-- Media Section -->
            <section id="media" class="page-section bg-gray-50 dark:bg-slate-900">
                <h2 class="section-title">Media & Favorites</h2>
                
                <div class="mb-16">
                    <h3 class="text-2xl font-semibold mb-8">Favorite Albums</h3>
                    
                    <div class="grid grid-cols-2 sm:grid-cols-3 lg:grid-cols-4 gap-6">
                        <div class="card p-4 overflow-hidden flex flex-col">
                            <div class="img-container aspect-square mb-4">
                                <img src="https://media.pitchfork.com/photos/6662e6122ce1ce711b18e944/master/w_1280%2Cc_limit/Sabrina-Carpenter-Short-n-Sweet.jpg" 
                                     class="w-full h-full object-cover img-zoom" alt="Album cover">
                            </div>
                            <h4 class="font-medium mb-1">Short n' Sweet</h4>
                            <p class="text-sm opacity-60 mb-2">Sabrina Carpenter</p>
                            <a href="https://music.apple.com/uk/album/short-n-sweet/1750307020" class="text-indigo-600 dark:text-indigo-400 text-xs mt-auto hover:underline">Apple Music</a>
                        </div>
                        
                        <div class="card p-4 overflow-hidden flex flex-col">
                            <div class="img-container aspect-square mb-4">
                                <img src="https://i.scdn.co/image/ab67616d0000b273d0bbd3ea2ec554f17a6603cc" 
                                     class="w-full h-full object-cover img-zoom" alt="Album cover">
                            </div>
                            <h4 class="font-medium mb-1">An Evening with Silk Sonic</h4>
                            <p class="text-sm opacity-60 mb-2">Bruno Mars & Anderson .Paak</p>
                            <a href="https://music.apple.com/album/short-n-sweet/1728313338" class="text-indigo-600 dark:text-indigo-400 text-xs mt-auto hover:underline">Apple Music</a>
                        </div>
                        
                        <div class="card p-4 overflow-hidden flex flex-col">
                            <div class="img-container aspect-square mb-4">
                                <img src="https://i.scdn.co/image/ab67616d0000b273e8107e6d9214baa81bb79bba" 
                                     class="w-full h-full object-cover img-zoom" alt="Album cover">
                            </div>
                            <h4 class="font-medium mb-1">GIRL</h4>
                            <p class="text-sm opacity-60 mb-2">Pharrell Williams</p>
                            <a href="https://music.apple.com/be/album/g-i-r-l/863835302" class="text-indigo-600 dark:text-indigo-400 text-xs mt-auto hover:underline">Apple Music</a>
                        </div>
                        
                        <div class="card p-4 overflow-hidden flex flex-col">
                            <div class="img-container aspect-square mb-4">
                                <img src="https://i.scdn.co/image/ab67616d0000b2734bc66095f8a70bc4e6593f4f" 
                                     class="w-full h-full object-cover img-zoom" alt="Album cover">
                            </div>
                            <h4 class="font-medium mb-1">Future Nostalgia</h4>
                            <p class="text-sm opacity-60 mb-2">Dua Lipa</p>
                            <a href="https://music.apple.com/be/album/future-nostalgia/1538003494" class="text-indigo-600 dark:text-indigo-400 text-xs mt-auto hover:underline">Apple Music</a>
                        </div>
                    </div>
                </div>
                
                <div>
                    <h3 class="text-2xl font-semibold mb-8">Watching Now</h3>
                    
                    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-8">
                        <div class="card p-4 overflow-hidden flex flex-col">
                            <div class="img-container aspect-[2/3] mb-4">
                                <img src="https://seriesonweb.com/wp-content/uploads/2024/04/Sugar.jpg" 
                                     class="w-full h-full object-cover img-zoom" alt="Sugar">
                            </div>
                            <h4 class="font-medium mb-1">Sugar</h4>
                            <div class="flex items-center gap-2 mt-2">
                                <span class="tag">Series</span>
                                <a href="https://tv.apple.com/be/show/sugar/umc.cmc.4r6q7tdquewehwvb3rzl0k3dtm" class="text-indigo-600 dark:text-indigo-400 text-xs hover:underline">Apple TV+</a>
                            </div>
                        </div>
                        
                        <div class="card p-4 overflow-hidden flex flex-col">
                            <div class="img-container aspect-[2/3] mb-4">
                                <img src="https://preview.redd.it/fly-me-to-the-moon-2024-textless-v0-y4htoeerwezc1.jpeg?auto=webp&s=841eca3463d5408f09090df6a2a7e645eee100f9" 
                                     class="w-full h-full object-cover img-zoom" alt="To The Moon">
                            </div>
                            <h4 class="font-medium mb-1">Fly Me to The Moon</h4>
                            <div class="flex items-center gap-2 mt-2">
                                <span class="tag">Movie</span>
                                <a href="https://tv.apple.com/be/movie/to-the-moon/umc.cmc.7bwrikjdeik56bk49vlr7c1h6" class="text-indigo-600 dark:text-indigo-400 text-xs hover:underline">Apple TV+</a>
                            </div>
                        </div>
                        
                        <div class="card p-4 overflow-hidden flex flex-col">
                            <div class="img-container aspect-[2/3] mb-4">
                                <img src="https://resize.elle.fr/original/var/plain_site/storage/images/loisirs/series/ces-films-et-series-a-regarder-si-vous-avez-aime-lupin-dans-l-ombre-d-arsene/94289862-3-fre-FR/7-films-et-series-a-regarder-si-vous-avez-aime-Lupin-dans-l-ombre-d-Arsene.jpg" 
                                     class="w-full h-full object-cover img-zoom" alt="Lupin">
                            </div>
                            <h4 class="font-medium mb-1">Lupin</h4>
                            <div class="flex items-center gap-2 mt-2">
                                <span class="tag">Series</span>
                                <a href="#" class="text-indigo-600 dark:text-indigo-400 text-xs hover:underline">Netflix</a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            
            <!-- Contact Section -->
            <section id="contact" class="page-section">
                <h2 class="section-title">Get In Touch</h2>
                
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                    <div>
                        <p class="text-lg opacity-80 mb-8">
                            Have a project in mind or just want to connect? Feel free to reach out and I'll get back to you as soon as possible.
                        </p>
                        
                        <div class="space-y-6">
                            <div class="flex items-center gap-4">
                                <div class="w-10 h-10 rounded-full bg-indigo-100 dark:bg-indigo-900 flex items-center justify-center text-indigo-600 dark:text-indigo-400">
                                    <i class="fab fa-discord"></i>
                                </div>
                                <div>
                                    <h4 class="font-medium">Discord</h4>
                                    <a href="https://discord.com/users/866001325657292801" class="text-indigo-600 dark:text-indigo-400 hover:underline">Connect on Discord</a>
                                </div>
                            </div>
                            
                            <div class="flex items-center gap-4">
                                <div class="w-10 h-10 rounded-full bg-indigo-100 dark:bg-indigo-900 flex items-center justify-center text-indigo-600 dark:text-indigo-400">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <div>
                                    <h4 class="font-medium">Email</h4>
                                    <a href="mailto:contact@example.com" class="text-indigo-600 dark:text-indigo-400 hover:underline">contact@example.com</a>
                                </div>
                            </div>
                            
                            <div class="flex items-center gap-4">
                                <div class="w-10 h-10 rounded-full bg-indigo-100 dark:bg-indigo-900 flex items-center justify-center text-indigo-600 dark:text-indigo-400">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <div>
                                    <h4 class="font-medium">Location</h4>
                                    <p class="opacity-80">Europe</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card p-6">
                        <h3 class="text-xl font-semibold mb-6">Send a Message</h3>
                        
                        <form>
                            <div class="mb-4">
                                <label for="name" class="block text-sm font-medium mb-2">Name</label>
                                <input type="text" id="name" class="w-full p-3 rounded-md border border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 focus:outline-none focus:border-indigo-500 dark:focus:border-indigo-400 transition-colors">
                            </div>
                            
                            <div class="mb-4">
                                <label for="email" class="block text-sm font-medium mb-2">Email</label>
                                <input type="email" id="email" class="w-full p-3 rounded-md border border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 focus:outline-none focus:border-indigo-500 dark:focus:border-indigo-400 transition-colors">
                            </div>
                            
                            <div class="mb-4">
                                <label for="message" class="block text-sm font-medium mb-2">Message</label>
                                <textarea id="message" rows="4" class="w-full p-3 rounded-md border border-gray-200 dark:border-gray-700 bg-white dark:bg-slate-800 focus:outline-none focus:border-indigo-500 dark:focus:border-indigo-400 transition-colors"></textarea>
                            </div>
                            
                            <button type="submit" class="btn btn-primary w-full">
                                Send Message
                                <i class="fas fa-paper-plane"></i>
                            </button>
                        </form>
                    </div>
                </div>
            </section>
        </main>
    </div>
    
    <footer class="py-8 bg-gray-50 dark:bg-slate-900 border-t border-gray-200 dark:border-gray-800">
        <div class="container mx-auto px-4">
            <div class="flex flex-col md:flex-row justify-between items-center gap-4">
                <div>
                    <p class="text-sm opacity-70">© 2025 Izhak. All rights reserved.</p>
                </div>
                
                <div>
                    <p class="text-sm opacity-70">*This number indicates customer projects, not personal ones.</p>
                </div>
            </div>
        </div>
    </footer>
    
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Theme toggling
            const html = document.documentElement;
            const themeToggles = document.querySelectorAll('.theme-toggle');
            
            // Check system preference
            const prefersDark = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;
            
            if (prefersDark) {
                html.classList.remove('light');
                html.classList.add('dark');
                document.querySelectorAll('.fa-moon').forEach(el => el.classList.add('hidden'));
                document.querySelectorAll('.fa-sun').forEach(el => el.classList.remove('hidden'));
            }
            
            themeToggles.forEach(toggle => {
                toggle.addEventListener('click', () => {
                    html.classList.toggle('light');
                    html.classList.toggle('dark');
                    document.querySelectorAll('.fa-moon').forEach(el => el.classList.toggle('hidden'));
                    document.querySelectorAll('.fa-sun').forEach(el => el.classList.toggle('hidden'));
                });
            });
            
            // Mobile menu
            const mobileNavToggle = document.querySelector('.mobile-nav-toggle');
            const mobileNav = document.querySelector('.mobile-nav');
            
            mobileNavToggle.addEventListener('click', () => {
                mobileNav.classList.toggle('open');
                
                if (mobileNav.classList.contains('open')) {
                    mobileNavToggle.innerHTML = '<i class="fas fa-times"></i>';
                } else {
                    mobileNavToggle.innerHTML = '<i class="fas fa-bars"></i>';
                }
            });
            
            // Navigation
            const navLinks = document.querySelectorAll('.nav-link');
            
            navLinks.forEach(link => {
                link.addEventListener('click', (e) => {
                    const targetId = link.getAttribute('href');
                    
                    // Close mobile menu if open
                    if (mobileNav.classList.contains('open')) {
                        mobileNav.classList.remove('open');
                        mobileNavToggle.innerHTML = '<i class="fas fa-bars"></i>';
                    }
                    
                    // Set active state
                    navLinks.forEach(navLink => navLink.classList.remove('active'));
                    document.querySelectorAll(`.nav-link[href="${targetId}"]`).forEach(el => el.classList.add('active'));
                });
            });
            
            // Handle scrolling to set active navigation
            const sections = document.querySelectorAll('.page-section');
            
            const observerOptions = {
                root: null,
                rootMargin: '0px',
                threshold: 0.5
            };
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const id = entry.target.getAttribute('id');
                        navLinks.forEach(navLink => navLink.classList.remove('active'));
                        document.querySelectorAll(`.nav-link[href="#${id}"]`).forEach(el => el.classList.add('active'));
                    }
                });
            }, observerOptions);
            
            sections.forEach(section => {
                observer.observe(section);
            });
        });
    </script>
</body>
</html>