<?php
require_once 'db.php';
require_once 'gov/functions_loterie.php';

echo "=== DÉBUT DU TIRAGE AUTOMATIQUE ===\n";
echo "Date : " . date('Y-m-d H:i:s') . "\n\n";

$sql = "SELECT * FROM loteries WHERE date_tirage = CURDATE() AND statut = 'ouvert'";
$result = $conn->query($sql);

if($result->num_rows == 0) {
    echo "Aucune loterie à tirer aujourd'hui.\n";
    exit();
}

while($loterie = $result->fetch_assoc()) {
    echo "Traitement de la loterie : " . $loterie['nom'] . " (ID: " . $loterie['id'] . ")\n";
    
    try {
        $conn->begin_transaction();
        
        $numeros_gagnants_raw = decrypterNumeros($loterie['numeros_gagnants'], $loterie['cle_cryptage']);
        
        if(!$numeros_gagnants_raw) {
            throw new Exception("Impossible de décrypter les numéros gagnants");
        }
        
        $numeros_gagnants = explode('-', $numeros_gagnants_raw);
        if(count($numeros_gagnants) != 3) {
            throw new Exception("Format des numéros gagnants invalide");
        }
        
        $num1_gagnant = (int)$numeros_gagnants[0];
        $num2_gagnant = (int)$numeros_gagnants[1];
        $num3_gagnant = (int)$numeros_gagnants[2];
        
        echo "Numéros gagnants : $num1_gagnant - $num2_gagnant - $num3_gagnant\n";
        
        $sql = "SELECT * FROM loterie_participations WHERE loterie_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $loterie['id']);
        $stmt->execute();
        $participations = $stmt->get_result();
        
        $total_participants = $participations->num_rows;
        $gagnants_jackpot = 0;
        $gagnants_partiel = 0;
        $gagnants_consolation = 0;
        
        echo "Nombre total de participants : $total_participants\n";
        
        while($participation = $participations->fetch_assoc()) {
            $numeros_joues = [$participation['numero_1'], $participation['numero_2'], $participation['numero_3']];
            $numeros_gagnants_array = [$num1_gagnant, $num2_gagnant, $num3_gagnant];
            
            $bons_numeros = 0;
            foreach($numeros_joues as $num_joue) {
                if(in_array($num_joue, $numeros_gagnants_array)) {
                    $bons_numeros++;
                }
            }
            
            $gains = 0;
            $type_gain = '';
            $est_gagnant = 'non';
            
            if($bons_numeros == 3) {
                $gains = $loterie['jackpot'];
                $type_gain = 'jackpot';
                $est_gagnant = 'oui';
                $gagnants_jackpot++;
            } elseif($bons_numeros == 2) {
                $gains = 200;
                $type_gain = 'partiel';
                $est_gagnant = 'oui';
                $gagnants_partiel++;
            } elseif($bons_numeros == 1) {
                $gains = 25;
                $type_gain = 'consolation';
                $est_gagnant = 'oui';
                $gagnants_consolation++;
            }
            
            $sql_update = "UPDATE loterie_participations SET gagnant = ?, gains = ? WHERE id = ?";
            $stmt_update = $conn->prepare($sql_update);
            $stmt_update->bind_param("sdi", $est_gagnant, $gains, $participation['id']);
            $stmt_update->execute();
            
            if($gains > 0) {
                $sql_credit = "UPDATE comptes_bancaires SET solde = solde + ? WHERE user_id = ?";
                $stmt_credit = $conn->prepare($sql_credit);
                $stmt_credit->bind_param("di", $gains, $participation['user_id']);
                $stmt_credit->execute();
                
                $numeros_joues_str = implode('-', $numeros_joues);
                $sql_gain = "INSERT INTO loterie_gains (loterie_id, user_id, montant_gagne, numeros_joues, numeros_gagnants, type_gain) VALUES (?, ?, ?, ?, ?, ?)";
                $stmt_gain = $conn->prepare($sql_gain);
                $stmt_gain->bind_param("iidsss", $loterie['id'], $participation['user_id'], $gains, $numeros_joues_str, $numeros_gagnants_raw, $type_gain);
                $stmt_gain->execute();
                
                $sql_transaction = "INSERT INTO transactions (user_id, destinataire_id, destinataire_nom, emetteur_nom, montant, motif) VALUES (?, 1, ?, 'Loterie Peerkinton', ?, ?)";
                $stmt_transaction = $conn->prepare($sql_transaction);
                
                $sql_user = "SELECT email FROM users WHERE id = ?";
                $stmt_user = $conn->prepare($sql_user);
                $stmt_user->bind_param("i", $participation['user_id']);
                $stmt_user->execute();
                $user_email = $stmt_user->get_result()->fetch_assoc()['email'];
                
                $motif = "Gain loterie " . $loterie['nom'] . " - " . $type_gain . " (" . $bons_numeros . " numéros corrects)";
                $stmt_transaction->bind_param("isds", $participation['user_id'], $user_email, $gains, $motif);
                $stmt_transaction->execute();
                
                echo "Gagnant trouvé ! User ID: " . $participation['user_id'] . " - Gains: " . $gains . " F& (" . $type_gain . ")\n";
            }
        }
        
        $sql_close = "UPDATE loteries SET statut = 'tire' WHERE id = ?";
        $stmt_close = $conn->prepare($sql_close);
        $stmt_close->bind_param("i", $loterie['id']);
        $stmt_close->execute();
        
        $conn->commit();
        
        echo "=== RÉSULTATS DU TIRAGE ===\n";
        echo "Gagnants jackpot (3 numéros) : $gagnants_jackpot\n";
        echo "Gagnants partiels (2 numéros) : $gagnants_partiel\n";
        echo "Lots de consolation (1 numéro) : $gagnants_consolation\n";
        echo "Total des perdants : " . ($total_participants - $gagnants_jackpot - $gagnants_partiel - $gagnants_consolation) . "\n";
        echo "Tirage terminé avec succès !\n\n";
        
    } catch (Exception $e) {
        $conn->rollback();
        echo "ERREUR lors du tirage : " . $e->getMessage() . "\n";
    }
}

$sql_new = "SELECT COUNT(*) as count FROM loteries WHERE date_tirage > CURDATE() AND statut = 'ouvert'";
$result_count = $conn->query($sql_new);
$count = $result_count->fetch_assoc()['count'];

if($count == 0) {
    echo "Création d'une nouvelle loterie...\n";
    
    $numeros_string = genererNumerosAleatoires();
    $nouvelle_date = date('Y-m-d', strtotime('+7 days'));
    $cle_cryptage = 'peerkinton_secret_' . date('Y');
    $numeros_cryptes = crypterNumeros($numeros_string, $cle_cryptage);
    
    $sql_create = "INSERT INTO loteries (nom, date_tirage, numeros_gagnants, cle_cryptage, jackpot, statut) VALUES (?, ?, ?, ?, 1000.00, 'ouvert')";
    $stmt_create = $conn->prepare($sql_create);
    $nom_loterie = "Loterie Peerkinton #" . (date('W') + 1);
    $stmt_create->bind_param("ssss", $nom_loterie, $nouvelle_date, $numeros_cryptes, $cle_cryptage);
    
    if($stmt_create->execute()) {
        echo "Nouvelle loterie créée : $nom_loterie\n";
        echo "Date du tirage : $nouvelle_date\n";
        echo "Numéros gagnants : $numeros_string\n";
    } else {
        echo "Erreur lors de la création de la nouvelle loterie\n";
    }
}

echo "\n=== FIN DU TIRAGE AUTOMATIQUE ===\n";
?>