<?php
session_start();
require_once '../db.php';

$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;

if(!$user_id) {
    header("Location: /");
    exit();
}

$sql = "SELECT * FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if(!$user) {
    header("Location: /");
    exit();
}

$sql = "SELECT * FROM identites WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if($result->num_rows > 0) {
    header("Location: /index.php?user_id=" . $user_id . "&message=Ce citoyen possède déjà une carte d'identité&message_type=error");
    exit();
}

function genererIdCarte() {
    return 'ID-' . strtoupper(substr(md5(uniqid(rand(), true)), 0, 8));
}

if(isset($_POST['creer_identite'])) {
    $nom = $_POST['nom'];
    $prenom = $_POST['prenom'];
    $date_naissance = $_POST['date_naissance'];
    $lieu_naissance = $_POST['lieu_naissance'];
    $nationalite = $_POST['nationalite'];
    $sexe = $_POST['sexe'];
    $adresse = $_POST['adresse'];
    $telephone = $_POST['telephone'];
    $profession = $_POST['profession'];
    $id_carte = genererIdCarte();
    
    $date_emission = date('Y-m-d');
    $date_expiration = date('Y-m-d', strtotime('+10 years'));
    
    $sql = "INSERT INTO identites 
            (user_id, nom, prenom, date_naissance, lieu_naissance, nationalite, sexe, adresse, 
             telephone, profession, id_carte, notoriete, date_emission, date_expiration) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 50, ?, ?)";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("issssssssssss", $user_id, $nom, $prenom, $date_naissance, $lieu_naissance, 
                     $nationalite, $sexe, $adresse, $telephone, $profession, $id_carte, 
                     $date_emission, $date_expiration);
    
    if($stmt->execute()) {
        $sql = "INSERT INTO comptes_bancaires (user_id, solde) VALUES (?, 1000.00)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        
        $sql = "INSERT INTO journal_gouvernement (admin_id, action, cible_id, details) 
                VALUES (?, 'creation_identite', ?, ?)";
        $stmt = $conn->prepare($sql);
        $admin_id = $_SESSION['admin_id'];
        $details = "Création d'une carte d'identité et ouverture de compte bancaire";
        $stmt->bind_param("iis", $admin_id, $user_id, $details);
        $stmt->execute();
        
        header("Location: gouvernement.php?user_id=" . $user_id . "&message=Carte d'identité créée avec succès&message_type=success");
        exit();
    } else {
        $error = "Erreur lors de la création de la carte d'identité";
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Création d'identité - Peerkinton</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Poppins', 'sans-serif'],
                    },
                    colors: {
                        'gov': {
                            50: '#f0f9ff',
                            100: '#e0f2fe',
                            500: '#0ea5e9',
                            600: '#0284c7',
                            700: '#0369a1',
                            800: '#075985',
                            900: '#0c4a6e',
                        }
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-50 text-gray-900">
    <div class="min-h-screen flex flex-col">
        <header class="bg-gov-800 text-white shadow">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
                <div class="flex justify-between items-center">
                    <div class="flex items-center">
                        <i class="fas fa-landmark text-2xl mr-3"></i>
                        <h1 class="text-xl font-semibold">Gouvernement de Peerkinton</h1>
                    </div>
                    <div>
                        <a href="gouvernement.php" class="text-white hover:text-gray-200 mr-4">
                            <i class="fas fa-arrow-left mr-1"></i> Retour
                        </a>
                        <a href="logout.php" class="text-white hover:text-gray-200">
                            <i class="fas fa-sign-out-alt mr-1"></i> Déconnexion
                        </a>
                    </div>
                </div>
            </div>
        </header>

        <main class="flex-grow py-6">
            <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6">
                        <h2 class="text-lg font-medium text-gray-900">Création d'une carte d'identité</h2>
                        <p class="mt-1 max-w-2xl text-sm text-gray-500">
                            Pour le citoyen: <?php echo htmlspecialchars($user['email']); ?>
                        </p>
                    </div>
                    
                    <?php if(isset($error)): ?>
                        <div class="px-4 py-3 bg-red-50 text-red-800 border-t border-gray-200">
                            <?php echo $error; ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="border-t border-gray-200 px-4 py-5 sm:p-6">
                        <form action="" method="POST" class="space-y-6">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="nom" class="block text-sm font-medium text-gray-700">Nom</label>
                                    <input type="text" name="nom" id="nom" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-gov-500 focus:border-gov-500 sm:text-sm">
                                </div>
                                
                                <div>
                                    <label for="prenom" class="block text-sm font-medium text-gray-700">Prénom</label>
                                    <input type="text" name="prenom" id="prenom" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-gov-500 focus:border-gov-500 sm:text-sm">
                                </div>
                                
                                <div>
                                    <label for="date_naissance" class="block text-sm font-medium text-gray-700">Date de naissance</label>
                                    <input type="date" name="date_naissance" id="date_naissance" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-gov-500 focus:border-gov-500 sm:text-sm">
                                </div>
                                
                                <div>
                                    <label for="lieu_naissance" class="block text-sm font-medium text-gray-700">Lieu de naissance</label>
                                    <input type="text" name="lieu_naissance" id="lieu_naissance" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-gov-500 focus:border-gov-500 sm:text-sm">
                                </div>
                                
                                <div>
                                    <label for="nationalite" class="block text-sm font-medium text-gray-700">Nationalité</label>
                                    <input type="text" name="nationalite" id="nationalite" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-gov-500 focus:border-gov-500 sm:text-sm">
                                </div>
                                
                                <div>
                                    <label for="sexe" class="block text-sm font-medium text-gray-700">Sexe</label>
                                    <select name="sexe" id="sexe" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-gov-500 focus:border-gov-500 sm:text-sm">
                                        <option value="M">Masculin</option>
                                        <option value="F">Féminin</option>
                                    </select>
                                </div>
                                
                                <div class="md:col-span-2">
                                    <label for="adresse" class="block text-sm font-medium text-gray-700">Adresse</label>
                                    <input type="text" name="adresse" id="adresse" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-gov-500 focus:border-gov-500 sm:text-sm">
                                </div>
                                
                                <div>
                                    <label for="telephone" class="block text-sm font-medium text-gray-700">Téléphone</label>
                                    <input type="text" name="telephone" id="telephone" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-gov-500 focus:border-gov-500 sm:text-sm">
                                </div>
                                
                                <div>
                                    <label for="profession" class="block text-sm font-medium text-gray-700">Profession</label>
                                    <input type="text" name="profession" id="profession" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-gov-500 focus:border-gov-500 sm:text-sm">
                                </div>
                            </div>
                            
                            <div class="pt-4 border-t border-gray-200">
                                <div class="flex justify-between items-center">
                                    <p class="text-sm text-gray-500">
                                        Un solde initial de 1000€ sera crédité sur le compte bancaire du citoyen.
                                    </p>
                                    <button type="submit" name="creer_identite" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-gov-600 hover:bg-gov-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gov-500">
                                        Créer la carte d'identité
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>