<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

if ($method === 'POST') {
    if (!isset($input['session_id']) || !isset($input['user_id'])) {
        jsonResponse(['error' => 'Missing required fields'], 400);
    }
    
    $pdo = getDB();
    
    $stmt = $pdo->prepare("SELECT * FROM session_likes WHERE session_id = ? AND user_id = ?");
    $stmt->execute([$input['session_id'], $input['user_id']]);
    
    if ($stmt->fetch()) {
        $stmt = $pdo->prepare("DELETE FROM session_likes WHERE session_id = ? AND user_id = ?");
        $stmt->execute([$input['session_id'], $input['user_id']]);
        jsonResponse(['success' => true, 'liked' => false]);
    } else {
        $stmt = $pdo->prepare("INSERT INTO session_likes (session_id, user_id) VALUES (?, ?)");
        $stmt->execute([$input['session_id'], $input['user_id']]);
        jsonResponse(['success' => true, 'liked' => true]);
    }
}
?>