<?php
if (isset($_POST['cookie_consent'])) {
    setcookie('cookie_consent', $_POST['cookie_consent'], time() + (365 * 24 * 60 * 60), '/');
    header('Location: ' . $_SERVER['REQUEST_URI']);
    exit;
}

function detectBrowserLanguage() {
    if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
        $browser_lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
        $supported_langs = ['en', 'fr', 'it', 'es', 'ja', 'zh', 'ar', 'de', 'nl', 'tr'];
        return in_array($browser_lang, $supported_langs) ? $browser_lang : 'en';
    }
    return 'en';
}

$lang = isset($_POST['lang']) ? $_POST['lang'] : (isset($_GET['lang']) ? $_GET['lang'] : detectBrowserLanguage());
$show_popup = !isset($_COOKIE['cookie_consent']);
$lang_changed = isset($_POST['lang']);

$texts = [
    'en' => [
        'title' => 'Cookie Policy',
        'subtitle' => 'Cookie and privacy management',
        'content' => 'This website (imators.com) uses cookies to analyze site usage for analytical purposes. Under no circumstances are they transmitted to third parties. These cookies contain visit detection, location detection (by country only and not precisely) and IP address, to allow the technical service to block access to a visitor if the latter is malicious. Location is also used in account connection services for identification of potentially threatening connections and email notification of account connections. Refusal does not in any way prevent the site from functioning. An approval request on connection services will nevertheless be requested again. The information collected by cookies is under no circumstances stored in our databases or recorded for personalization purposes.',
        'accept' => 'Accept',
        'refuse' => 'Refuse',
        'available' => 'Available in'
    ],
    'fr' => [
        'title' => 'Politique des Cookies',
        'subtitle' => 'Gestion des cookies et de la confidentialité',
        'content' => 'Ce site web (imators.com) utilise des cookies pour analyser l\'utilisation du site à des fins analytiques. En aucun cas ils ne sont transmis à des tiers. Ces cookies contiennent la détection de visite, de localisation (par pays uniquement et non précisément) et de l\'adresse IP, pour permettre au service technique de bloquer l\'accès à un visiteur si ce dernier est malveillant. La localisation est aussi utilisée dans les services de connexion au compte à des fins d\'identification de connexion potentiellement menaçante et d\'information par mail de connexion au compte. Le refus n\'empêche en aucun cas le fonctionnement du site. Une demande d\'approbation sur les services de connexion sera néanmoins redemandée. Les informations collectées par les cookies ne sont en aucun cas stockées dans nos bases de données ni enregistrées à des fins de personnalisation.',
        'accept' => 'Accepter',
        'refuse' => 'Refuser',
        'available' => 'Disponible en'
    ],
    'it' => [
        'title' => 'Politica sui Cookie',
        'subtitle' => 'Gestione dei cookie e della privacy',
        'content' => 'Questo sito web (imators.com) utilizza i cookie per analizzare l\'utilizzo del sito a fini analitici. In nessun caso vengono trasmessi a terzi. Questi cookie contengono il rilevamento delle visite, della localizzazione (solo per paese e non precisamente) e dell\'indirizzo IP, per consentire al servizio tecnico di bloccare l\'accesso a un visitore se questo è malintenzionato. La localizzazione è utilizzata anche nei servizi di connessione all\'account per l\'identificazione di connessioni potenzialmente minacciose e per le notifiche via email delle connessioni all\'account. Il rifiuto non impedisce in alcun modo il funzionamento del sito. Una richiesta di approvazione sui servizi di connessione sarà comunque richiesta nuovamente. Le informazioni raccolte dai cookie non sono in nessun caso memorizzate nei nostri database né registrate per scopi di personalizzazione.',
        'accept' => 'Accetta',
        'refuse' => 'Rifiuta',
        'available' => 'Disponibile in'
    ],
    'es' => [
        'title' => 'Política de Cookies',
        'subtitle' => 'Gestión de cookies y privacidad',
        'content' => 'Este sitio web (imators.com) utiliza cookies para analizar el uso del sitio con fines analíticos. En ningún caso se transmiten a terceros. Estas cookies contienen la detección de visitas, de localización (solo por país y no precisamente) y de dirección IP, para permitir al servicio técnico bloquear el acceso a un visitante si este es malicioso. La localización también se utiliza en los servicios de conexión a la cuenta para la identificación de conexiones potencialmente amenazantes e información por correo de conexión a la cuenta. El rechazo no impide de ninguna manera el funcionamiento del sitio. Una solicitud de aprobación en los servicios de conexión será sin embargo solicitada nuevamente. La información recopilada por las cookies no se almacena bajo ninguna circunstancia en nuestras bases de datos ni se registra con fines de personalización.',
        'accept' => 'Aceptar',
        'refuse' => 'Rechazar',
        'available' => 'Disponible en'
    ],
    'ja' => [
        'title' => 'クッキーポリシー',
        'subtitle' => 'クッキーとプライバシーの管理',
        'content' => 'このウェブサイト（imators.com）では、分析目的でサイトの利用状況を分析するためにクッキーを使用しています。いかなる場合も第三者に送信されることはありません。これらのクッキーには、訪問検知、位置情報（国単位のみで正確ではない）、およびIPアドレスが含まれており、技術サービスが悪意のある訪問者のアクセスをブロックできるようにします。位置情報は、潜在的に脅威となる接続の識別とアカウント接続のメール通知のため、アカウント接続サービスでも使用されます。拒否してもサイトの機能に支障はありません。接続サービスでの承認要求は再度求められます。クッキーによって収集された情報は、いかなる場合もデータベースに保存されることも、パーソナライゼーション目的で記録されることもありません。',
        'accept' => '受け入れる',
        'refuse' => '拒否する',
        'available' => '利用可能言語'
    ],
    'zh' => [
        'title' => 'Cookie政策',
        'subtitle' => 'Cookie和隐私管理',
        'content' => '本网站（imators.com）使用Cookie来分析网站使用情况以进行分析。在任何情况下都不会传输给第三方。这些Cookie包含访问检测、位置检测（仅按国家，不精确）和IP地址，以允许技术服务在访问者恶意时阻止其访问。位置信息还用于账户连接服务，用于识别潜在威胁性连接和账户连接的邮件通知。拒绝不会以任何方式阻止网站运行。连接服务的批准请求将再次被要求。Cookie收集的信息在任何情况下都不会存储在我们的数据库中，也不会为个性化目的而记录。',
        'accept' => '接受',
        'refuse' => '拒绝',
        'available' => '可用语言'
    ],
    'ar' => [
        'title' => 'سياسة ملفات تعريف الارتباط',
        'subtitle' => 'إدارة ملفات تعريف الارتباط والخصوصية',
        'content' => 'يستخدم هذا الموقع (imators.com) ملفات تعريف الارتباط لتحليل استخدام الموقع لأغراض التحليل. لا يتم نقلها إلى أطراف ثالثة في أي حال من الأحوال. تحتوي ملفات تعريف الارتباط هذه على كشف الزيارة وكشف الموقع (حسب البلد فقط وليس بدقة) وعنوان IP، للسماح للخدمة التقنية بحظر الوصول لزائر إذا كان ضارًا. يُستخدم الموقع أيضًا في خدمات اتصال الحساب لتحديد الاتصالات المهددة المحتملة وإشعار البريد الإلكتروني لاتصالات الحساب. الرفض لا يمنع بأي شكل من الأشكال تشغيل الموقع. سيتم طلب موافقة على خدمات الاتصال مرة أخرى. المعلومات التي تجمعها ملفات تعريف الارتباط لا يتم تخزينها في قواعد بياناتنا أو تسجيلها لأغراض التخصيص في أي حال من الأحوال.',
        'accept' => 'قبول',
        'refuse' => 'رفض',
        'available' => 'متاح بـ'
    ],
    'de' => [
        'title' => 'Cookie-Richtlinie',
        'subtitle' => 'Cookie- und Datenschutzverwaltung',
        'content' => 'Diese Website (imators.com) verwendet Cookies zur Analyse der Websitenutzung zu analytischen Zwecken. Sie werden unter keinen Umständen an Dritte weitergegeben. Diese Cookies enthalten Besuchserkennung, Standorterkennung (nur nach Land und nicht genau) und IP-Adresse, um dem technischen Service zu ermöglichen, den Zugriff auf einen Besucher zu blockieren, wenn dieser bösartig ist. Der Standort wird auch in Kontoverbindungsdiensten zur Identifizierung potenziell bedrohlicher Verbindungen und zur E-Mail-Benachrichtigung von Kontoverbindungen verwendet. Eine Ablehnung hindert das Funktionieren der Website in keiner Weise. Eine Genehmigungsanfrage für Kontoverbindungsdienste wird jedoch erneut angefordert. Die durch Cookies erfassten Informationen werden unter keinen Umständen in unseren Datenbanken gespeichert oder zu Personalisierungszwecken aufgezeichnet.',
        'accept' => 'Akzeptieren',
        'refuse' => 'Ablehnen',
        'available' => 'Verfügbar in'
    ],
    'nl' => [
        'title' => 'Cookiebeleid',
        'subtitle' => 'Cookie- en privacybeheer',
        'content' => 'Deze website (imators.com) gebruikt cookies voor het analyseren van websitegebruik voor analytische doeleinden. Ze worden onder geen enkele omstandigheid aan derden doorgegeven. Deze cookies bevatten bezoekdetectie, locatiedetectie (alleen per land en niet precies) en IP-adres, om de technische service in staat te stellen de toegang van een bezoeker te blokkeren als deze kwaadwillend is. Locatie wordt ook gebruikt in accountverbindingsdiensten voor identificatie van mogelijk dreigend gevaarlijke verbindingen en e-mailmeldingen van accountverbindingen. Weigering verhindert op geen enkele manier dat de site functioneert. Een goedkeuringsverzoek op verbindingsdiensten zal echter opnieuw worden verzocht. De informatie die door cookies wordt verzameld, wordt onder geen omstandigheden in onze databases opgeslagen of vastgelegd voor personalisatiedoeleinden.',
        'accept' => 'Accepteren',
        'refuse' => 'Weigeren',
        'available' => 'Beschikbaar in'
    ],
    'tr' => [
        'title' => 'Çerez Politikası',
        'subtitle' => 'Çerez ve gizlilik yönetimi',
        'content' => 'Bu web sitesi (imators.com), analitik amaçlarla site kullanımını analiz etmek için çerezleri kullanır. Hiçbir şekilde üçüncü taraflara iletilmezler. Bu çerezler, teknik hizmetin kötü niyetli olması durumunda bir ziyaretçiye erişimi engellemesine izin vermek için ziyaret tespiti, konum tespiti (yalnızca ülkeye göre ve kesin değil) ve IP adresi içerir. Konum, olası tehditkar bağlantıların tanımlanması ve hesap bağlantılarının e-posta bildirimleri için hesap bağlantı hizmetlerinde de kullanılır. Reddetme, sitenin işlevini hiçbir şekilde engellemez. Bağlantı hizmetlerine ilişkin bir onay isteği yine de istenecektir. Çerezler tarafından toplanan bilgiler hiçbir koşulda veritabanlarımızda depolanmaz veya kişiselleştirme amaçlarıyla kaydedilmez.',
        'accept' => 'Kabul Et',
        'refuse' => 'Reddet',
        'available' => 'Kullanılabilir diller'
    ]
];

$current_text = $texts[$lang] ?? $texts['en'];
$langs_list = ['en' => 'English', 'fr' => 'Français', 'it' => 'Italiano', 'es' => 'Español', 'ja' => '日本語', 'zh' => '中文', 'ar' => 'العربية', 'de' => 'Deutsch', 'nl' => 'Nederlands', 'tr' => 'Türkçe'];
?>

<?php if ($show_popup): ?>
<div class="fixed left-4 right-4 bottom-6 md:left-auto md:right-6 md:bottom-6 md:w-96 bg-white border border-gray-200 rounded-lg shadow-lg p-6 z-[9999]">
    <div class="space-y-4">
        <div class="space-y-1">
            <h2 class="text-2xl text-black font-light"><?= $current_text['title'] ?></h2>
            <p class="text-xs text-gray-500"><?= $current_text['subtitle'] ?></p>
        </div>

        <div class="max-h-48 md:max-h-56 overflow-y-auto">
            <p class="text-xs leading-relaxed text-gray-700">
                <?= $current_text['content'] ?>
            </p>
        </div>

        <div class="space-y-3">
            <div class="flex gap-2">
                <form method="POST" class="flex-1">
                    <input type="hidden" name="lang" value="<?= $lang ?>">
                    <input type="hidden" name="cookie_consent" value="accepted">
                    <button type="submit" class="w-full bg-black text-white py-2 text-xs hover:bg-gray-800 transition-colors rounded">
                        <?= $current_text['accept'] ?>
                    </button>
                </form>

                <form method="POST" class="flex-1">
                    <input type="hidden" name="lang" value="<?= $lang ?>">
                    <input type="hidden" name="cookie_consent" value="declined">
                    <button type="submit" class="w-full border border-gray-300 text-black py-2 text-xs hover:border-black transition-colors rounded">
                        <?= $current_text['refuse'] ?>
                    </button>
                </form>
            </div>

            <div class="space-y-2">
                <p class="text-xs text-gray-400"><?= $current_text['available'] ?></p>
                <div class="flex flex-wrap gap-x-3 gap-y-1 text-xs">
                    <?php foreach ($langs_list as $lang_code => $lang_name): ?>
                        <form method="POST" class="inline">
                            <input type="hidden" name="lang" value="<?= $lang_code ?>">
                            <button type="submit" class="<?= $lang === $lang_code ? 'text-black font-medium' : 'text-gray-400' ?> hover:text-black transition-colors">
                                <?= $lang_name ?>
                            </button>
                        </form>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php if (isset($_COOKIE['cookie_consent'])): ?>
<button onclick="document.getElementById('cookieModal').style.display = document.getElementById('cookieModal').style.display === 'none' ? 'block' : 'none'" class="fixed bottom-6 right-6 bg-white border border-gray-200 text-black px-4 py-2 text-xs cursor-pointer z-[9998] hover:border-black transition-colors rounded">
    Cookie Policy
</button>

<div id="cookieModal" style="display:<?= $lang_changed ? 'block' : 'none' ?>;" class="fixed left-4 right-4 bottom-6 md:left-auto md:right-6 md:bottom-6 md:w-96 bg-white border border-gray-200 rounded-lg shadow-lg p-6 z-[9999]">
    <div class="space-y-4">
        <div class="space-y-1">
            <h2 class="text-2xl text-black font-light"><?= $current_text['title'] ?></h2>
            <p class="text-xs text-gray-500"><?= $current_text['subtitle'] ?></p>
        </div>

        <div class="max-h-48 md:max-h-56 overflow-y-auto">
            <p class="text-xs leading-relaxed text-gray-700">
                <?= $current_text['content'] ?>
            </p>
        </div>

        <div class="space-y-3">
            <div class="flex gap-2">
                <form method="POST" class="flex-1">
                    <input type="hidden" name="lang" value="<?= $lang ?>">
                    <input type="hidden" name="cookie_consent" value="accepted">
                    <button type="submit" class="w-full bg-black text-white py-2 text-xs hover:bg-gray-800 transition-colors rounded">
                        <?= $current_text['accept'] ?>
                    </button>
                </form>

                <form method="POST" class="flex-1">
                    <input type="hidden" name="lang" value="<?= $lang ?>">
                    <input type="hidden" name="cookie_consent" value="declined">
                    <button type="submit" class="w-full border border-gray-300 text-black py-2 text-xs hover:border-black transition-colors rounded">
                        <?= $current_text['refuse'] ?>
                    </button>
                </form>
            </div>

            <div class="space-y-2">
                <p class="text-xs text-gray-400"><?= $current_text['available'] ?></p>
                <div class="flex flex-wrap gap-x-3 gap-y-1 text-xs">
                    <?php foreach ($langs_list as $lang_code => $lang_name): ?>
                        <form method="POST" class="inline">
                            <input type="hidden" name="lang" value="<?= $lang_code ?>">
                            <button type="submit" class="<?= $lang === $lang_code ? 'text-black font-medium' : 'text-gray-400' ?> hover:text-black transition-colors">
                                <?= $lang_name ?>
                            </button>
                        </form>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>