<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body { font-family: 'Space Grotesk', sans-serif; }
        .bg-image {
            background-image: url('/api/placeholder/1920/400');
            background-size: cover;
            background-position: center;
            filter: brightness(0.6);
        }
        .input-effect {
            position: relative;
            margin-bottom: 30px;
        }
        .input-effect input, .input-effect textarea {
            width: 100%;
            padding: 10px 0;
            border: none;
            border-bottom: 1px solid #333;
            background-color: transparent;
            color: #fff;
            outline: none;
            transition: border-color 0.3s ease;
        }
        .input-effect input:focus, .input-effect textarea:focus {
            border-color: #4299e1;
        }
        .input-effect label {
            position: absolute;
            top: 10px;
            left: 0;
            color: #666;
            transition: all 0.3s ease;
            pointer-events: none;
        }
        .input-effect input:focus ~ label,
        .input-effect input:valid ~ label,
        .input-effect textarea:focus ~ label,
        .input-effect textarea:valid ~ label {
            top: -20px;
            font-size: 0.8em;
            color: #4299e1;
        }
        .honeypot {
            position: absolute;
            left: -9999px;
        }
    </style>
</head>
<body class="flex flex-col min-h-screen bg-black text-gray-400">
    <?php include 'src/header.php'; ?>
    <header class="relative h-80">
        <div class="bg-image absolute inset-0"></div>
        <div class="absolute inset-0 bg-gradient-to-b from-transparent to-black"></div>
        <div class="container mx-auto px-4 h-full flex items-end pb-12 relative z-10">
            <h1 class="text-5xl font-light text-white tracking-wide">Imators Support</h1>
        </div>
    </header>

    <main class="flex-grow container mx-auto px-4 py-16">
        <div class="max-w-2xl mx-auto space-y-16">
            <p class="text-sm leading-relaxed">
                Our support is simple and allows you to get an answer to any international request within 24 hours. We recommend using your Imators account if you have one.
            </p>

            <form id="contactForm" action="process.php" method="POST" class="space-y-10">
                <?php 
                    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
                ?>
                <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                <input type="hidden" name="form_start_time" value="<?php echo time(); ?>">
                
                <div class="honeypot">
                    <input type="text" name="website" tabindex="-1" autocomplete="off">
                </div>

                <div class="space-y-6">
                    <div class="input-effect">
                        <input type="text" name="nom" required class="field-control" data-type="text">
                        <label>Name</label>
                    </div>
                    <div class="input-effect">
                        <input type="text" name="prenom" required class="field-control" data-type="text">
                        <label>First name</label>
                    </div>
                    <div class="input-effect">
                        <input type="email" name="email" required class="field-control" data-type="email">
                        <label>Email</label>
                    </div>
                </div>

                <div class="input-effect">
                    <textarea name="demande" id="demande" rows="5" required minlength="50" maxlength="2000" class="field-control" data-type="text"></textarea>
                    <label>Your request</label>
                    <div class="text-right text-xs mt-2">
                        <span id="charCount">0</span> / 2000
                    </div>
                </div>

                <button type="submit" id="submitBtn" class="w-full py-3 rounded-full px-6 bg-white/5 text-white hover:bg-white/10 transition duration-300 ease-in-out">
                    Send my request
                </button>
            </form>
        </div>
    </main>

    <footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Follow Us</h5>
                <div class="flex items-center space-x-4">
                    <a href="https://instagram.com/this.is.imators" class="text-sm font-medium duration-700 hover:text-gray-100 flex items-center">
                        <img src="https://uxwing.com/wp-content/themes/uxwing/download/brands-and-social-media/instagram-white-icon.png" alt="Instagram" class="w-6 h-6 mr-2">
                        <span>Instagram</span>
                    </a>
                </div>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
                <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Privacy Policy</a>
                <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Terms of Use</a>
                <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Home</a>
                <a href="/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">About Us</a>
                <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">Contact Us</a>
            </div>
            <div class="w-full md:w-1/3 p-5">
                <h5 class="text-xs uppercase font-medium mb-6">Because it's possible</h5>
                <p class="text-sm">All images, videos, and content on this site are the property of Imators.</p>
            </div>
        </div>
        <div class="text-center py-4 border-t border-gray-800">
            <p class="text-sm mb-2">&copy; 2024 Imators. All rights reserved.</p>
            <p class="text-xs">Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.</p>
        </div>
    </footer>

    <div id="loadingOverlay" class="fixed inset-0 bg-black bg-opacity-90 flex items-center justify-center hidden z-50">
        <div class="text-2xl font-light text-gray-400">Loading...</div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('contactForm');
            const submitBtn = document.getElementById('submitBtn');
            let formMetrics = {
                startTime: Date.now(),
                keyPresses: 0,
                mouseMovements: 0,
                fieldsFocus: {}
            };

            document.addEventListener('keypress', () => formMetrics.keyPresses++);
            document.addEventListener('mousemove', () => formMetrics.mouseMovements++);
            
            document.querySelectorAll('.field-control').forEach(field => {
                field.addEventListener('focus', function() {
                    formMetrics.fieldsFocus[this.name] = formMetrics.fieldsFocus[this.name] || [];
                    formMetrics.fieldsFocus[this.name].push(Date.now());
                });
            });

            form.addEventListener('submit', function(e) {
                const timeSpent = Date.now() - formMetrics.startTime;
                
                if (timeSpent < 5000) {
                    e.preventDefault();
                    alert('Please take your time to fill out the form properly.');
                    return;
                }

                if (formMetrics.keyPresses < 20 || formMetrics.mouseMovements < 5) {
                    e.preventDefault();
                    alert('Please fill out the form manually.');
                    return;
                }

                document.getElementById('loadingOverlay').classList.remove('hidden');
            });

            const demandeTextarea = document.getElementById('demande');
            const charCount = document.getElementById('charCount');
            
            demandeTextarea.addEventListener('input', function() {
                charCount.textContent = this.value.length;
                
                const text = this.value;
                const words = text.trim().split(/\s+/);
                
                if (words.length > 0 && words[0].length > 0) {
                    submitBtn.disabled = false;
                } else {
                    submitBtn.disabled = true;
                }
            });
            
            submitBtn.disabled = true;
        });
    </script>
</body>
</html>