<?php
require_once 'db.php';
session_start();


$message = '';
$messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $age = intval($_POST['age']);
    $description = trim($_POST['description']);
    $instagram = trim($_POST['instagram_handle']);
    
    // Validation de base
    if (empty($username) || $age < 18 || empty($description)) {
        $message = "Veuillez remplir tous les champs obligatoires";
        $messageType = "error";
    } else {
        // Gestion de l'upload de la photo de profil
        if (isset($_FILES['profile_picture']) && $_FILES['profile_picture']['error'] === 0) {
            $allowed = ['jpg', 'jpeg', 'png', 'gif'];
            $filename = $_FILES['profile_picture']['name'];
            $filetype = pathinfo($filename, PATHINFO_EXTENSION);
            
            if (!in_array(strtolower($filetype), $allowed)) {
                $message = "Format de fichier non autorisé. Utilisez JPG, JPEG, PNG ou GIF.";
                $messageType = "error";
            } else {
                // Générer un nom de fichier unique
                $newFilename = uniqid() . '.' . $filetype;
                $uploadPath = 'uploads/profiles/' . $newFilename;
                
                if (!is_dir('uploads/profiles')) {
                    mkdir('uploads/profiles', 0777, true);
                }
                
                if (move_uploaded_file($_FILES['profile_picture']['tmp_name'], $uploadPath)) {
                    // Insertion dans la base de données
                    $query = "INSERT INTO users (username, age, description, profile_picture, instagram_handle) 
                             VALUES (?, ?, ?, ?, ?)";
                    $stmt = $conn->prepare($query);
                    $stmt->bind_param("sisss", $username, $age, $description, $uploadPath, $instagram);
                    
                    if ($stmt->execute()) {
                        $message = "Profil créé avec succès !";
                        $messageType = "success";
                        // Redirection vers la page du profil
                        header("Location: profile.php?id=" . $stmt->insert_id);
                        exit();
                    } else {
                        $message = "Erreur lors de la création du profil.";
                        $messageType = "error";
                    }
                } else {
                    $message = "Erreur lors de l'upload de l'image.";
                    $messageType = "error";
                }
            }
        } else {
            $message = "Veuillez sélectionner une photo de profil.";
            $messageType = "error";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Créer votre profil - Hothings</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
    <nav class="bg-white shadow-lg">
        <div class="max-w-6xl mx-auto px-4">
            <div class="flex justify-between items-center py-4">
                <div class="flex items-center space-x-8">
                    <a href="/" class="flex items-center space-x-3">
                        <span class="text-2xl font-bold text-purple-600">Hothings</span>
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <main class="max-w-2xl mx-auto px-4 py-8">
        <div class="bg-white rounded-lg shadow-xl p-8">
            <h1 class="text-3xl font-bold text-gray-900 mb-8">Créer votre profil</h1>
            
            <?php if ($message): ?>
            <div class="mb-6 p-4 rounded-lg <?php echo $messageType === 'error' ? 'bg-red-100 text-red-700' : 'bg-green-100 text-green-700'; ?>">
                <?php echo $message; ?>
            </div>
            <?php endif; ?>

            <form method="POST" enctype="multipart/form-data" class="space-y-6">
                <div>
                    <label for="username" class="block text-sm font-medium text-gray-700 mb-2">
                        Nom d'utilisateur*
                    </label>
                    <input type="text" 
                           id="username" 
                           name="username" 
                           required 
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-purple-500 focus:border-purple-500">
                </div>

                <div>
                    <label for="age" class="block text-sm font-medium text-gray-700 mb-2">
                        Âge* (18+ uniquement)
                    </label>
                    <input type="number" 
                           id="age" 
                           name="age" 
                           min="18" 
                           required 
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-purple-500 focus:border-purple-500">
                </div>

                <div>
                    <label for="description" class="block text-sm font-medium text-gray-700 mb-2">
                        Description*
                    </label>
                    <textarea id="description" 
                              name="description" 
                              required 
                              rows="4" 
                              class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-purple-500 focus:border-purple-500"></textarea>
                </div>

                <div>
                    <label for="instagram_handle" class="block text-sm font-medium text-gray-700 mb-2">
                        Nom d'utilisateur Instagram
                    </label>
                    <div class="flex items-center">
                        <span class="text-gray-500 bg-gray-100 px-3 py-2 rounded-l-lg border border-r-0 border-gray-300">
                            @
                        </span>
                        <input type="text" 
                               id="instagram_handle" 
                               name="instagram_handle" 
                               class="flex-1 px-4 py-2 border border-gray-300 rounded-r-lg focus:ring-purple-500 focus:border-purple-500">
                    </div>
                </div>

                <div>
                    <label for="profile_picture" class="block text-sm font-medium text-gray-700 mb-2">
                        Photo de profil*
                    </label>
                    <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-lg">
                        <div class="space-y-1 text-center">
                            <svg class="mx-auto h-12 w-12 text-gray-400" stroke="currentColor" fill="none" viewBox="0 0 48 48">
                                <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                            <div class="flex text-sm text-gray-600">
                                <label for="profile_picture" class="relative cursor-pointer bg-white rounded-md font-medium text-purple-600 hover:text-purple-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-purple-500">
                                    <span>Télécharger une photo</span>
                                    <input id="profile_picture" name="profile_picture" type="file" class="sr-only" required accept="image/*">
                                </label>
                            </div>
                            <p class="text-xs text-gray-500">PNG, JPG, GIF jusqu'à 10MB</p>
                        </div>
                    </div>
                </div>

                <div class="flex justify-end">
                    <button type="submit" class="bg-purple-600 text-white px-6 py-3 rounded-lg hover:bg-purple-700 transition-colors">
                        Créer mon profil
                    </button>
                </div>
            </form>
        </div>
    </main>
</body>
</html>