<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Comm Access - Imators</title>
    <link rel="icon" type="image/png" href="https://cdn.imators.com/logo.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {}
            }
        }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            letter-spacing: -0.01em;
        }
        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
            font-style: normal;
        }
        .form-section {
            opacity: 0;
            animation: fadeInUp 0.6s ease-out forwards;
        }
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .form-section:nth-child(1) { animation-delay: 0.1s; }
        .form-section:nth-child(2) { animation-delay: 0.2s; }
        .form-section:nth-child(3) { animation-delay: 0.3s; }
        .form-section:nth-child(4) { animation-delay: 0.4s; }
        .form-section:nth-child(5) { animation-delay: 0.5s; }
        .form-section:nth-child(6) { animation-delay: 0.6s; }
        .form-section:nth-child(7) { animation-delay: 0.7s; }
        .form-section:nth-child(8) { animation-delay: 0.8s; }
        .form-section:nth-child(9) { animation-delay: 0.9s; }
        
        .upload-area {
            transition: all 0.3s ease;
        }
        .upload-area:hover {
            border-color: #666;
        }
        .upload-area.dragover {
            border-color: #000;
            background-color: #f9f9f9;
        }
        .dark .upload-area.dragover {
            background-color: #1a1a1a;
        }
        .location-option {
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .location-option:hover:not(.disabled):not(.unavailable) {
            transform: scale(1.02);
        }
        .location-option.selected {
            border-color: #000;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        .dark .location-option.selected {
            border-color: #fff;
            box-shadow: 0 4px 12px rgba(255,255,255,0.1);
        }
        .location-option.disabled {
            opacity: 0.5;
            cursor: not-allowed;
            display: none;
        }
        .location-option.unavailable {
            opacity: 0.7;
            cursor: not-allowed;
        }
        .location-option.unavailable .location-content {
            filter: grayscale(50%);
        }
        .lang-btn {
            transition: all 0.3s ease;
        }
        .lang-btn:hover {
            transform: translateY(-2px);
        }
        .lang-btn.active {
            background: #000;
            color: #fff;
        }
        .dark .lang-btn.active {
            background: #fff;
            color: #000;
        }
        .info-icon {
            transition: all 0.2s ease;
        }
        .info-icon:hover {
            transform: scale(1.1);
        }
        .uber-icon-placeholder {
            width: 24px;
            height: 24px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }
    </style>
</head>
<body class="bg-white dark:bg-black text-black dark:text-white transition-colors duration-300 min-h-screen">
    <script>
        if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            document.documentElement.classList.add('dark');
        }
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
            if (e.matches) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        });

        const translations = {
            fr: {
                poweredBy: "Powered by Imators Systems",
                title: "Comm Access",
                subtitle: "Pour devenir une enseigne vraiment significative.",
                alreadyCustomer: "Je suis déjà client",
                learnMore: "En savoir plus sur Comm Access",
                selectLocation: "Sélectionnez votre emplacement",
                selectLocationDesc: "Notre logiciel est créé pour les zones où nous opérons. En choisissant une zone, vous devez être une enseigne présente dans celle-ci",
                generalInfo: "Informations générales",
                generalInfoDesc: "Les informations que nous vous demandons sont obligatoires pour que nous puissions nous adresser correctement à vous et pouvoir établir votre profil correctement. En raison des lois en vigueur, nous vous demandons de remplir de manière correcte les détails de votre enseigne",
                shopTitle: "Titre de l'enseigne",
                description: "Description",
                coverImage: "Image de couverture",
                clickSelect: "Cliquez pour sélectionner une image",
                dragDrop: "ou glissez-déposez votre fichier ici",
                fileFormat: "JPG, PNG, WebP - Max 5MB",
                removeImage: "Supprimer l'image",
                delivery: "Livraison",
                deliveryDesc: "Si votre enseigne permet à ses clients de commander via Uber Eats, vous pouvez préciser ci-dessous le lien vers la page de votre enseigne",
                uberEats: "Présent sur Uber Eats",
                uberLink: "Lien Uber Eats si présent",
                openingHours: "Horaires d'ouverture",
                openingHoursDesc: "Veuillez indiquer les horaires d'ouverture de votre enseigne pour chaque jour de la semaine",
                monday: "Lundi",
                tuesday: "Mardi",
                wednesday: "Mercredi",
                thursday: "Jeudi",
                friday: "Vendredi",
                saturday: "Samedi",
                sunday: "Dimanche",
                closed: "Fermé",
                to: "à",
                contact: "Contact",
                contactDesc: "Ces informations nous permettront de vous contacter pour toute question concernant votre enseigne",
                shopPhone: "Numéro de l'enseigne",
                managerPhone: "Numéro du responsable",
                contactEmail: "Email de contact",
                phoneIndicative: "L'indicatif doit être +32",
                consent: "Consentement",
                consentDesc: "Veuillez lire attentivement et accepter les conditions suivantes",
                consentText: "Je consens que en affichant mon enseigne sur le service officiel de",
                consentText2: "je me souscris automatiquement au programme partenaire.",
                viewContract: "Voir le contrat du programme partenaire",
                contractNote: "(Une signature et une impression du contrat sera demandé avant tout accès à Comm Access par les agents",
                termsText: "J'accepte les",
                termsLink: "conditions d'utilisation",
                termsOf: "de Comm Access",
                submit: "Soumettre ma demande",
                submitNote: "Votre enseigne sera examinée avant d'être ajoutée. Un email vous sera envoyé par aktascorp pour confirmer l'ajout ou énoncer le refus.",
                sending: "Envoi en cours...",
                successTitle: "Demande envoyée avec succès !",
                successMessage: "Votre enseigne sera examinée dans les plus brefs délais. Un email vous sera envoyé par aktascorp pour vous informer de la décision.",
                backToShops: "Retour aux enseignes",
                required: "*",
                unavailableAlert: "Cet emplacement n'accepte plus de nouvelles enseignes pour le moment.",
                visitWebsite: "Visiter le site"
            },
            nl: {
                poweredBy: "Mogelijk gemaakt door Imators Systems",
                title: "Comm Access",
                subtitle: "Om een echt betekenisvolle zaak te worden.",
                alreadyCustomer: "Ik ben al klant",
                learnMore: "Meer informatie over Comm Access",
                selectLocation: "Selecteer uw locatie",
                selectLocationDesc: "Onze software is gemaakt voor de zones waar wij actief zijn. Door een zone te kiezen, moet u een zaak zijn die daar aanwezig is",
                generalInfo: "Algemene informatie",
                generalInfoDesc: "De informatie die wij van u vragen is verplicht zodat wij ons correct tot u kunnen richten en uw profiel correct kunnen opstellen. Vanwege de geldende wetten vragen wij u de details van uw zaak correct in te vullen",
                shopTitle: "Titel van de zaak",
                description: "Beschrijving",
                coverImage: "Cover afbeelding",
                clickSelect: "Klik om een afbeelding te selecteren",
                dragDrop: "of sleep uw bestand hier",
                fileFormat: "JPG, PNG, WebP - Max 5MB",
                removeImage: "Afbeelding verwijderen",
                delivery: "Levering",
                deliveryDesc: "Als uw zaak klanten toestaat te bestellen via Uber Eats, kunt u hieronder de link naar de pagina van uw zaak opgeven",
                uberEats: "Aanwezig op Uber Eats",
                uberLink: "Uber Eats link indien aanwezig",
                openingHours: "Openingsuren",
                openingHoursDesc: "Gelieve de openingsuren van uw zaak voor elke dag van de week aan te geven",
                monday: "Maandag",
                tuesday: "Dinsdag",
                wednesday: "Woensdag",
                thursday: "Donderdag",
                friday: "Vrijdag",
                saturday: "Zaterdag",
                sunday: "Zondag",
                closed: "Gesloten",
                to: "tot",
                contact: "Contact",
                contactDesc: "Deze informatie stelt ons in staat contact met u op te nemen voor eventuele vragen over uw zaak",
                shopPhone: "Telefoonnummer zaak",
                managerPhone: "Telefoonnummer verantwoordelijke",
                contactEmail: "Contact e-mail",
                phoneIndicative: "Het netnummer moet +32 zijn",
                consent: "Toestemming",
                consentDesc: "Gelieve de volgende voorwaarden aandachtig te lezen en te accepteren",
                consentText: "Ik ga ermee akkoord dat door mijn zaak weer te geven op de officiële dienst van",
                consentText2: "ik automatisch inschrijf voor het partnerprogramma.",
                viewContract: "Zie het contract van het partnerprogramma",
                contractNote: "(Een handtekening en een afdruk van het contract wordt gevraagd voordat toegang tot Comm Access wordt verleend door de",
                termsText: "Ik accepteer de",
                termsLink: "gebruiksvoorwaarden",
                termsOf: "van Comm Access",
                submit: "Mijn aanvraag indienen",
                submitNote: "Uw zaak zal worden onderzocht voordat deze wordt toegevoegd. Een e-mail wordt u verzonden door aktascorp om de toevoeging te bevestigen of de weigering te vermelden.",
                sending: "Bezig met verzenden...",
                successTitle: "Aanvraag succesvol verzonden!",
                successMessage: "Uw zaak zal zo spoedig mogelijk worden onderzocht. Een e-mail wordt u verzonden door aktascorp om u te informeren over de beslissing.",
                backToShops: "Terug naar zaken",
                required: "*",
                unavailableAlert: "Deze locatie accepteert momenteel geen nieuwe zaken.",
                visitWebsite: "Bezoek de website"
            },
            en: {
                poweredBy: "Powered by Imators Systems",
                title: "Comm Access",
                subtitle: "To become a truly significant business.",
                alreadyCustomer: "I am already a customer",
                learnMore: "Learn more about Comm Access",
                selectLocation: "Select your location",
                selectLocationDesc: "Our software is created for the areas where we operate. By choosing an area, you must be a business present in it",
                generalInfo: "General information",
                generalInfoDesc: "The information we request is mandatory so that we can address you correctly and establish your profile properly. Due to current laws, we ask you to fill in your business details correctly",
                shopTitle: "Business name",
                description: "Description",
                coverImage: "Cover image",
                clickSelect: "Click to select an image",
                dragDrop: "or drag and drop your file here",
                fileFormat: "JPG, PNG, WebP - Max 5MB",
                removeImage: "Remove image",
                delivery: "Delivery",
                deliveryDesc: "If your business allows customers to order via Uber Eats, you can specify the link to your business page below",
                uberEats: "Present on Uber Eats",
                uberLink: "Uber Eats link if present",
                openingHours: "Opening hours",
                openingHoursDesc: "Please indicate your business opening hours for each day of the week",
                monday: "Monday",
                tuesday: "Tuesday",
                wednesday: "Wednesday",
                thursday: "Thursday",
                friday: "Friday",
                saturday: "Saturday",
                sunday: "Sunday",
                closed: "Closed",
                to: "to",
                contact: "Contact",
                contactDesc: "This information will allow us to contact you for any questions regarding your business",
                shopPhone: "Business phone number",
                managerPhone: "Manager phone number",
                contactEmail: "Contact email",
                phoneIndicative: "The country code must be +32",
                consent: "Consent",
                consentDesc: "Please read carefully and accept the following conditions",
                consentText: "I consent that by displaying my business on the official service of",
                consentText2: "I automatically subscribe to the partner program.",
                viewContract: "View the partner program contract",
                contractNote: "(A signature and a print of the contract will be requested before any access to Comm Access by",
                termsText: "I accept the",
                termsLink: "terms of use",
                termsOf: "of Comm Access",
                submit: "Submit my request",
                submitNote: "Your business will be reviewed before being added. An email will be sent to you by aktascorp to confirm the addition or state the refusal.",
                sending: "Sending...",
                successTitle: "Request sent successfully!",
                successMessage: "Your business will be reviewed as soon as possible. An email will be sent to you by aktascorp to inform you of the decision.",
                backToShops: "Back to businesses",
                required: "*",
                unavailableAlert: "This location is not accepting new businesses at the moment.",
                visitWebsite: "Visit website"
            },
            de: {
                poweredBy: "Betrieben von Imators Systems",
                title: "Comm Access",
                subtitle: "Um ein wirklich bedeutendes Geschäft zu werden.",
                alreadyCustomer: "Ich bin bereits Kunde",
                learnMore: "Mehr über Comm Access erfahren",
                selectLocation: "Wählen Sie Ihren Standort",
                selectLocationDesc: "Unsere Software wurde für die Gebiete erstellt, in denen wir tätig sind. Durch die Auswahl eines Gebiets müssen Sie ein dort ansässiges Geschäft sein",
                generalInfo: "Allgemeine Informationen",
                generalInfoDesc: "Die von uns angeforderten Informationen sind obligatorisch, damit wir Sie korrekt ansprechen und Ihr Profil ordnungsgemäß erstellen können. Aufgrund der geltenden Gesetze bitten wir Sie, die Details Ihres Geschäfts korrekt auszufüllen",
                shopTitle: "Geschäftsname",
                description: "Beschreibung",
                coverImage: "Titelbild",
                clickSelect: "Klicken Sie, um ein Bild auszuwählen",
                dragDrop: "oder ziehen Sie Ihre Datei hierher",
                fileFormat: "JPG, PNG, WebP - Max 5MB",
                removeImage: "Bild entfernen",
                delivery: "Lieferung",
                deliveryDesc: "Wenn Ihr Geschäft Kunden erlaubt, über Uber Eats zu bestellen, können Sie unten den Link zu Ihrer Geschäftsseite angeben",
                uberEats: "Auf Uber Eats vorhanden",
                uberLink: "Uber Eats Link falls vorhanden",
                openingHours: "Öffnungszeiten",
                openingHoursDesc: "Bitte geben Sie die Öffnungszeiten Ihres Geschäfts für jeden Wochentag an",
                monday: "Montag",
                tuesday: "Dienstag",
                wednesday: "Mittwoch",
                thursday: "Donnerstag",
                friday: "Freitag",
                saturday: "Samstag",
                sunday: "Sonntag",
                closed: "Geschlossen",
                to: "bis",
                contact: "Kontakt",
                contactDesc: "Diese Informationen ermöglichen es uns, Sie bei Fragen zu Ihrem Geschäft zu kontaktieren",
                shopPhone: "Geschäftstelefon",
                managerPhone: "Telefonnummer des Verantwortlichen",
                contactEmail: "Kontakt-E-Mail",
                phoneIndicative: "Die Vorwahl muss +32 sein",
                consent: "Einwilligung",
                consentDesc: "Bitte lesen Sie die folgenden Bedingungen sorgfältig durch und akzeptieren Sie sie",
                consentText: "Ich stimme zu, dass ich durch die Anzeige meines Geschäfts auf dem offiziellen Service von",
                consentText2: "automatisch am Partnerprogramm teilnehme.",
                viewContract: "Siehe Partnerprogramm-Vertrag",
                contractNote: "(Eine Unterschrift und ein Ausdruck des Vertrags wird vor jedem Zugang zu Comm Access durch",
                termsText: "Ich akzeptiere die",
                termsLink: "Nutzungsbedingungen",
                termsOf: "von Comm Access",
                submit: "Meine Anfrage einreichen",
                submitNote: "Ihr Geschäft wird überprüft, bevor es hinzugefügt wird. Eine E-Mail wird Ihnen von aktascorp gesendet, um die Hinzufügung zu bestätigen oder die Ablehnung mitzuteilen.",
                sending: "Wird gesendet...",
                successTitle: "Anfrage erfolgreich gesendet!",
                successMessage: "Ihr Geschäft wird so bald wie möglich überprüft. Eine E-Mail wird Ihnen von aktascorp gesendet, um Sie über die Entscheidung zu informieren.",
                backToShops: "Zurück zu Geschäften",
                required: "*",
                unavailableAlert: "Dieser Standort nimmt derzeit keine neuen Geschäfte auf.",
                visitWebsite: "Website besuchen"
            }
        };

        const locations = {
            vertchasseur: {
                name: "Vert Chasseur",
                logo: "https://vertchasseur.com/logo_new.png",
                contract: "contrat-partenaire-nvmbr25.pdf",
                url: "https://vertchasseur.com/comm-access",
                website: "https://vertchasseur.com",
                status: "active",
                description: {
                    fr: "Vert Chasseur est un quartier résidentiel calme situé dans la commune d'Uccle, dans la ville de Bruxelles",
                    nl: "Vert Chasseur is een rustige woonwijk gelegen in de gemeente Ukkel, in de stad Brussel",
                    en: "Vert Chasseur is a quiet residential neighborhood located in the municipality of Uccle, in the city of Brussels",
                    de: "Vert Chasseur ist ein ruhiges Wohnviertel in der Gemeinde Uccle, in der Stadt Brüssel"
                }
            },
            waterloo: {
                name: "Waterloo",
                logo: "https://monwaterloo.be/icon.png",
                contract: "contrat-partenaire-dcmbr25-water.pdf",
                url: "https://waterloo.comm-access.be",
                website: "https://monwaterloo.be",
                status: "active",
                description: {
                    fr: "Waterloo est une ville calme à l'allure chic située en Belgique, non loin de la capitale, Bruxelles",
                    nl: "Waterloo is een rustige stad met een chique uitstraling, gelegen in België, niet ver van de hoofdstad Brussel",
                    en: "Waterloo is a quiet town with a chic atmosphere, located in Belgium, not far from the capital, Brussels",
                    de: "Waterloo ist eine ruhige Stadt mit schickem Ambiente, gelegen in Belgien, nicht weit von der Hauptstadt Brüssel entfernt"
                }
            },
            fortjaco: {
                name: "Fort Jaco",
                logo: "https://fort-jaco.be/icon.png",
                contract: "contrat-partenaire-fortjaco.pdf",
                url: "https://fortjaco.comm-access.be",
                website: "https://fort-jaco.be",
                status: "unavailable",
                description: {
                    fr: "Fort Jaco est un quartier résidentiel, calme et chic, connu pour ses restaurants",
                    nl: "Fort Jaco is een rustige en chique woonwijk, bekend om zijn restaurants",
                    en: "Fort Jaco is a quiet and chic residential neighborhood, known for its restaurants",
                    de: "Fort Jaco ist ein ruhiges und schickes Wohnviertel, bekannt für seine Restaurants"
                }
            },
            avenuelouise: {
                name: "Avenue Louise",
                logo: "https://cdn.imators.com/avenuelouise-logo.png",
                contract: "contrat-partenaire-avenuelouise.pdf",
                url: "https://avenuelouise.comm-access.be",
                website: "https://avenue-louise.be",
                status: "unavailable",
                description: {
                    fr: "Avenue Louise - Bruxelles",
                    nl: "Louizalaan - Brussel",
                    en: "Avenue Louise - Brussels",
                    de: "Avenue Louise - Brüssel"
                }
            }
        };

        let currentLang = 'fr';
        let selectedLocation = '';

        function setLanguage(lang) {
            currentLang = lang;
            document.querySelectorAll('.lang-btn').forEach(btn => btn.classList.remove('active'));
            document.querySelector(`[data-lang="${lang}"]`).classList.add('active');
            renderLocations();
            updateContent();
        }

        function selectLocation(locationKey) {
            const location = locations[locationKey];
            const t = translations[currentLang];
            
            if (location.status === 'disabled') {
                return;
            }
            
            if (location.status === 'unavailable') {
                alert(t.unavailableAlert);
                return;
            }
            
            selectedLocation = locationKey;
            document.querySelectorAll('.location-option').forEach(opt => opt.classList.remove('selected'));
            document.querySelector(`[data-location="${locationKey}"]`).classList.add('selected');
            document.getElementById('location_input').value = locationKey;
            updateContent();
        }

        function renderLocations() {
            const container = document.getElementById('locations-container');
            const t = translations[currentLang];
            container.innerHTML = '';
            
            for (const [key, location] of Object.entries(locations)) {
                if (location.status === 'disabled') continue;
                
                const statusClass = location.status === 'unavailable' ? 'unavailable' : '';
                
                const locationDiv = document.createElement('div');
                locationDiv.className = `location-option ${statusClass} border-2 border-gray-200 dark:border-gray-800 rounded-xl p-4 md:p-5`;
                locationDiv.setAttribute('data-location', key);
                locationDiv.onclick = () => selectLocation(key);
                
                locationDiv.innerHTML = `
                    <div class="location-content flex items-center gap-4">
                        <img src="${location.logo}" alt="${location.name}" class="h-12 md:h-14 w-auto object-contain flex-shrink-0">
                        <div class="flex-1 min-w-0">
                            <div class="flex items-center gap-2 mb-1">
                                <p class="font-semibold text-black dark:text-white text-sm md:text-base">${location.name}</p>
                                ${location.status === 'unavailable' ? '<span class="text-xs bg-orange-100 dark:bg-orange-900 text-orange-600 dark:text-orange-300 px-2 py-0.5 rounded-full">Indisponible</span>' : ''}
                            </div>
                            <p class="text-xs md:text-sm text-gray-600 dark:text-gray-400">${location.description[currentLang]}</p>
                        </div>
                        <a href="${location.website}" target="_blank" onclick="event.stopPropagation()" 
                           class="info-icon flex-shrink-0 w-8 h-8 md:w-9 md:h-9 flex items-center justify-center rounded-full bg-gray-100 dark:bg-gray-900 hover:bg-gray-200 dark:hover:bg-gray-800 text-gray-600 dark:text-gray-400"
                           title="${t.visitWebsite}">
                            <i class="fas fa-info text-sm"></i>
                        </a>
                    </div>
                `;
                
                container.appendChild(locationDiv);
            }
        }

        function updateContent() {
            const t = translations[currentLang];
            const loc = selectedLocation ? locations[selectedLocation] : null;

            document.querySelector('[data-text="poweredBy"]').textContent = t.poweredBy;
            document.querySelector('[data-text="title"]').textContent = t.title;
            document.querySelector('[data-text="subtitle"]').textContent = t.subtitle;
            document.querySelector('[data-text="alreadyCustomer"]').textContent = t.alreadyCustomer;
            document.querySelector('[data-text="learnMore"]').textContent = t.learnMore;
            if (loc) {
                document.querySelector('[data-text="alreadyCustomer"]').href = loc.url;
            }
            document.querySelector('[data-text="selectLocation"]').textContent = t.selectLocation;
            document.querySelector('[data-text="selectLocationDesc"]').textContent = t.selectLocationDesc;
            document.querySelector('[data-text="generalInfo"]').textContent = t.generalInfo;
            document.querySelector('[data-text="generalInfoDesc"]').textContent = t.generalInfoDesc;
            document.querySelector('[data-text="shopTitle"]').innerHTML = t.shopTitle + '<span class="text-red-500">' + t.required + '</span>';
            document.querySelector('[data-text="description"]').innerHTML = t.description + '<span class="text-red-500">' + t.required + '</span>';
            document.querySelector('[data-text="coverImage"]').innerHTML = t.coverImage + '<span class="text-red-500">' + t.required + '</span>';
            document.querySelector('[data-text="clickSelect"]').textContent = t.clickSelect;
            document.querySelector('[data-text="dragDrop"]').textContent = t.dragDrop;
            document.querySelector('[data-text="fileFormat"]').textContent = t.fileFormat;
            document.querySelector('[data-text="removeImage"]').innerHTML = '<i class="fas fa-trash mr-1"></i>' + t.removeImage;
            document.querySelector('[data-text="delivery"]').textContent = t.delivery;
            document.querySelector('[data-text="deliveryDesc"]').textContent = t.deliveryDesc;
            document.querySelector('[data-text="uberEats"]').textContent = t.uberEats;
            document.querySelector('[data-text="uberLink"]').textContent = t.uberLink;
            document.querySelector('[data-text="openingHours"]').innerHTML = t.openingHours + '<span class="text-red-500">' + t.required + '</span>';
            document.querySelector('[data-text="openingHoursDesc"]').textContent = t.openingHoursDesc;
            document.querySelector('[data-text="monday"]').textContent = t.monday;
            document.querySelector('[data-text="tuesday"]').textContent = t.tuesday;
            document.querySelector('[data-text="wednesday"]').textContent = t.wednesday;
            document.querySelector('[data-text="thursday"]').textContent = t.thursday;
            document.querySelector('[data-text="friday"]').textContent = t.friday;
            document.querySelector('[data-text="saturday"]').textContent = t.saturday;
            document.querySelector('[data-text="sunday"]').textContent = t.sunday;
            document.querySelectorAll('[data-text="closed"]').forEach(el => el.textContent = t.closed);
            document.querySelectorAll('[data-text="to"]').forEach(el => el.textContent = t.to);
            document.querySelector('[data-text="contact"]').textContent = t.contact;
            document.querySelector('[data-text="contactDesc"]').textContent = t.contactDesc;
            document.querySelector('[data-text="shopPhone"]').innerHTML = t.shopPhone + '<span class="text-red-500">' + t.required + '</span>';
            document.querySelector('[data-text="managerPhone"]').innerHTML = t.managerPhone + '<span class="text-red-500">' + t.required + '</span>';
            document.querySelector('[data-text="contactEmail"]').innerHTML = t.contactEmail + '<span class="text-red-500">' + t.required + '</span>';
            document.querySelector('[data-text="phoneIndicative"]').textContent = t.phoneIndicative;
            document.querySelector('[data-text="consent"]').innerHTML = t.consent + '<span class="text-red-500">' + t.required + '</span>';
            document.querySelector('[data-text="consentDesc"]').textContent = t.consentDesc;
            
            if (loc) {
                document.querySelector('[data-text="consentText"]').innerHTML = t.consentText + ' <strong>' + loc.name + '</strong>, ' + t.consentText2 + ' <a href="' + loc.contract + '" target="_blank" class="text-black dark:text-white font-medium hover:underline">' + t.viewContract + '</a> ' + t.contractNote + ' ' + loc.name + ')';
            } else {
                document.querySelector('[data-text="consentText"]').textContent = '';
            }
            
            document.querySelector('[data-text="termsText"]').innerHTML = t.termsText + ' <a href="https://imators.com/comm-access-terms" target="_blank" class="text-black dark:text-white font-medium hover:underline">' + t.termsLink + '</a> ' + t.termsOf;
            
            document.querySelector('[data-text="submit"]').textContent = t.submit;
            document.querySelector('[data-text="submitNote"]').textContent = t.submitNote;
            document.querySelector('[data-text="footer"]').textContent = t.footer;
        }
    </script>

    <div class="fixed top-4 right-4 md:top-6 md:right-6 flex gap-1.5 md:gap-2 z-50">
        <button onclick="setLanguage('fr')" data-lang="fr" class="lang-btn active px-2.5 md:px-4 py-1.5 md:py-2 rounded-lg bg-gray-100 dark:bg-gray-900 text-black dark:text-white font-medium text-xs md:text-sm">FR</button>
        <button onclick="setLanguage('nl')" data-lang="nl" class="lang-btn px-2.5 md:px-4 py-1.5 md:py-2 rounded-lg bg-gray-100 dark:bg-gray-900 text-black dark:text-white font-medium text-xs md:text-sm">NL</button>
        <button onclick="setLanguage('en')" data-lang="en" class="lang-btn px-2.5 md:px-4 py-1.5 md:py-2 rounded-lg bg-gray-100 dark:bg-gray-900 text-black dark:text-white font-medium text-xs md:text-sm">EN</button>
        <button onclick="setLanguage('de')" data-lang="de" class="lang-btn px-2.5 md:px-4 py-1.5 md:py-2 rounded-lg bg-gray-100 dark:bg-gray-900 text-black dark:text-white font-medium text-xs md:text-sm">DE</button>
    </div>

    <main class="container mx-auto px-4 py-16 max-w-3xl">
        <header class="text-center mb-16">
            <p class="text-gray-500 dark:text-gray-400 text-sm tracking-wider uppercase mb-3" data-text="poweredBy">Powered by Imators Systems</p>
            <h1 class="text-4xl md:text-5xl font-light mb-5 text-black dark:text-white">
                <span class="font-light" data-text="title">Comm Access</span>
            </h1>
            <p class="text-lg text-gray-600 dark:text-gray-300 leading-relaxed max-w-xl mx-auto mb-8" data-text="subtitle">
                Pour devenir une enseigne vraiment significative.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center items-center">
                <a href="https://vertchasseur.com/comm-access" class="inline-block px-6 py-3 text-sm font-medium text-gray-600 dark:text-gray-300 hover:text-black dark:hover:text-white transition-colors border-b border-gray-300 dark:border-gray-700 hover:border-black dark:hover:border-white" data-text="alreadyCustomer">
                    Je suis déjà client
                </a>
                <a href="https://imators.com/comm-access" target="_blank" class="inline-block px-6 py-3 text-sm font-medium text-gray-600 dark:text-gray-300 hover:text-black dark:hover:text-white transition-colors border-b border-gray-300 dark:border-gray-700 hover:border-black dark:hover:border-white" data-text="learnMore">
                    En savoir plus sur Comm Access
                </a>
            </div>
        </header>

        <form id="commerce-form" class="space-y-12" enctype="multipart/form-data">
            <input type="hidden" name="location" id="location_input" value="">
            <input type="hidden" name="language" id="language_input" value="fr">

            <div class="form-section">
                <h2 class="text-2xl font-medium mb-3 text-black dark:text-white" data-text="selectLocation">Sélectionnez votre emplacement</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6" data-text="selectLocationDesc">Notre logiciel est créé pour les zones où nous opérons. En choisissant une zone, vous devez être une enseigne présente dans celle-ci</p>
                <div id="locations-container" class="grid grid-cols-1 gap-4">
                </div>
            </div>

            <div class="form-section">
                <h2 class="text-2xl font-medium mb-3 text-black dark:text-white" data-text="generalInfo">Informations générales</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6" data-text="generalInfoDesc">Les informations que nous vous demandons sont obligatoires pour que nous puissions nous adresser correctement à vous et pouvoir établir votre profil correctement. En raison des lois en vigueur, nous vous demandons de remplir de manière correcte les détails de votre enseigne</p>
                <div class="space-y-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2" data-text="shopTitle">
                            Titre de l'enseigne<span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="title" required
                               class="w-full px-4 py-3 rounded-xl bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white">
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2" data-text="description">
                            Description<span class="text-red-500">*</span>
                        </label>
                        <textarea name="description" required rows="4"
                                  class="w-full px-4 py-3 rounded-xl bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white resize-none"></textarea>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2" data-text="coverImage">
                            Image de couverture<span class="text-red-500">*</span>
                        </label>
                        <div class="upload-area border-2 border-dashed border-gray-300 dark:border-gray-700 rounded-xl p-8 text-center cursor-pointer"
                             onclick="document.getElementById('cover_image').click()">
                            <i class="fas fa-cloud-upload-alt text-3xl text-gray-400 dark:text-gray-500 mb-3"></i>
                            <p class="text-gray-600 dark:text-gray-300 font-medium mb-1" data-text="clickSelect">Cliquez pour sélectionner une image</p>
                            <p class="text-sm text-gray-500 dark:text-gray-400" data-text="dragDrop">ou glissez-déposez votre fichier ici</p>
                            <p class="text-xs text-gray-400 dark:text-gray-500 mt-2" data-text="fileFormat">JPG, PNG, WebP - Max 5MB</p>
                            <input type="file" id="cover_image" name="cover_image" accept="image/*" required class="hidden">
                        </div>
                        <div id="image-preview" class="mt-4 hidden">
                            <img id="preview-img" src="" alt="Aperçu" class="w-full h-48 object-cover rounded-xl">
                            <button type="button" onclick="removeImage()" class="mt-2 text-sm text-red-500 hover:text-red-700" data-text="removeImage">
                                <i class="fas fa-trash mr-1"></i>Supprimer l'image
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-section">
                <h2 class="text-2xl font-medium mb-3 text-black dark:text-white" data-text="delivery">Livraison</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6" data-text="deliveryDesc">Si votre enseigne permet à ses clients de commander via Uber Eats, vous pouvez préciser ci-dessous le lien vers la page de votre enseigne</p>
                <div class="space-y-6">
                    <div class="flex items-center space-x-4">
                        <input type="checkbox" id="uber_eats" name="uber_eats" value="1"
                               class="w-5 h-5 rounded border-gray-300 dark:border-gray-700 text-black dark:text-white focus:ring-0">
                        <label for="uber_eats" class="text-sm font-medium text-gray-700 dark:text-gray-300" data-text="uberEats">
                            Présent sur Uber Eats
                        </label>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2" data-text="uberLink">
                            Lien Uber Eats si présent
                        </label>
                        <input placeholder="https://ubereats.com/..." type="url" name="website_link"
                               class="w-full px-4 py-3 rounded-xl bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white">
                    </div>
                </div>
            </div>

            <div class="form-section">
                <h2 class="text-2xl font-medium mb-3 text-black dark:text-white" data-text="openingHours">Horaires d'ouverture<span class="text-red-500">*</span></h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6" data-text="openingHoursDesc">Veuillez indiquer les horaires d'ouverture de votre enseigne pour chaque jour de la semaine</p>
                <div class="space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2" data-text="monday">Lundi</label>
                            <div class="flex items-center space-x-3">
                                <input type="checkbox" id="closed_monday" name="closed_monday" value="1" onchange="toggleDay('monday')"
                                       class="w-4 h-4 rounded border-gray-300 dark:border-gray-700">
                                <label for="closed_monday" class="text-sm text-gray-600 dark:text-gray-400" data-text="closed">Fermé</label>
                            </div>
                            <div id="hours_monday" class="flex items-center space-x-2 mt-2">
                                <input type="time" name="monday_open" class="px-3 py-2 rounded-lg bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white text-sm">
                                <span class="text-gray-500 dark:text-gray-400" data-text="to">à</span>
                                <input type="time" name="monday_close" class="px-3 py-2 rounded-lg bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white text-sm">
                            </div>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2" data-text="tuesday">Mardi</label>
                            <div class="flex items-center space-x-3">
                                <input type="checkbox" id="closed_tuesday" name="closed_tuesday" value="1" onchange="toggleDay('tuesday')"
                                       class="w-4 h-4 rounded border-gray-300 dark:border-gray-700">
                                <label for="closed_tuesday" class="text-sm text-gray-600 dark:text-gray-400" data-text="closed">Fermé</label>
                            </div>
                            <div id="hours_tuesday" class="flex items-center space-x-2 mt-2">
                                <input type="time" name="tuesday_open" class="px-3 py-2 rounded-lg bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white text-sm">
                                <span class="text-gray-500 dark:text-gray-400" data-text="to">à</span>
                                <input type="time" name="tuesday_close" class="px-3 py-2 rounded-lg bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white text-sm">
                            </div>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2" data-text="wednesday">Mercredi</label>
                            <div class="flex items-center space-x-3">
                                <input type="checkbox" id="closed_wednesday" name="closed_wednesday" value="1" onchange="toggleDay('wednesday')"
                                       class="w-4 h-4 rounded border-gray-300 dark:border-gray-700">
                                <label for="closed_wednesday" class="text-sm text-gray-600 dark:text-gray-400" data-text="closed">Fermé</label>
                            </div>
                            <div id="hours_wednesday" class="flex items-center space-x-2 mt-2">
                                <input type="time" name="wednesday_open" class="px-3 py-2 rounded-lg bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white text-sm">
                                <span class="text-gray-500 dark:text-gray-400" data-text="to">à</span>
                                <input type="time" name="wednesday_close" class="px-3 py-2 rounded-lg bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white text-sm">
                            </div>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2" data-text="thursday">Jeudi</label>
                            <div class="flex items-center space-x-3">
                                <input type="checkbox" id="closed_thursday" name="closed_thursday" value="1" onchange="toggleDay('thursday')"
                                       class="w-4 h-4 rounded border-gray-300 dark:border-gray-700">
                                <label for="closed_thursday" class="text-sm text-gray-600 dark:text-gray-400" data-text="closed">Fermé</label>
                            </div>
                            <div id="hours_thursday" class="flex items-center space-x-2 mt-2">
                                <input type="time" name="thursday_open" class="px-3 py-2 rounded-lg bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white text-sm">
                                <span class="text-gray-500 dark:text-gray-400" data-text="to">à</span>
                                <input type="time" name="thursday_close" class="px-3 py-2 rounded-lg bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white text-sm">
                            </div>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2" data-text="friday">Vendredi</label>
                            <div class="flex items-center space-x-3">
                                <input type="checkbox" id="closed_friday" name="closed_friday" value="1" onchange="toggleDay('friday')"
                                       class="w-4 h-4 rounded border-gray-300 dark:border-gray-700">
                                <label for="closed_friday" class="text-sm text-gray-600 dark:text-gray-400" data-text="closed">Fermé</label>
                            </div>
                            <div id="hours_friday" class="flex items-center space-x-2 mt-2">
                                <input type="time" name="friday_open" class="px-3 py-2 rounded-lg bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white text-sm">
                                <span class="text-gray-500 dark:text-gray-400" data-text="to">à</span>
                                <input type="time" name="friday_close" class="px-3 py-2 rounded-lg bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white text-sm">
                            </div>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2" data-text="saturday">Samedi</label>
                            <div class="flex items-center space-x-3">
                                <input type="checkbox" id="closed_saturday" name="closed_saturday" value="1" onchange="toggleDay('saturday')"
                                       class="w-4 h-4 rounded border-gray-300 dark:border-gray-700">
                                <label for="closed_saturday" class="text-sm text-gray-600 dark:text-gray-400" data-text="closed">Fermé</label>
                            </div>
                            <div id="hours_saturday" class="flex items-center space-x-2 mt-2">
                                <input type="time" name="saturday_open" class="px-3 py-2 rounded-lg bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white text-sm">
                                <span class="text-gray-500 dark:text-gray-400" data-text="to">à</span>
                                <input type="time" name="saturday_close" class="px-3 py-2 rounded-lg bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white text-sm">
                            </div>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2" data-text="sunday">Dimanche</label>
                            <div class="flex items-center space-x-3">
                                <input type="checkbox" id="closed_sunday" name="closed_sunday" value="1" onchange="toggleDay('sunday')"
                                       class="w-4 h-4 rounded border-gray-300 dark:border-gray-700">
                                <label for="closed_sunday" class="text-sm text-gray-600 dark:text-gray-400" data-text="closed">Fermé</label>
                            </div>
                            <div id="hours_sunday" class="flex items-center space-x-2 mt-2">
                                <input type="time" name="sunday_open" class="px-3 py-2 rounded-lg bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white text-sm">
                                <span class="text-gray-500 dark:text-gray-400" data-text="to">à</span>
                                <input type="time" name="sunday_close" class="px-3 py-2 rounded-lg bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white text-sm">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-section">
                <h2 class="text-2xl font-medium mb-3 text-black dark:text-white" data-text="contact">Contact</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6" data-text="contactDesc">Ces informations nous permettront de vous contacter pour toute question concernant votre enseigne</p>
                <div class="space-y-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2" data-text="shopPhone">
                            Numéro de l'enseigne<span class="text-red-500">*</span>
                        </label>
                        <input type="tel" name="shop_phone" required pattern="^\+32[0-9]{8,9}$" placeholder="+32..."
                               class="w-full px-4 py-3 rounded-xl bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white">
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1" data-text="phoneIndicative">L'indicatif doit être +32</p>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2" data-text="managerPhone">
                            Numéro du responsable<span class="text-red-500">*</span>
                        </label>
                        <input type="tel" name="manager_phone" required pattern="^\+32[0-9]{8,9}$" placeholder="+32..."
                               class="w-full px-4 py-3 rounded-xl bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white">
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1" data-text="phoneIndicative">L'indicatif doit être +32</p>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2" data-text="contactEmail">
                            Email de contact<span class="text-red-500">*</span>
                        </label>
                        <input type="email" name="contact_email" required
                               class="w-full px-4 py-3 rounded-xl bg-white dark:bg-black border border-gray-200 dark:border-gray-800 focus:border-gray-400 dark:focus:border-gray-600 focus:outline-none text-black dark:text-white">
                    </div>
                </div>
            </div>

            <div class="form-section">
                <h2 class="text-2xl font-medium mb-3 text-black dark:text-white" data-text="consent">Consentement<span class="text-red-500">*</span></h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6" data-text="consentDesc">Veuillez lire attentivement et accepter les conditions suivantes</p>
                <div class="bg-gray-50 dark:bg-gray-900 rounded-xl p-6 space-y-4">
                    <div class="flex items-start space-x-4">
                        <input type="checkbox" id="partner_consent" name="partner_consent" value="1" required
                               class="w-5 h-5 rounded border-gray-300 dark:border-gray-700 text-black dark:text-white focus:ring-0 mt-1">
                        <label for="partner_consent" class="text-sm text-gray-700 dark:text-gray-300 leading-relaxed" data-text="consentText">
                            Je consens que en affichant mon enseigne sur le service officiel de Vert Chasseur, je me souscris automatiquement au programme partenaire.
                        </label>
                    </div>
                    <div class="flex items-start space-x-4">
                        <input type="checkbox" id="terms_consent" name="terms_consent" value="1" required
                               class="w-5 h-5 rounded border-gray-300 dark:border-gray-700 text-black dark:text-white focus:ring-0 mt-1">
                        <label for="terms_consent" class="text-sm text-gray-700 dark:text-gray-300 leading-relaxed" data-text="termsText">
                            J'accepte les conditions d'utilisation de Comm Access
                        </label>
                    </div>
                </div>
            </div>

            <div class="form-section">
                <button type="submit" 
                        class="w-full py-4 bg-black dark:bg-white text-white dark:text-black rounded-xl font-medium text-lg hover:shadow-lg transition-all duration-300 transform hover:scale-[1.02]" data-text="submit">
                    Soumettre ma demande
                </button>
                <p class="text-xs text-gray-500 dark:text-gray-400 text-center mt-4" data-text="submitNote">
                    Votre enseigne sera examinée avant d'être ajoutée. Un email vous sera envoyé par aktascorp pour confirmer l'ajout ou énoncer le refus.
                </p>
            </div>
        </form>
    </main>

    <footer class="w-full py-8 mt-16 border-t border-gray-100 dark:border-gray-900">
        <p class="text-xs text-gray-500 dark:text-gray-400 text-center">
            Comm Access is a software created by Imators Technologies LLC and a member of the Quarter Project, all right reserved
        </p>
    </footer>

    <script>
        function toggleDay(day) {
            const checkbox = document.getElementById('closed_' + day);
            const hoursDiv = document.getElementById('hours_' + day);
            const inputs = hoursDiv.querySelectorAll('input');
            
            if (checkbox.checked) {
                hoursDiv.style.opacity = '0.3';
                inputs.forEach(input => input.disabled = true);
            } else {
                hoursDiv.style.opacity = '1';
                inputs.forEach(input => input.disabled = false);
            }
        }

        document.getElementById('cover_image').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('preview-img').src = e.target.result;
                    document.getElementById('image-preview').classList.remove('hidden');
                    document.querySelector('.upload-area').style.display = 'none';
                };
                reader.readAsDataURL(file);
            }
        });

        function removeImage() {
            document.getElementById('cover_image').value = '';
            document.getElementById('image-preview').classList.add('hidden');
            document.querySelector('.upload-area').style.display = 'block';
        }

        const uploadArea = document.querySelector('.upload-area');
        
        uploadArea.addEventListener('dragover', function(e) {
            e.preventDefault();
            this.classList.add('dragover');
        });

        uploadArea.addEventListener('dragleave', function(e) {
            e.preventDefault();
            this.classList.remove('dragover');
        });

        uploadArea.addEventListener('drop', function(e) {
            e.preventDefault();
            this.classList.remove('dragover');
            
            const files = e.dataTransfer.files;
            if (files.length > 0) {
                document.getElementById('cover_image').files = files;
                document.getElementById('cover_image').dispatchEvent(new Event('change'));
            }
        });

        document.getElementById('commerce-form').addEventListener('submit', function(e) {
            e.preventDefault();
            
            if (!selectedLocation) {
                alert(currentLang === 'fr' ? 'Veuillez sélectionner un emplacement' : 
                      currentLang === 'nl' ? 'Selecteer een locatie' : 
                      currentLang === 'en' ? 'Please select a location' : 
                      'Bitte wählen Sie einen Standort');
                return;
            }
            
            document.getElementById('language_input').value = currentLang;
            
            const formData = new FormData(this);
            
            const submitButton = this.querySelector('button[type="submit"]');
            submitButton.disabled = true;
            const t = translations[currentLang];
            submitButton.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>' + t.sending;
            
            fetch('process_commerce.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const t = translations[currentLang];
                    document.querySelector('main').innerHTML = `
                        <div class="text-center py-20">
                            <div class="w-20 h-20 bg-green-100 dark:bg-green-900 rounded-full flex items-center justify-center mx-auto mb-6">
                                <i class="fas fa-check text-3xl text-green-600 dark:text-green-400"></i>
                            </div>
                            <h1 class="text-3xl font-medium text-black dark:text-white mb-4">${t.successTitle}</h1>
                            <p class="text-gray-600 dark:text-gray-300 max-w-md mx-auto leading-relaxed">
                                ${t.successMessage}
                            </p>
                            <a href="commerces.php" class="inline-block mt-8 px-6 py-3 bg-black dark:bg-white text-white dark:text-black rounded-xl font-medium hover:shadow-lg transition-all duration-300">
                                ${t.backToShops}
                            </a>
                        </div>
                    `;
                } else {
                    alert('Erreur lors de l\'envoi : ' + data.message);
                    submitButton.disabled = false;
                    submitButton.innerHTML = t.submit;
                }
            })
            .catch(error => {
                alert('Erreur de connexion');
                console.error('Error:', error);
                submitButton.disabled = false;
                const t = translations[currentLang];
                submitButton.innerHTML = t.submit;
            });
        });

        renderLocations();
        updateContent();
    </script>
</body>
</html>