// Script pour mettre à jour le roleinimators via ajax
document.addEventListener('DOMContentLoaded', function() {
    // Vérifier le roleinimators au chargement de la page
    checkRoleinimators();
    
    // Fonction pour vérifier et récupérer roleinimators
    function checkRoleinimators() {
        fetch('check_roleinimators.php')
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success' && data.value) {
                    // Mettre à jour l'affichage du roleinimators dans l'interface
                    updateRoleinimatorDisplay(data.value);
                } else if (data.status === 'warning') {
                    console.warn('Attention: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Erreur lors de la vérification de roleinimators:', error);
            });
    }
    
    // Fonction pour mettre à jour l'affichage du roleinimators
    function updateRoleinimatorDisplay(value) {
        // Mettre à jour tous les éléments d'affichage qui contiennent le roleinimators
        const roleDisplayElements = document.querySelectorAll('.roleinimators');
        roleDisplayElements.forEach(element => {
            element.textContent = value;
        });
        
        // Mettre à jour également dans le menu déroulant du profil (version mobile et desktop)
        const profileRoleElements = document.querySelectorAll('#profile-menu-desktop .text-xs, #profile-menu .text-xs');
        profileRoleElements.forEach(element => {
            if (element.classList.contains('text-gray-500') || element.classList.contains('text-gray-400')) {
                element.textContent = value;
            }
        });
    }
    
    // Ajouter la fonction de mise à jour au formulaire d'édition utilisateur
    const editUserForm = document.getElementById('edit-user-form');
    if (editUserForm) {
        editUserForm.addEventListener('submit', function(e) {
            // Cette fonction sera exécutée après la soumission réussie du formulaire
            setTimeout(checkRoleinimators, 1000);
        });
    }
});