<?php
require_once 'db.php';

header('Content-Type: application/json');

try {
    if (!isset($_POST['user_id'])) {
        throw new Exception('User ID is required');
    }

    $userId = $_POST['user_id'];
    $db = getDB1Connection();
    
    $stmt = $db->prepare("DELETE FROM utilisateurs WHERE id = ?");
    $result = $stmt->execute([$userId]);
    
    if ($result) {
        echo json_encode(['success' => true]);
    } else {
        throw new Exception('Failed to delete user');
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}