import express from 'express';
import { sequelize } from './database.js';
import { TrafficLight } from './models/TrafficLight.js';
import dotenv from 'dotenv';

dotenv.config();
const app = express();
app.use(express.json());

// Configuration du serveur
const PORT = process.env.PORT || 3000;

// Routes API
app.post('/api/traffic-lights', async (req, res) => {
  try {
    const { name, latitude, longitude, cycleTime, distance } = req.body;
    const trafficLight = await TrafficLight.create({
      name,
      latitude,
      longitude,
      cycleTime,
      distance
    });
    res.json(trafficLight);
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
});

app.get('/api/traffic-lights', async (req, res) => {
  try {
    const trafficLights = await TrafficLight.findAll();
    res.json(trafficLights);
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
});

// Démarrage du serveur
sequelize.sync().then(() => {
  app.listen(PORT, () => {
    console.log(`Serveur démarré sur le port ${PORT}`);
  });
});