<?php
require_once 'db.php';

$stores = getAllStores();

// Search functionality
$searchQuery = '';
if (isset($_GET['search']) && !empty($_GET['search'])) {
    $searchQuery = $_GET['search'];
    $stores = searchStores($searchQuery);
}

include 'header.php';
?>

<main>
    <!-- Hero Section -->
    <section class="py-16 px-4 md:px-8">
        <div class="max-w-5xl mx-auto text-center">
            <span class="inline-block px-4 py-1 bg-blue-50 text-blue-600 rounded-full text-xs mb-4">Meet available in all store</span>
            <h2 class="text-4xl md:text-5xl lg:text-6xl font-normal tracking-tight mb-6">Your technology shopping center</h2>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto mb-10">
                Cergies stores present a wide range of technological products produced by Imators and its partners
            </p>
            <div class="flex flex-col sm:flex-row justify-center gap-4">
                <a href="#stores" class="px-8 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                    Find a store
                </a>
                <a href="#contact" class="px-8 py-3 border border-gray-300 rounded-lg hover:bg-gray-50 transition-colors">
                    Call the assistance
                </a>
            </div>
        </div>
    </section>


    <!-- Stores Section with Search -->
    <section id="stores" class="py-16 px-4 md:px-8">
        <div class="max-w-7xl mx-auto">
            <div class="flex justify-between items-center mb-8">
                <h2 class="text-3xl font-normal">Our Shops</h2>
                <div class="flex items-center">
                    <div class="h-2.5 w-2.5 rounded-full bg-green-500 mr-2 animate-pulse"></div>
                    <span class="text-sm">Real-time updates</span>
                </div>
            </div>
            
            <!-- Search Bar -->
            <div class="mb-8">
                <form action="index.php#stores" method="GET" class="flex w-full md:w-1/2 mx-auto">
                    <input 
                        type="text" 
                        name="search" 
                        placeholder="Search for shops, categories, or locations..." 
                        value="<?php echo htmlspecialchars($searchQuery); ?>"
                        class="flex-grow px-4 py-3 border border-gray-300 rounded-l-lg focus:ring-blue-500 focus:border-blue-500"
                    >
                    <button type="submit" class="px-6 py-3 bg-blue-600 text-white rounded-r-lg hover:bg-blue-700 transition-colors">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                        </svg>
                    </button>
                </form>
            </div>

            <?php if (!empty($searchQuery)): ?>
            <div class="mb-6 text-gray-600">
                <p>Search results for: <strong><?php echo htmlspecialchars($searchQuery); ?></strong></p>
                <a href="index.php#stores" class="text-blue-600 hover:underline">Clear search</a>
            </div>
            <?php endif; ?>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php foreach ($stores as $store): ?>
                <div class="border border-gray-200 rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
                    <div class="aspect-video overflow-hidden bg-gray-100">
                        <img src="<?php echo htmlspecialchars($store['image_url']); ?>" alt="<?php echo htmlspecialchars($store['name']); ?>" class="w-full h-full object-cover">
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl mb-2"><?php echo htmlspecialchars($store['name']); ?></h3>
                        <p class="text-gray-600 mb-4"><?php echo htmlspecialchars($store['description']); ?></p>
                        
                        <div class="flex items-center gap-2 text-sm text-gray-500 mb-2">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                            </svg>
                            <span>Zone <?php echo htmlspecialchars($store['location']); ?></span>
                        </div>
                        
                        <div class="flex items-center gap-2 text-sm text-gray-500 mb-4">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            <span><?php echo htmlspecialchars($store['opening_hours']); ?></span>
                        </div>
                        
                        <a href="tel:<?php echo htmlspecialchars($store['phone']); ?>" class="inline-flex items-center text-blue-600 hover:underline">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                            </svg>
                            Contact
                        </a>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>

            <?php if (empty($stores)): ?>
            <div class="text-center py-12">
                <p class="text-gray-500">No shops found. Please try a different search.</p>
            </div>
            <?php endif; ?>
        </div>
    </section>


</main>

<footer class="py-8 px-4 md:px-8 border-t border-gray-200">
    <div class="max-w-7xl mx-auto">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
            <div>
                <h3 class="text-lg mb-4">Cergies</h3>
                <p class="text-sm text-gray-600 mb-4">The reference shopping centre in Val d'Oise.</p>
                <div class="flex space-x-4">
                    <a href="#" class="text-gray-400 hover:text-gray-600">
                        <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <path fill-rule="evenodd" d="M22 12c0-5.523-4.477-10-10-10S2 6.477 2 12c0 4.991 3.657 9.128 8.438 9.878v-6.987h-2.54V12h2.54V9.797c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.26c-1.243 0-1.63.771-1.63 1.562V12h2.773l-.443 2.89h-2.33v6.988C18.343 21.128 22 16.991 22 12z" clip-rule="evenodd"></path>
                        </svg>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-gray-600">
                        <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <path fill-rule="evenodd" d="M12.315 2c2.43 0 2.784.013 3.808.06 1.064.049 1.791.218 2.427.465a4.902 4.902 0 011.772 1.153 4.902 4.902 0 011.153 1.772c.247.636.416 1.363.465 2.427.048 1.067.06 1.407.06 4.123v.08c0 2.643-.012 2.987-.06 4.043-.049 1.064-.218 1.791-.465 2.427a4.902 4.902 0 01-1.153 1.772 4.902 4.902 0 01-1.772 1.153c-.636.247-1.363.416-2.427.465-1.067.048-1.407.06-4.123.06h-.08c-2.643 0-2.987-.012-4.043-.06-1.064-.049-1.791-.218-2.427-.465a4.902 4.902 0 01-1.772-1.153 4.902 4.902 0 01-1.153-1.772c-.247-.636-.416-1.363-.465-2.427-.047-1.024-.06-1.379-.06-3.808v-.63c0-2.43.013-2.784.06-3.808.049-1.064.218-1.791.465-2.427a4.902 4.902 0 011.153-1.772A4.902 4.902 0 015.45 2.525c.636-.247 1.363-.416 2.427-.465C8.901 2.013 9.256 2 11.685 2h.63zm-.081 1.802h-.468c-2.456 0-2.784.011-3.807.058-.975.045-1.504.207-1.857.344-.467.182-.8.398-1.15.748-.35.35-.566.683-.748 1.15-.137.353-.3.882-.344 1.857-.047 1.023-.058 1.351-.058 3.807v.468c0 2.456.011 2.784.058 3.807.045.975.207 1.504.344 1.857.182.466.399.8.748 1.15.35.35.683.566 1.15.748.353.137.882.3 1.857.344 1.054.048 1.37.058 4.041.058h.08c2.597 0 2.917-.01 3.96-.058.976-.045 1.505-.207 1.858-.344.466-.182.8-.398 1.15-.748.35-.35.566-.683.748-1.15.137-.353.3-.882.344-1.857.048-1.055.058-1.37.058-4.041v-.08c0-2.597-.01-2.917-.058-3.96-.045-.976-.207-1.505-.344-1.858a3.097 3.097 0 00-.748-1.15 3.098 3.098 0 00-1.15-.748c-.353-.137-.882-.3-1.857-.344-1.023-.047-1.351-.058-3.807-.058zM12 6.865a5.135 5.135 0 110 10.27 5.135 5.135 0 010-10.27zm0 1.802a3.333 3.333 0 100 6.666 3.333 3.333 0 000-6.666zm5.338-3.205a1.2 1.2 0 110 2.4 1.2 1.2 0 010-2.4z" clip-rule="evenodd"></path>
                        </svg>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-gray-600">
                        <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <path d="M8.29 20.251c7.547 0 11.675-6.253 11.675-11.675 0-.178 0-.355-.012-.53A8.348 8.348 0 0022 5.92a8.19 8.19 0 01-2.357.646 4.118 4.118 0 001.804-2.27 8.224 8.224 0 01-2.605.996 4.107 4.107 0 00-6.993 3.743 11.65 11.65 0 01-8.457-4.287 4.106 4.106 0 001.27 5.477A4.072 4.072 0 012.8 9.713v.052a4.105 4.105 0 003.292 4.022 4.095 4.095 0 01-1.853.07 4.108 4.108 0 003.834 2.85A8.233 8.233 0 012 18.407a11.616 11.616 0 006.29 1.84"></path>
                        </svg>
                    </a>
                </div>
            </div>
            
            <div>
                <h3 class="text-lg mb-4">Centre Map</h3>
                <ul class="text-sm text-gray-600 space-y-2">
                    <li><a href="#" class="hover:text-blue-600">Ground Floor</a></li>
                    <li><a href="#" class="hover:text-blue-600">First Floor</a></li>
                    <li><a href="#" class="hover:text-blue-600">Second Floor</a></li>
                    <li><a href="#" class="hover:text-blue-600">Car Park</a></li>
                    <li><a href="#" class="hover:text-blue-600">Disabled Access</a></li>
                </ul>
            </div>
            
            <div>
                <h3 class="text-lg mb-4">Services</h3>
                <ul class="text-sm text-gray-600 space-y-2">
                    <li><a href="#" class="hover:text-blue-600">Click & Collect</a></li>
                    <li><a href="#" class="hover:text-blue-600">Gift Card</a></li>
                    <li><a href="#" class="hover:text-blue-600">Free WiFi</a></li>
                    <li><a href="#" class="hover:text-blue-600">Children's Area</a></li>
                    <li><a href="#" class="hover:text-blue-600">Concierge</a></li>
                </ul>
            </div>
            
            <div>
                <h3 class="text-lg mb-4">Legal</h3>
                <ul class="text-sm text-gray-600 space-y-2">
                    <li><a href="#" class="hover:text-blue-600">Legal Notice</a></li>
                    <li><a href="#" class="hover:text-blue-600">Privacy Policy</a></li>
                    <li><a href="#" class="hover:text-blue-600">Terms & Conditions</a></li>
                    <li><a href="#" class="hover:text-blue-600">Cookies</a></li>
                </ul>
            </div>
        </div>
        
        <div class="mt-8 pt-8 border-t border-gray-200 text-sm text-gray-500 text-center">
            <p>&copy; <?php echo date('Y'); ?> Cergies. All rights reserved.</p>
        </div>
    </div>
</footer>