<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Become a Client - Imators Systems</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: radial-gradient(circle at center, #111111, #000000);
        }

        .glass {
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(20px);
        }

        .animate {
            animation: slideUp 0.7s ease;
        }

        @keyframes slideUp {
            from { transform: translateY(20px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }

        .feature-card {
            transition: transform 0.3s ease, background 0.3s ease;
        }

        .feature-card:hover {
            transform: translateY(-5px);
            background: rgba(255, 255, 255, 0.05);
        }

        input, select, textarea {
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid rgba(255, 255, 255, 0.05);
            transition: border-color 0.2s ease;
        }

        input:focus, select:focus, textarea:focus {
            border-color: rgba(255, 255, 255, 0.2);
            outline: none;
        }

        input::placeholder, textarea::placeholder {
            color: rgba(255, 255, 255, 0.3);
        }

        .option-card {
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .option-card:hover {
            background: rgba(255, 255, 255, 0.05);
        }

        .option-card.selected {
            background: rgba(255, 255, 255, 0.1);
            border-color: rgba(255, 255, 255, 0.2);
        }

        .toggle-switch {
            position: relative;
            display: inline-block;
            width: 50px;
            height: 24px;
        }

        .toggle-switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(255, 255, 255, 0.1);
            transition: .4s;
            border-radius: 24px;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 16px;
            width: 16px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            transition: .4s;
            border-radius: 50%;
        }

        input:checked + .slider {
            background-color: #ffffff;
        }

        input:checked + .slider:before {
            transform: translateX(26px);
            background-color: #000000;
        }

        .tooltip {
            visibility: hidden;
            position: absolute;
            background: rgba(0, 0, 0, 0.9);
            border: 1px solid rgba(255, 255, 255, 0.1);
            padding: 10px;
            border-radius: 6px;
            z-index: 1;
            opacity: 0;
            transition: opacity 0.3s;
            width: 250px;
            top: 100%;
            left: 50%;
            transform: translateX(-50%);
            margin-top: 5px;
        }

        .tooltip-container:hover .tooltip {
            visibility: visible;
            opacity: 1;
        }

        .language-selector {
            background: rgba(255, 255, 255, 0.03);
            border-radius: 8px;
            padding: 4px;
            display: inline-flex;
        }

        .language-option {
            padding: 6px 12px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            transition: all 0.2s ease;
        }

        .language-option.active {
            background: rgba(255, 255, 255, 0.1);
        }
    </style>
</head>
<body class="bg-black min-h-screen text-white p-6">
    <main class="max-w-6xl mx-auto">
        <div class="flex justify-between items-center mb-12">
            <a href="/" class="inline-block text-zinc-400 hover:text-white transition-colors">
                <span class="lang-fr">← Retour au portail</span>
                <span class="lang-en hidden">← Back to portal</span>
                <span class="lang-it hidden">← Ritorno al portale</span>
                <span class="lang-es hidden">← Volver al portal</span>
            </a>
            
            <div class="language-selector">
                <div class="language-option active" data-lang="fr">FR</div>
                <div class="language-option" data-lang="en">EN</div>
                <div class="language-option" data-lang="it">IT</div>
                <div class="language-option" data-lang="es">ES</div>
            </div>
        </div>

        <div class="text-center mb-16 animate">
            <h1 class="text-4xl font-light mb-4">
                <span class="lang-fr">Rejoindre Imators Systems</span>
                <span class="lang-en hidden">Join Imators Systems</span>
                <span class="lang-it hidden">Unisciti a Imators Systems</span>
                <span class="lang-es hidden">Únete a Imators Systems</span>
            </h1>
            <p class="text-zinc-400 text-lg max-w-2xl mx-auto">
                <span class="lang-fr">Accédez à notre infrastructure sécurisée de niveau professionnel et à nos outils de gestion conçus pour les clients exigeants</span>
                <span class="lang-en hidden">Access our enterprise-grade secure infrastructure and management tools designed for professional clients</span>
                <span class="lang-it hidden">Accedi alla nostra infrastruttura sicura di livello enterprise e agli strumenti di gestione progettati per clienti professionali</span>
                <span class="lang-es hidden">Accede a nuestra infraestructura segura de nivel empresarial y herramientas de gestión diseñadas para clientes profesionales</span>
            </p>
        </div>

        <div class="grid md:grid-cols-3 gap-8 mb-16 animate">
            <div class="glass rounded-2xl p-8 feature-card">
                <h3 class="text-xl font-medium mb-4">
                    <span class="lang-fr">Sécurité Avancée</span>
                    <span class="lang-en hidden">Advanced Security</span>
                    <span class="lang-it hidden">Sicurezza Avanzata</span>
                    <span class="lang-es hidden">Seguridad Avanzada</span>
                </h3>
                <ul class="space-y-3 text-zinc-400">
                    <li class="lang-fr">• Chiffrement de niveau entreprise</li>
                    <li class="lang-fr">• Protection DDoS 24/7</li>
                    <li class="lang-fr">• Audits de sécurité réguliers</li>
                    <li class="lang-fr">• Sauvegardes automatisées</li>
                    
                    <li class="lang-en hidden">• Enterprise-grade encryption</li>
                    <li class="lang-en hidden">• 24/7 DDoS protection</li>
                    <li class="lang-en hidden">• Regular security audits</li>
                    <li class="lang-en hidden">• Automated backups</li>
                    
                    <li class="lang-it hidden">• Crittografia di livello enterprise</li>
                    <li class="lang-it hidden">• Protezione DDoS 24/7</li>
                    <li class="lang-it hidden">• Audit di sicurezza regolari</li>
                    <li class="lang-it hidden">• Backup automatici</li>
                    
                    <li class="lang-es hidden">• Cifrado de nivel empresarial</li>
                    <li class="lang-es hidden">• Protección DDoS 24/7</li>
                    <li class="lang-es hidden">• Auditorías de seguridad regulares</li>
                    <li class="lang-es hidden">• Copias de seguridad automatizadas</li>
                </ul>
            </div>

            <div class="glass rounded-2xl p-8 feature-card">
                <h3 class="text-xl font-medium mb-4">
                    <span class="lang-fr">Infrastructure</span>
                    <span class="lang-en hidden">Infrastructure</span>
                    <span class="lang-it hidden">Infrastruttura</span>
                    <span class="lang-es hidden">Infraestructura</span>
                </h3>
                <ul class="space-y-3 text-zinc-400">
                    <li class="lang-fr">• Serveurs haute performance</li>
                    <li class="lang-fr">• Réseau CDN mondial</li>
                    <li class="lang-fr">• Garantie de disponibilité 99,9%</li>
                    <li class="lang-fr">• Ressources évolutives</li>
                    
                    <li class="lang-en hidden">• High-performance servers</li>
                    <li class="lang-en hidden">• Global CDN network</li>
                    <li class="lang-en hidden">• 99.9% uptime guarantee</li>
                    <li class="lang-en hidden">• Scalable resources</li>
                    
                    <li class="lang-it hidden">• Server ad alte prestazioni</li>
                    <li class="lang-it hidden">• Rete CDN globale</li>
                    <li class="lang-it hidden">• Garanzia di uptime del 99,9%</li>
                    <li class="lang-it hidden">• Risorse scalabili</li>
                    
                    <li class="lang-es hidden">• Servidores de alto rendimiento</li>
                    <li class="lang-es hidden">• Red CDN global</li>
                    <li class="lang-es hidden">• Garantía de disponibilidad del 99,9%</li>
                    <li class="lang-es hidden">• Recursos escalables</li>
                </ul>
            </div>

            <div class="glass rounded-2xl p-8 feature-card">
                <h3 class="text-xl font-medium mb-4">
                    <span class="lang-fr">Support & Outils</span>
                    <span class="lang-en hidden">Support & Tools</span>
                    <span class="lang-it hidden">Supporto & Strumenti</span>
                    <span class="lang-es hidden">Soporte & Herramientas</span>
                </h3>
                <ul class="space-y-3 text-zinc-400">
                    <li class="lang-fr">• Support technique 24/7</li>
                    <li class="lang-fr">• Tableau de bord de gestion</li>
                    <li class="lang-fr">• Plateforme d'analyse</li>
                    <li class="lang-fr">• Accès API</li>
                    
                    <li class="lang-en hidden">• 24/7 technical support</li>
                    <li class="lang-en hidden">• Management dashboard</li>
                    <li class="lang-en hidden">• Analytics platform</li>
                    <li class="lang-en hidden">• API access</li>
                    
                    <li class="lang-it hidden">• Supporto tecnico 24/7</li>
                    <li class="lang-it hidden">• Dashboard di gestione</li>
                    <li class="lang-it hidden">• Piattaforma di analisi</li>
                    <li class="lang-it hidden">• Accesso API</li>
                    
                    <li class="lang-es hidden">• Soporte técnico 24/7</li>
                    <li class="lang-es hidden">• Panel de control de gestión</li>
                    <li class="lang-es hidden">• Plataforma de análisis</li>
                    <li class="lang-es hidden">• Acceso API</li>
                </ul>
            </div>
        </div>

        <!-- Pricing Configurator -->
        <div class="glass rounded-2xl p-8 md:p-12 animate mb-16">
            <h2 class="text-2xl font-medium mb-8">
                <span class="lang-fr">Configurez Votre Solution</span>
                <span class="lang-en hidden">Configure Your Solution</span>
                <span class="lang-it hidden">Configura La Tua Soluzione</span>
                <span class="lang-es hidden">Configura Tu Solución</span>
            </h2>
            
            <div class="grid md:grid-cols-2 gap-8">
                <div class="space-y-8">
                    <!-- Storage Options -->
                    <div>
                        <h3 class="text-lg font-medium mb-4">
                            <span class="lang-fr">Capacité de Stockage</span>
                            <span class="lang-en hidden">Storage Capacity</span>
                            <span class="lang-it hidden">Capacità di Archiviazione</span>
                            <span class="lang-es hidden">Capacidad de Almacenamiento</span>
                        </h3>
                        <div class="grid grid-cols-2 sm:grid-cols-3 gap-3">
                            <div class="option-card storage-option p-4 rounded-xl border border-zinc-800 text-center" data-value="200GB">
                                <div class="text-sm font-medium">200GB</div>
                                <div class="text-xs text-zinc-400 mt-1">
                                    <span class="lang-fr">Basique</span>
                                    <span class="lang-en hidden">Basic</span>
                                    <span class="lang-it hidden">Base</span>
                                    <span class="lang-es hidden">Básico</span>
                                </div>
                            </div>
                            <div class="option-card storage-option p-4 rounded-xl border border-zinc-800 text-center" data-value="700GB">
                                <div class="text-sm font-medium">700GB</div>
                                <div class="text-xs text-zinc-400 mt-1">
                                    <span class="lang-fr">Standard</span>
                                    <span class="lang-en hidden">Standard</span>
                                    <span class="lang-it hidden">Standard</span>
                                    <span class="lang-es hidden">Estándar</span>
                                </div>
                            </div>
                            <div class="option-card storage-option p-4 rounded-xl border border-zinc-800 text-center" data-value="1TB">
                                <div class="text-sm font-medium">1TB</div>
                                <div class="text-xs text-zinc-400 mt-1">
                                    <span class="lang-fr">Professionnel</span>
                                    <span class="lang-en hidden">Professional</span>
                                    <span class="lang-it hidden">Professionale</span>
                                    <span class="lang-es hidden">Profesional</span>
                                </div>
                            </div>
                            <div class="option-card storage-option p-4 rounded-xl border border-zinc-800 text-center" data-value="5TB">
                                <div class="text-sm font-medium">5TB</div>
                                <div class="text-xs text-zinc-400 mt-1">
                                    <span class="lang-fr">Entreprise</span>
                                    <span class="lang-en hidden">Enterprise</span>
                                    <span class="lang-it hidden">Azienda</span>
                                    <span class="lang-es hidden">Empresa</span>
                                </div>
                            </div>
                            <div class="option-card storage-option p-4 rounded-xl border border-zinc-800 text-center" data-value="15TB">
                                <div class="text-sm font-medium">15TB</div>
                                <div class="text-xs text-zinc-400 mt-1">
                                    <span class="lang-fr">Entreprise+</span>
                                    <span class="lang-en hidden">Enterprise+</span>
                                    <span class="lang-it hidden">Azienda+</span>
                                    <span class="lang-es hidden">Empresa+</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Server Type -->
                    <div>
                        <h3 class="text-lg font-medium mb-4">
                            <span class="lang-fr">Type de Serveur</span>
                            <span class="lang-en hidden">Server Type</span>
                            <span class="lang-it hidden">Tipo di Server</span>
                            <span class="lang-es hidden">Tipo de Servidor</span>
                        </h3>
                        <div class="grid grid-cols-1 sm:grid-cols-3 gap-3">
                            <div class="option-card server-option p-4 rounded-xl border border-zinc-800 text-center" data-value="Web">
                                <div class="text-sm font-medium">
                                    <span class="lang-fr">Serveur Web</span>
                                    <span class="lang-en hidden">Web Server</span>
                                    <span class="lang-it hidden">Server Web</span>
                                    <span class="lang-es hidden">Servidor Web</span>
                                </div>
                                <div class="text-xs text-zinc-400 mt-1">
                                    <span class="lang-fr">Applications Web</span>
                                    <span class="lang-en hidden">Web Applications</span>
                                    <span class="lang-it hidden">Applicazioni Web</span>
                                    <span class="lang-es hidden">Aplicaciones Web</span>
                                </div>
                            </div>
                            <div class="option-card server-option p-4 rounded-xl border border-zinc-800 text-center" data-value="ImatorsSystems">
                                <div class="text-sm font-medium">Imators Systems</div>
                                <div class="text-xs text-zinc-400 mt-1">
                                    <span class="lang-fr">Solution Complète</span>
                                    <span class="lang-en hidden">Complete Solution</span>
                                    <span class="lang-it hidden">Soluzione Completa</span>
                                    <span class="lang-es hidden">Solución Completa</span>
                                </div>
                            </div>
                            <div class="option-card server-option p-4 rounded-xl border border-zinc-800 text-center" data-value="VPS">
                                <div class="text-sm font-medium">VPS</div>
                                <div class="text-xs text-zinc-400 mt-1">
                                    <span class="lang-fr">Serveur Privé Virtuel</span>
                                    <span class="lang-en hidden">Virtual Private Server</span>
                                    <span class="lang-it hidden">Server Privato Virtuale</span>
                                    <span class="lang-es hidden">Servidor Privado Virtual</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- RAM Options -->
                    <div>
                        <h3 class="text-lg font-medium mb-4">
                            <span class="lang-fr">Capacité RAM</span>
                            <span class="lang-en hidden">RAM Capacity</span>
                            <span class="lang-it hidden">Capacità RAM</span>
                            <span class="lang-es hidden">Capacidad RAM</span>
                        </h3>
                        <div class="grid grid-cols-2 sm:grid-cols-4 gap-3">
                            <div class="option-card ram-option p-4 rounded-xl border border-zinc-800 text-center" data-value="15GB">
                                <div class="text-sm font-medium">15GB</div>
                                <div class="text-xs text-zinc-400 mt-1">
                                    <span class="lang-fr">Basique</span>
                                    <span class="lang-en hidden">Basic</span>
                                    <span class="lang-it hidden">Base</span>
                                    <span class="lang-es hidden">Básico</span>
                                </div>
                            </div>
                            <div class="option-card ram-option p-4 rounded-xl border border-zinc-800 text-center" data-value="30GB">
                                <div class="text-sm font-medium">30GB</div>
                                <div class="text-xs text-zinc-400 mt-1">
                                    <span class="lang-fr">Standard</span>
                                    <span class="lang-en hidden">Standard</span>
                                    <span class="lang-it hidden">Standard</span>
                                    <span class="lang-es hidden">Estándar</span>
                                </div>
                            </div>
                            <div class="option-card ram-option p-4 rounded-xl border border-zinc-800 text-center" data-value="32GB">
                                <div class="text-sm font-medium">32GB</div>
                                <div class="text-xs text-zinc-400 mt-1">
                                    <span class="lang-fr">Professionnel</span>
                                    <span class="lang-en hidden">Professional</span>
                                    <span class="lang-it hidden">Professionale</span>
                                    <span class="lang-es hidden">Profesional</span>
                                </div>
                            </div>
                            <div class="option-card ram-option p-4 rounded-xl border border-zinc-800 text-center" data-value="50GB">
                                <div class="text-sm font-medium">50GB</div>
                                <div class="text-xs text-zinc-400 mt-1">
                                    <span class="lang-fr">Entreprise</span>
                                    <span class="lang-en hidden">Enterprise</span>
                                    <span class="lang-it hidden">Azienda</span>
                                    <span class="lang-es hidden">Empresa</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Billing Period -->
                    <div>
                        <h3 class="text-lg font-medium mb-4">
                            <span class="lang-fr">Période de Facturation</span>
                            <span class="lang-en hidden">Billing Period</span>
                            <span class="lang-it hidden">Periodo di Fatturazione</span>
                            <span class="lang-es hidden">Período de Facturación</span>
                        </h3>
                        <div class="flex items-center justify-between glass p-4 rounded-xl">
                            <div class="text-sm">
                                <span id="billing-label">
                                    <span class="lang-fr">Mensuel</span>
                                    <span class="lang-en hidden">Monthly</span>
                                    <span class="lang-it hidden">Mensile</span>
                                    <span class="lang-es hidden">Mensual</span>
                                </span>
                                <div class="text-xs text-zinc-400 mt-1" id="billing-discount">
                                    <span class="lang-fr">Prix standard</span>
                                    <span class="lang-en hidden">Standard price</span>
                                    <span class="lang-it hidden">Prezzo standard</span>
                                    <span class="lang-es hidden">Precio estándar</span>
                                </div>
                            </div>
                            <label class="toggle-switch">
                                <input type="checkbox" id="billing-toggle">
                                <span class="slider"></span>
                            </label>
                        </div>
                    </div>
                </div>

                <div class="space-y-8">
                    <!-- Additional Services -->
                    <div>
                        <h3 class="text-lg font-medium mb-4">
                            <span class="lang-fr">Services Additionnels</span>
                            <span class="lang-en hidden">Additional Services</span>
                            <span class="lang-it hidden">Servizi Aggiuntivi</span>
                            <span class="lang-es hidden">Servicios Adicionales</span>
                        </h3>
                        <div class="space-y-3">
                            <div class="flex items-center justify-between glass p-4 rounded-xl">
                                <div>
                                    <div class="text-sm font-medium">Claude <span class="text-xs text-zinc-400">by Anthropic</span></div>
                                    <div class="text-xs text-zinc-400 mt-1">
                                        <span class="lang-fr">Intégration assistant IA</span>
                                        <span class="lang-en hidden">AI assistant integration</span>
                                        <span class="lang-it hidden">Integrazione assistente IA</span>
                                        <span class="lang-es hidden">Integración asistente IA</span>
                                    </div>
                                </div>
                                <div class="flex items-center">
                                    <div class="tooltip-container relative mr-3">
                                        <button class="text-zinc-400 hover:text-white">
                                            <i class="fas fa-info-circle"></i>
                                        </button>
                                        <div class="tooltip text-xs">
                                            <span class="lang-fr">Claude sera inclus sur votre serveur si VSCode est sélectionné. L'assistant IA aide au développement de code et à la génération de texte.</span>
                                            <span class="lang-en hidden">Claude will be included in your server if VSCode is selected. The AI assistant helps with code development and text generation.</span>
                                            <span class="lang-it hidden">Claude sarà incluso nel tuo server se VSCode è selezionato. L'assistente IA aiuta con lo sviluppo del codice e la generazione di testo.</span>
                                            <span class="lang-es hidden">Claude se incluirá en tu servidor si se selecciona VSCode. El asistente de IA ayuda con el desarrollo de código y la generación de texto.</span>
                                        </div>
                                    </div>
                                    <input type="checkbox" class="h-5 w-5 rounded border-zinc-700 bg-transparent" name="additional_services[]" value="claude">
                                </div>
                            </div>

                            <div class="flex items-center justify-between glass p-4 rounded-xl">
                                <div>
                                    <div class="text-sm font-medium">Google API</div>
                                    <div class="text-xs text-zinc-400 mt-1">
                                        <span class="lang-fr">Intégration services Google</span>
                                        <span class="lang-en hidden">Google services integration</span>
                                        <span class="lang-it hidden">Integrazione servizi Google</span>
                                        <span class="lang-es hidden">Integración servicios Google</span>
                                    </div>
                                </div>
                                <div class="flex items-center">
                                    <div class="tooltip-container relative mr-3">
                                        <button class="text-zinc-400 hover:text-white">
                                            <i class="fas fa-info-circle"></i>
                                        </button>
                                        <div class="tooltip text-xs">
                                            <span class="lang-fr">Vous devrez fournir une clé API émise par Google pour utiliser ce service.</span>
                                            <span class="lang-en hidden">You will need to provide an API key issued by Google to use this service.</span>
                                            <span class="lang-it hidden">Dovrai fornire una chiave API rilasciata da Google per utilizzare questo servizio.</span>
                                            <span class="lang-es hidden">Necesitarás proporcionar una clave API emitida por Google para usar este servicio.</span>
                                        </div>
                                    </div>
                                    <input type="checkbox" class="h-5 w-5 rounded border-zinc-700 bg-transparent" name="additional_services[]" value="google">
                                </div>
                            </div>

                            <div class="flex items-center justify-between glass p-4 rounded-xl">
                                <div>
                                    <div class="text-sm font-medium">MapKit.js</div>
                                    <div class="text-xs text-zinc-400 mt-1">
                                        <span class="lang-fr">Intégration Apple Maps</span>
                                        <span class="lang-en hidden">Apple Maps integration</span>
                                        <span class="lang-it hidden">Integrazione Apple Maps</span>
                                        <span class="lang-es hidden">Integración Apple Maps</span>
                                    </div>
                                </div>
                                <div class="flex items-center">
                                    <div class="tooltip-container relative mr-3">
                                        <button class="text-zinc-400 hover:text-white">
                                            <i class="fas fa-info-circle"></i>
                                        </button>
                                        <div class="tooltip text-xs">
                                            <span class="lang-fr">Nécessite une clé API fournie par Apple via le Tableau de bord Développeur.</span>
                                            <span class="lang-en hidden">Requires an API key provided by Apple via the Developer Dashboard.</span>
                                            <span class="lang-it hidden">Richiede una chiave API fornita da Apple tramite la Dashboard Sviluppatore.</span>
                                            <span class="lang-es hidden">Requiere una clave API proporcionada por Apple a través del Dashboard de Desarrollador.</span>
                                        </div>
                                    </div>
                                    
                                                                        <input type="checkbox" class="h-5 w-5 rounded border-zinc-700 bg-transparent" name="additional_services[]" value="mapkit">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Price Calculation -->
                    <div class="glass rounded-xl p-6 mt-8">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg font-medium">
                                <span class="lang-fr">Prix Estimé</span>
                                <span class="lang-en hidden">Estimated Price</span>
                                <span class="lang-it hidden">Prezzo Stimato</span>
                                <span class="lang-es hidden">Precio Estimado</span>
                            </h3>
                            <div class="text-xs text-zinc-400">
                                <span class="lang-fr">Niveau Professionnel</span>
                                <span class="lang-en hidden">Professional Tier</span>
                                <span class="lang-it hidden">Livello Professionale</span>
                                <span class="lang-es hidden">Nivel Profesional</span>
                            </div>
                        </div>
                        
                        <div class="space-y-3 mb-6">
                            <div class="flex justify-between text-sm">
                                <span>
                                    <span class="lang-fr">Stockage</span>
                                    <span class="lang-en hidden">Storage</span>
                                    <span class="lang-it hidden">Archiviazione</span>
                                    <span class="lang-es hidden">Almacenamiento</span>
                                    (<span id="summary-storage">--</span>)
                                </span>
                                <span id="price-storage">--</span>
                            </div>
                            <div class="flex justify-between text-sm">
                                <span>
                                    <span class="lang-fr">Type de Serveur</span>
                                    <span class="lang-en hidden">Server Type</span>
                                    <span class="lang-it hidden">Tipo di Server</span>
                                    <span class="lang-es hidden">Tipo de Servidor</span>
                                    (<span id="summary-server">--</span>)
                                </span>
                                <span id="price-server">--</span>
                            </div>
                            <div class="flex justify-between text-sm">
                                <span>
                                    <span class="lang-fr">RAM</span>
                                    <span class="lang-en hidden">RAM</span>
                                    <span class="lang-it hidden">RAM</span>
                                    <span class="lang-es hidden">RAM</span>
                                    (<span id="summary-ram">--</span>)
                                </span>
                                <span id="price-ram">--</span>
                            </div>
                            <div class="border-t border-zinc-800 my-2"></div>
                            <div class="flex justify-between text-sm font-medium">
                                <span>
                                    <span class="lang-fr">Total</span>
                                    <span class="lang-en hidden">Total</span>
                                    <span class="lang-it hidden">Totale</span>
                                    <span class="lang-es hidden">Total</span>
                                    (<span id="billing-period">
                                        <span class="lang-fr">mensuel</span>
                                        <span class="lang-en hidden">monthly</span>
                                        <span class="lang-it hidden">mensile</span>
                                        <span class="lang-es hidden">mensual</span>
                                    </span>)
                                </span>
                                <span id="price-total" class="text-base">--</span>
                            </div>
                        </div>
                        
                        <button type="button" id="continue-plan" class="w-full bg-white hover:bg-gray-200 text-black font-medium py-3 rounded-lg transition-all">
                            <span class="lang-fr">Continuer avec ce plan</span>
                            <span class="lang-en hidden">Continue with this plan</span>
                            <span class="lang-it hidden">Continua con questo piano</span>
                            <span class="lang-es hidden">Continuar con este plan</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="glass rounded-2xl p-8 md:p-12 animate">
            <h2 class="text-2xl font-medium mb-8">
                <span class="lang-fr">Inscription Client</span>
                <span class="lang-en hidden">Client Registration</span>
                <span class="lang-it hidden">Registrazione Cliente</span>
                <span class="lang-es hidden">Registro de Cliente</span>
            </h2>
            
            <form action="process_registration.php" method="post" class="space-y-8">
                <input type="hidden" name="selected_storage" id="form-storage" value="">
                <input type="hidden" name="selected_server" id="form-server" value="">
                <input type="hidden" name="selected_ram" id="form-ram" value="">
                <input type="hidden" name="billing_period" id="form-billing" value="monthly">
                <input type="hidden" name="total_price" id="form-total" value="">
                
                <div class="grid md:grid-cols-2 gap-8">
                    <div class="space-y-6">
                        <h3 class="text-lg font-medium mb-4">
                            <span class="lang-fr">Informations de l'Entreprise</span>
                            <span class="lang-en hidden">Company Information</span>
                            <span class="lang-it hidden">Informazioni Aziendali</span>
                            <span class="lang-es hidden">Información de la Empresa</span>
                        </h3>
                        
                        <div>
                            <label class="block text-sm text-zinc-400 mb-2">
                                <span class="lang-fr">Nom de l'Entreprise *</span>
                                <span class="lang-en hidden">Company Name *</span>
                                <span class="lang-it hidden">Nome Azienda *</span>
                                <span class="lang-es hidden">Nombre de la Empresa *</span>
                            </label>
                            <input type="text" name="company_name" required 
                                   class="w-full px-4 py-3 rounded-xl text-white">
                        </div>

                        <div>
                            <label class="block text-sm text-zinc-400 mb-2">
                                <span class="lang-fr">Numéro d'Immatriculation *</span>
                                <span class="lang-en hidden">Registration Number *</span>
                                <span class="lang-it hidden">Numero di Registrazione *</span>
                                <span class="lang-es hidden">Número de Registro *</span>
                            </label>
                            <input type="text" name="registration_number" required 
                                   class="w-full px-4 py-3 rounded-xl text-white">
                        </div>

                        <div>
                            <label class="block text-sm text-zinc-400 mb-2">
                                <span class="lang-fr">Adresse de l'Entreprise *</span>
                                <span class="lang-en hidden">Company Address *</span>
                                <span class="lang-it hidden">Indirizzo Aziendale *</span>
                                <span class="lang-es hidden">Dirección de la Empresa *</span>
                            </label>
                            <textarea name="company_address" required rows="3" 
                                      class="w-full px-4 py-3 rounded-xl text-white"></textarea>
                        </div>

                        <div>
                            <label class="block text-sm text-zinc-400 mb-2">
                                <span class="lang-fr">Secteur d'Activité *</span>
                                <span class="lang-en hidden">Industry Sector *</span>
                                <span class="lang-it hidden">Settore Industriale *</span>
                                <span class="lang-es hidden">Sector Industrial *</span>
                            </label>
                            <select name="industry_sector" required class="w-full px-4 py-3 rounded-xl text-white">
                                <option value="">
                                    <span class="lang-fr">Sélectionnez un secteur</span>
                                    <span class="lang-en hidden">Select sector</span>
                                    <span class="lang-it hidden">Seleziona settore</span>
                                    <span class="lang-es hidden">Selecciona sector</span>
                                </option>
                                <option value="technology">
                                    <span class="lang-fr">Technologie</span>
                                    <span class="lang-en hidden">Technology</span>
                                    <span class="lang-it hidden">Tecnologia</span>
                                    <span class="lang-es hidden">Tecnología</span>
                                </option>
                                <option value="finance">
                                    <span class="lang-fr">Finance</span>
                                    <span class="lang-en hidden">Finance</span>
                                    <span class="lang-it hidden">Finanza</span>
                                    <span class="lang-es hidden">Finanzas</span>
                                </option>
                                <option value="healthcare">
                                    <span class="lang-fr">Santé</span>
                                    <span class="lang-en hidden">Healthcare</span>
                                    <span class="lang-it hidden">Sanità</span>
                                    <span class="lang-es hidden">Salud</span>
                                </option>
                                <option value="manufacturing">
                                    <span class="lang-fr">Fabrication</span>
                                    <span class="lang-en hidden">Manufacturing</span>
                                    <span class="lang-it hidden">Produzione</span>
                                    <span class="lang-es hidden">Fabricación</span>
                                </option>
                                <option value="retail">
                                    <span class="lang-fr">Commerce de Détail</span>
                                    <span class="lang-en hidden">Retail</span>
                                    <span class="lang-it hidden">Vendita al Dettaglio</span>
                                    <span class="lang-es hidden">Comercio Minorista</span>
                                </option>
                                <option value="other">
                                    <span class="lang-fr">Autre</span>
                                    <span class="lang-en hidden">Other</span>
                                    <span class="lang-it hidden">Altro</span>
                                    <span class="lang-es hidden">Otro</span>
                                </option>
                            </select>
                        </div>
                    </div>

                    <div class="space-y-6">
                        <h3 class="text-lg font-medium mb-4">
                            <span class="lang-fr">Coordonnées de Contact</span>
                            <span class="lang-en hidden">Contact Details</span>
                            <span class="lang-it hidden">Dettagli di Contatto</span>
                            <span class="lang-es hidden">Detalles de Contacto</span>
                        </h3>
                        
                        <div>
                            <label class="block text-sm text-zinc-400 mb-2">
                                <span class="lang-fr">Nom du Contact *</span>
                                <span class="lang-en hidden">Contact Name *</span>
                                <span class="lang-it hidden">Nome Contatto *</span>
                                <span class="lang-es hidden">Nombre de Contacto *</span>
                            </label>
                            <input type="text" name="contact_name" required 
                                   class="w-full px-4 py-3 rounded-xl text-white">
                        </div>

                        <div>
                            <label class="block text-sm text-zinc-400 mb-2">
                                <span class="lang-fr">Poste *</span>
                                <span class="lang-en hidden">Position *</span>
                                <span class="lang-it hidden">Posizione *</span>
                                <span class="lang-es hidden">Cargo *</span>
                            </label>
                            <input type="text" name="position" required 
                                   class="w-full px-4 py-3 rounded-xl text-white">
                        </div>

                        <div>
                            <label class="block text-sm text-zinc-400 mb-2">
                                <span class="lang-fr">Email Professionnel *</span>
                                <span class="lang-en hidden">Professional Email *</span>
                                <span class="lang-it hidden">Email Professionale *</span>
                                <span class="lang-es hidden">Email Profesional *</span>
                            </label>
                            <input type="email" name="email" required 
                                   class="w-full px-4 py-3 rounded-xl text-white">
                        </div>

                        <div>
                            <label class="block text-sm text-zinc-400 mb-2">
                                <span class="lang-fr">Numéro de Téléphone *</span>
                                <span class="lang-en hidden">Phone Number *</span>
                                <span class="lang-it hidden">Numero di Telefono *</span>
                                <span class="lang-es hidden">Número de Teléfono *</span>
                            </label>
                            <input type="tel" name="phone" required 
                                   class="w-full px-4 py-3 rounded-xl text-white">
                        </div>

                        <div>
                            <label class="block text-sm text-zinc-400 mb-2">
                                <span class="lang-fr">Description du Projet *</span>
                                <span class="lang-en hidden">Project Description *</span>
                                <span class="lang-it hidden">Descrizione del Progetto *</span>
                                <span class="lang-es hidden">Descripción del Proyecto *</span>
                            </label>
                            <textarea name="project_description" required rows="3" 
                                      class="w-full px-4 py-3 rounded-xl text-white"
                                      placeholder=""></textarea>
                        </div>
                    </div>
                </div>

                <div class="pt-6 border-t border-zinc-800">
                    <label class="flex items-start space-x-3">
                        <input type="checkbox" name="terms_agree" required class="mt-1">
                        <span class="text-sm text-zinc-400">
                            <span class="lang-fr">J'accepte le traitement de mes données conformément à la <a href="https://imators.com/privacy" class="text-white hover:underline">politique de confidentialité</a> et j'accepte les <a href="https://imators.com/terms-of-use" class="text-white hover:underline">conditions d'utilisation</a> *</span>
                            <span class="lang-en hidden">I agree to the processing of my data according to the <a href="https://imators.com/privacy" class="text-white hover:underline">privacy policy</a> and accept the <a href="https://imators.com/terms-of-use" class="text-white hover:underline">terms of service</a> *</span>
                            <span class="lang-it hidden">Acconsento al trattamento dei miei dati secondo la <a href="https://imators.com/privacy" class="text-white hover:underline">privacy policy</a> e accetto i <a href="https://imators.com/terms-of-use" class="text-white hover:underline">termini di servizio</a> *</span>
                            <span class="lang-es hidden">Acepto el procesamiento de mis datos de acuerdo con la <a href="https://imators.com/privacy" class="text-white hover:underline">política de privacidad</a> y acepto los <a href="https://imators.com/terms-of-use" class="text-white hover:underline">términos de servicio</a> *</span>
                        </span>
                    </label>
                </div>

                <div class="flex justify-end">
                    <button type="submit" 
                            class="bg-white hover:bg-gray-50 text-black px-8 py-3 rounded-xl font-medium transition-all duration-200 hover:transform hover:-translate-y-1">
                        <span class="lang-fr">Soumettre l'Inscription</span>
                        <span class="lang-en hidden">Submit Registration</span>
                        <span class="lang-it hidden">Invia Registrazione</span>
                        <span class="lang-es hidden">Enviar Registro</span>
                    </button>
                </div>
            </form>
        </div>
    </main>

    <script>
    // Language switcher
    document.querySelectorAll('.language-option').forEach(option => {
        option.addEventListener('click', () => {
            const lang = option.getAttribute('data-lang');
            document.querySelectorAll('.language-option').forEach(opt => opt.classList.remove('active'));
            option.classList.add('active');
            
            // Hide all language elements
            document.querySelectorAll('[class*="lang-"]').forEach(el => {
                el.classList.add('hidden');
            });
            
            // Show selected language elements
            document.querySelectorAll(`.lang-${lang}`).forEach(el => {
                el.classList.remove('hidden');
            });
        });
    });

    // Pricing configuration
    const prices = {
        storage: {
            '200GB': 10,
            '700GB': 20,
            '1TB': 35,
            '5TB': 70,
            '15TB': 150
        },
        server: {
            'Web': 15,
            'ImatorsSystems': 30,
            'VPS': 45
        },
        ram: {
            '15GB': 25,
            '30GB': 45,
            '32GB': 50,
            '50GB': 80
        }
    };

    // Selection state
    const selection = {
        storage: null,
        server: null,
        ram: null,
        annual: false
    };

    // Select first option in each category by default
    document.querySelector('.storage-option').classList.add('selected');
    document.querySelector('.server-option').classList.add('selected');
    document.querySelector('.ram-option').classList.add('selected');
    
    selection.storage = document.querySelector('.storage-option').getAttribute('data-value');
    selection.server = document.querySelector('.server-option').getAttribute('data-value');
    selection.ram = document.querySelector('.ram-option').getAttribute('data-value');

    // Update summaries
    updateSummary();

    // Update hidden form fields
    updateFormFields();

    // Set up event listeners
    document.querySelectorAll('.storage-option').forEach(option => {
        option.addEventListener('click', () => {
            document.querySelectorAll('.storage-option').forEach(opt => opt.classList.remove('selected'));
            option.classList.add('selected');
            selection.storage = option.getAttribute('data-value');
            updateSummary();
            updateFormFields();
        });
    });

    document.querySelectorAll('.server-option').forEach(option => {
        option.addEventListener('click', () => {
            document.querySelectorAll('.server-option').forEach(opt => opt.classList.remove('selected'));
            option.classList.add('selected');
            selection.server = option.getAttribute('data-value');
            updateSummary();
            updateFormFields();
        });
    });

    document.querySelectorAll('.ram-option').forEach(option => {
        option.addEventListener('click', () => {
            document.querySelectorAll('.ram-option').forEach(opt => opt.classList.remove('selected'));
            option.classList.add('selected');
            selection.ram = option.getAttribute('data-value');
            updateSummary();
            updateFormFields();
        });
    });

    // Billing toggle
    document.getElementById('billing-toggle').addEventListener('change', (e) => {
        selection.annual = e.target.checked;
        if (selection.annual) {
            document.getElementById('billing-label').textContent = document.querySelector('.language-option.active').getAttribute('data-lang') === 'fr' ? 'Annuel' : 
                (document.querySelector('.language-option.active').getAttribute('data-lang') === 'en' ? 'Annual' : 
                (document.querySelector('.language-option.active').getAttribute('data-lang') === 'it' ? 'Annuale' : 'Anual'));
                
            document.getElementById('billing-discount').textContent = document.querySelector('.language-option.active').getAttribute('data-lang') === 'fr' ? 'Économisez 20%' : 
                (document.querySelector('.language-option.active').getAttribute('data-lang') === 'en' ? 'Save 20%' : 
                (document.querySelector('.language-option.active').getAttribute('data-lang') === 'it' ? 'Risparmia 20%' : 'Ahorra 20%'));
                
            document.getElementById('billing-period').textContent = document.querySelector('.language-option.active').getAttribute('data-lang') === 'fr' ? 'annuel' : 
                (document.querySelector('.language-option.active').getAttribute('data-lang') === 'en' ? 'annual' : 
                (document.querySelector('.language-option.active').getAttribute('data-lang') === 'it' ? 'annuale' : 'anual'));
        } else {
            document.getElementById('billing-label').textContent = document.querySelector('.language-option.active').getAttribute('data-lang') === 'fr' ? 'Mensuel' : 
                (document.querySelector('.language-option.active').getAttribute('data-lang') === 'en' ? 'Monthly' : 
                (document.querySelector('.language-option.active').getAttribute('data-lang') === 'it' ? 'Mensile' : 'Mensual'));
                
            document.getElementById('billing-discount').textContent = document.querySelector('.language-option.active').getAttribute('data-lang') === 'fr' ? 'Prix standard' : 
                (document.querySelector('.language-option.active').getAttribute('data-lang') === 'en' ? 'Standard price' : 
                (document.querySelector('.language-option.active').getAttribute('data-lang') === 'it' ? 'Prezzo standard' : 'Precio estándar'));
                
            document.getElementById('billing-period').textContent = document.querySelector('.language-option.active').getAttribute('data-lang') === 'fr' ? 'mensuel' : 
                (document.querySelector('.language-option.active').getAttribute('data-lang') === 'en' ? 'monthly' : 
                (document.querySelector('.language-option.active').getAttribute('data-lang') === 'it' ? 'mensile' : 'mensual'));
        }
        updateSummary();
        updateFormFields();
    });

    // Continue with this plan button
    document.getElementById('continue-plan').addEventListener('click', () => {
        document.querySelector('form').scrollIntoView({ behavior: 'smooth' });
    });

    function updateSummary() {
        // Update summary text
        document.getElementById('summary-storage').textContent = selection.storage || '--';
        document.getElementById('summary-server').textContent = selection.server || '--';
        document.getElementById('summary-ram').textContent = selection.ram || '--';
        
        // Calculate prices
        const storagePrice = prices.storage[selection.storage] || 0;
        const serverPrice = prices.server[selection.server] || 0;
        const ramPrice = prices.ram[selection.ram] || 0;
        
        // Display component prices
        document.getElementById('price-storage').textContent = `€${storagePrice}`;
        document.getElementById('price-server').textContent = `€${serverPrice}`;
        document.getElementById('price-ram').textContent = `€${ramPrice}`;
        
        // Calculate total
        let total = storagePrice + serverPrice + ramPrice;
        
        // Ensure minimum price of €50
        if (total < 50) total = 50;
        
        // Apply annual discount
        if (selection.annual) {
            const annualPrice = total * 12 * 0.8; // 20% discount
            document.getElementById('price-total').textContent = `€${annualPrice.toFixed(0)}`;
        } else {
            document.getElementById('price-total').textContent = `€${total.toFixed(0)}`;
        }
    }

    function updateFormFields() {
        document.getElementById('form-storage').value = selection.storage;
        document.getElementById('form-server').value = selection.server;
        document.getElementById('form-ram').value = selection.ram;
        document.getElementById('form-billing').value = selection.annual ? 'annual' : 'monthly';
        
        // Calculate total price
        const storagePrice = prices.storage[selection.storage] || 0;
        const serverPrice = prices.server[selection.server] || 0;
        const ramPrice = prices.ram[selection.ram] || 0;
        let total = storagePrice + serverPrice + ramPrice;
        if (total < 50) total = 50;
        
        if (selection.annual) {
            const annualPrice = total * 12 * 0.8;
            document.getElementById('form-total').value = annualPrice.toFixed(0);
        } else {
            document.getElementById('form-total').value = total.toFixed(0);
        }
    }
    </script>
</body>
</html>