<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bank of Peerkinton</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            font-family: 'Inter', sans-serif;
        }
    </style>
</head>
<body class="bg-[#0B0E14] text-gray-100">
    <!-- Header -->
    <header class="bg-[#151823] shadow-xl">
        <div class="container mx-auto px-4 h-16 flex items-center justify-between">
            <div class="flex items-center space-x-6">
                <div class="text-2xl font-bold tracking-tight">Bank of Peerkinton</div>
                <div class="hidden sm:block text-sm px-3 py-1 rounded-lg bg-blue-500/10">
                    <?= date('d/m/Y') ?>
                </div>
            </div>
            <div class="flex items-center space-x-6">
                <div class="text-sm text-right">
                    <div class="font-medium text-blue-400"><?= htmlspecialchars($_SESSION['level']) ?></div>
                    <div class="text-xs text-gray-400"><?= htmlspecialchars($_SESSION['role']) ?></div>
                </div>
                <a href="?logout=1" 
                   class="text-sm px-4 py-2 rounded-lg bg-red-500/10 text-red-400 hover:bg-red-500/20 transition-colors">
                    Déconnexion
                </a>
            </div>
        </div>
    </header>

    <!-- Main -->
    <main class="container mx-auto px-4 py-8">
        <!-- Stats -->
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <!-- Balance -->
            <div class="bg-[#151823] rounded-xl shadow-xl p-6">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <h3 class="text-sm text-gray-400">PIB de Peerkinton</h3>
                        <p class="text-2xl font-bold text-blue-400 mt-1">
                            <?= format_number($stats['total_balance']) ?>
                        </p>
                    </div>
                    <div class="bg-blue-500/10 p-3 rounded-lg">
                        <svg class="w-8 h-8 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" 
                                  d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Comptes bloqués -->
            <div class="bg-[#151823] rounded-xl shadow-xl p-6">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <h3 class="text-sm text-gray-400">Comptes Bloqués</h3>
                        <p class="text-2xl font-bold text-red-400 mt-1">
                            <?= $stats['blocked_accounts'] ?>
                        </p>
                    </div>
                    <div class="bg-red-500/10 p-3 rounded-lg">
                        <svg class="w-8 h-8 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" 
                                  d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Montants suspects -->
            <div class="bg-[#151823] rounded-xl shadow-xl p-6">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <h3 class="text-sm text-gray-400">Total des sommes échangées classées comme suspectes</h3>
                        <p class="text-2xl font-bold text-yellow-400 mt-1">
                            <?= format_number($stats['suspicious_amount']) ?>
                        </p>
                    </div>
                    <div class="bg-yellow-500/10 p-3 rounded-lg">
                        <svg class="w-8 h-8 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" 
                                  d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Total utilisateurs -->
            <div class="bg-[#151823] rounded-xl shadow-xl p-6">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <h3 class="text-sm text-gray-400">Nombre de client en banque</h3>
                        <p class="text-2xl font-bold text-green-400 mt-1">
                            <?= $stats['total_users'] ?>
                        </p>
                    </div>
                    <div class="bg-green-500/10 p-3 rounded-lg">
                        <svg class="w-8 h-8 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" 
                                  d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                        </svg>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tableaux -->
        <div class="grid grid-cols-1 xl:grid-cols-2 gap-8">
            <!-- Liste des comptes -->
            <div class="bg-[#151823] rounded-xl shadow-xl overflow-hidden">
                <div class="p-6 border-b border-gray-800">
                    <div class="flex flex-col sm:flex-row justify-between gap-4">
                        <h2 class="text-xl font-bold">Comptes Clients</h2>
                        <div class="flex flex-col sm:flex-row gap-3">
                            <input type="text" id="searchClient" placeholder="Rechercher..." 
                                   class="w-full sm:w-auto px-4 py-2 rounded-lg bg-[#0B0E14] border border-gray-800 focus:border-blue-500 transition-colors text-sm">
                            <select id="filterStatus" 
                                   class="w-full sm:w-auto px-4 py-2 rounded-lg bg-[#0B0E14] border border-gray-800 focus:border-blue-500 transition-colors text-sm">
                                <option value="all">Tous les statuts</option>
                                <option value="active">Actifs</option>
                                <option value="blocked">Bloqués</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="bg-[#0B0E14]/50 text-left">
                                <th class="p-4 text-sm font-medium text-gray-400">Client</th>
                                <th class="p-4 text-sm font-medium text-gray-400">Email</th>
                                <th class="p-4 text-sm font-medium text-gray-400 text-right">Balance</th>
                                <th class="p-4 text-sm font-medium text-gray-400 text-center">Statut</th>
                                <?php if($_SESSION['role'] === 'admin'): ?>
                                <th class="p-4 text-sm font-medium text-gray-400 text-center">Actions</th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-800">
                            <?php foreach($users as $user): ?>
                            <tr class="hover:bg-[#0B0E14]/50 transition-colors">
                                <td class="p-4">
                                    <div class="font-medium text-white">
                                        <?= htmlspecialchars($user['firstname'] . ' ' . $user['lastname']) ?>
                                    </div>
                                    <div class="text-xs text-gray-500">ID: <?= htmlspecialchars($user['userid']) ?></div>
                                </td>
                                <td class="p-4 text-gray-300">
                                    <?= htmlspecialchars($user['email']) ?>
                                </td>
                                <td class="p-4 text-right font-medium text-white">
                                    <?= format_number($user['balance']) ?>
                                </td>
                                <td class="p-4">
                                    <div class="flex justify-center">
                                        <?php if($user['blocked-account'] === 'true'): ?>
                                            <span class="inline-flex items-center gap-1.5 px-2.5 py-1.5 rounded-full text-xs font-medium bg-red-500/10 text-red-400">
                                                <span class="h-1.5 w-1.5 rounded-full bg-red-400"></span>
                                                Bloqué
                                            </span>
                                        <?php else: ?>
                                            <span class="inline-flex items-center gap-1.5 px-2.5 py-1.5 rounded-full text-xs font-medium bg-green-500/10 text-green-400">
                                                <span class="h-1.5 w-1.5 rounded-full bg-green-400"></span>
                                                Actif
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <?php if($_SESSION['role'] === 'admin'): ?>
                                <td class="p-4 text-center">
                                    <form method="POST" class="inline-block">
                                        <input type="hidden" name="userid" value="<?= htmlspecialchars($user['userid']) ?>">
                                        <?php if($user['blocked-account'] === 'true'): ?>
                                            <button type="submit" name="action" value="unblock" 
                                                    class="px-4 py-1.5 rounded-lg bg-green-500/10 text-green-400 hover:bg-green-500/20 transition-colors text-sm">
                                                Débloquer
                                            </button>
                                        <?php else: ?>
                                            <button type="submit" name="action" value="block"
                                                    onclick="return confirm('Êtes-vous sûr de vouloir bloquer ce compte ?')"
                                                    class="px-4 py-1.5 rounded-lg bg-red-500/10 text-red-400 hover:bg-red-500/20 transition-colors text-sm">
                                                Bloquer
                                            </button>
                                        <?php endif; ?>
                                    </form>
                                </td>
                                <?php endif; ?>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Transactions Suspectes -->
            <div class="bg-[#151823] rounded-xl shadow-xl overflow-hidden">
                <div class="p-6 border-b border-gray-800 flex justify-between items-center">
                    <h2 class="text-xl font-bold">Transactions Suspectes</h2>
                    <span class="px-3 py-1 rounded-lg bg-yellow-500/10 text-yellow-400 text-sm">
                        <?= count($transactions) ?> transactions
                    </span>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="bg-[#0B0E14]/50 text-left">
                                <th class="p-4 text-sm font-medium text-gray-400">Transaction ID</th>
                                <th class="p-4 text-sm font-medium text-gray-400">De</th>
                                <th class="p-4 text-sm font-medium text-gray-400">Vers</th>
                                <th class="p-4 text-sm font-medium text-gray-400 text-right">Montant</th>
                                <th class="p-4 text-sm font-medium text-gray-400 text-right">Le / Il y'a</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-800">
                            <?php foreach($transactions as $trans): ?>
                            <tr class="hover:bg-[#0B0E14]/50 transition-colors">
                                <td class="p-4">
                                    <div class="font-medium text-white">#<?= htmlspecialchars($trans['id']) ?></div>
                                    <div class="text-xs text-gray-500"><?= htmlspecialchars($trans['type']) ?></div>
                                </td>
                                <td class="p-4">
                                    <div class="font-medium text-white">
                                        <?= htmlspecialchars($trans['sender_firstname'] . ' ' . $trans['sender_lastname']) ?>
                                    </div>
                                    <div class="text-xs text-gray-500">ID: <?= htmlspecialchars($trans['sender_id']) ?></div>
                                </td>
                                <td class="p-4">
                                    <div class="font-medium text-white">
                                        <?= htmlspecialchars($trans['recipient_firstname'] . ' ' . $trans['recipient_lastname']) ?>
                                    </div>
                                    <div class="text-xs text-gray-500">ID: <?= htmlspecialchars($trans['recipient_id']) ?></div>
                                </td>
                                <td class="p-4 text-right font-bold text-red-400">
                                    <?= format_number($trans['amount']) ?>
                                </td>
                                <td class="p-4 text-right text-gray-500">
                                    <?= time_ago($trans['created_at']) ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </main>

    <script>
    // Recherche en temps réel
    document.getElementById('searchClient').addEventListener('input', function(e) {
        const searchTerm = e.target.value.toLowerCase();
        const rows = document.querySelectorAll('tbody tr');
        
        rows.forEach(row => {
            const text = row.textContent.toLowerCase();
            row.style.display = text.includes(searchTerm) ? '' : 'none';
        });
    });

    // Filtre par statut
    document.getElementById('filterStatus').addEventListener('change', function(e) {
        const status = e.target.value;
        const rows = document.querySelectorAll('tbody tr');
        
        rows.forEach(row => {
            if (status === 'all') {
                row.style.display = '';
                return;
            }
            
            const isBlocked = row.querySelector('.text-red-400') !== null;
            const isActive = row.querySelector('.text-green-400') !== null;
            
            if (status === 'blocked' && isBlocked) row.style.display = '';
            else if (status === 'active' && isActive) row.style.display = '';
            else row.style.display = 'none';
        });
    });
    </script>
</body>
</html>