
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>AWPO Promo</title>
<style>
    body {
        font-family: Tahoma, Geneva, sans-serif;
        background: #000080;
        color: black;
        margin: 0; padding: 0;
        display: flex;
        flex-direction: column;
        height: 100vh;
        justify-content: center;
        align-items: center;
        user-select: none;
    }
    .popup {
        background: #ECE9D8;
        border: 2px solid #000080;
        box-shadow: 5px 5px 0 #404040;
        width: 400px;
    }
    .titlebar {
        background: linear-gradient(to right, #000080, #0000CD);
        color: white;
        padding: 5px 10px;
        font-weight: bold;
        font-size: 14px;
        user-select: none;
    }
    .content {
        display: flex;
        padding: 15px;
        gap: 15px;
        align-items: center;
    }
    .content img {
        width: 64px;
        height: 64px;
        border: 1px solid #808080;
    }
    .text {
        font-size: 13px;
        line-height: 1.4em;
        flex: 1;
    }
    .actions {
        display: flex;
        justify-content: flex-end;
        padding: 10px;
        background: #D4D0C8;
    }
    .btn {
        background: #E1E1E1;
        border: 1px solid #808080;
        padding: 3px 12px;
        font-size: 12px;
        cursor: pointer;
    }
    .btn:active {
        border: 1px solid #000000;
        background: #C0C0C0;
    }
</style>
</head>
<body>
    <div class="popup">
        <div class="titlebar">AWPO Promotion</div>
        <div class="content">
            <img src="cube.png" alt="Cube">
            <div class="text">
                Discover AWPO on desktop for a full experience!  
                Enjoy better visuals, faster performance, and exclusive features.
            </div>
        </div>
        <div class="actions">
            <button class="btn" onclick="window.location.href='https://awpo.example.com'">Learn More</button>
        </div>
    </div>
</body>
</html>
