<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Internet Explorer 6.0</title>
</head>
<body>
<div style="height: 100vh; display: flex; flex-direction: column; background: #ECE9D8; font-family: 'MS Sans Serif', sans-serif; font-size: 11px;">
    
    <div style="background: linear-gradient(to bottom, #FFFFFF, #E4E4E4); border-bottom: 1px solid #919B9C; padding: 8px;">
        <div style="display: flex; align-items: center;">
            <div style="width: 16px; height: 16px; background: #0054E3; margin-right: 8px;"></div>
            <div>
                <div style="font-size: 16px; font-weight: bold; color: #003399;">Internet Explorer</div>
                <div style="font-size: 10px; color: #666;">Version 6.0.2900.2180 - Microsoft Corporation</div>
            </div>
            <div style="margin-left: auto; display: flex; gap: 10px; align-items: center;">
                <div style="text-align: center;">
                    <div style="font-size: 10px; color: #666;">Connexion</div>
                    <div style="font-size: 12px; color: #008000; font-weight: bold;">CONNECTÉ</div>
                </div>
                <div style="text-align: center;">
                    <div style="font-size: 10px; color: #666;">Sécurité</div>
                    <div style="font-size: 11px;">Zone Internet</div>
                </div>
            </div>
        </div>
    </div>
    
    <div style="background: #F0F0F0; border-bottom: 1px solid #919B9C; padding: 2px;">
        <span class="menu-item" onclick="showMenu('fichier')">Fichier</span>
        <span class="menu-item" onclick="showMenu('edition')">Edition</span>
        <span class="menu-item" onclick="showMenu('affichage')">Affichage</span>
        <span class="menu-item" onclick="showMenu('favoris')">Favoris</span>
        <span class="menu-item" onclick="showMenu('outils')">Outils</span>
        <span class="menu-item" onclick="showMenu('aide')">?</span>
    </div>
    
    <div style="background: #F0F0F0; border-bottom: 1px solid #919B9C; padding: 5px; display: flex;">
        <button class="toolbar-btn" onclick="goBack()" title="Précédent">
            <span style="font-size: 16px;">◀</span>
        </button>
        <button class="toolbar-btn" onclick="goForward()" title="Suivant">
            <span style="font-size: 16px;">▶</span>
        </button>
        <button class="toolbar-btn" onclick="stopLoading()" title="Arrêter">
            <span style="font-size: 16px;">⏹</span>
        </button>
        <button class="toolbar-btn" onclick="refreshPage()" title="Actualiser">
            <span style="font-size: 16px;">🔄</span>
        </button>
        <button class="toolbar-btn" onclick="goHome()" title="Accueil">
            <span style="font-size: 16px;">🏠</span>
        </button>
        <div style="width: 2px; height: 20px; background: #919B9C; margin: 0 5px;"></div>
        <button class="toolbar-btn" onclick="showSearch()" title="Rechercher">
            <span style="font-size: 16px;">🔍</span>
        </button>
        <button class="toolbar-btn" onclick="showFavorites()" title="Favoris">
            <span style="font-size: 16px;">⭐</span>
        </button>
        <button class="toolbar-btn" onclick="showHistory()" title="Historique">
            <span style="font-size: 16px;">📚</span>
        </button>
    </div>
    
    <div style="background: #F0F0F0; border-bottom: 1px solid #919B9C; padding: 3px; display: flex; align-items: center;">
        <span style="margin-right: 5px;">Adresse</span>
        <input type="text" id="addressBar" value="http://www.google.com" 
               style="flex: 1; height: 20px; border: 1px inset #C0C0C0; padding: 2px; font-size: 11px; font-family: 'MS Sans Serif', sans-serif;"
               onkeypress="if(event.keyCode==13) navigateTo()">
        <button onclick="navigateTo()" style="margin-left: 5px; padding: 2px 8px; background: #ECE9D8; border: 1px outset #C0C0C0; font-size: 11px; cursor: pointer;">Atteindre</button>
    </div>
    
    <div style="flex: 1; display: flex;">
        
        <div style="width: 180px; background: white; border-right: 1px solid #919B9C; padding: 10px;">
            <div style="font-weight: bold; margin-bottom: 10px; color: #003399;">Liens</div>
            
            <div class="link-item" onclick="navigateToUrl('http://www.google.com')">
                🌐 Google
            </div>
            <div class="link-item" onclick="navigateToUrl('http://www.yahoo.com')">
                🌐 Yahoo!
            </div>
            <div class="link-item" onclick="navigateToUrl('http://www.msn.com')">
                🌐 MSN
            </div>
            <div class="link-item" onclick="navigateToUrl('http://www.altavista.com')">
                🌐 AltaVista
            </div>
            <div class="link-item" onclick="navigateToUrl('http://www.lycos.com')">
                🌐 Lycos
            </div>
            <div class="link-item" onclick="navigateToUrl('http://www.excite.com')">
                🌐 Excite
            </div>
            
            <div style="margin-top: 20px; font-weight: bold; margin-bottom: 10px; color: #003399;">Favoris</div>
            <div class="link-item" onclick="alert('Favoris vide')">
                📁 Dossier vide
            </div>
        </div>
        
        <div style="flex: 1; padding: 0; overflow-y: auto; background: white;">
            
            <div id="google-page" class="page-content">
                <div style="text-align: center; padding: 80px 20px; background: white;">
                    <div style="font-size: 72px; font-weight: bold; margin-bottom: 25px; font-family: serif;">
                        <span style="color: #4285f4;">G</span><span style="color: #ea4335;">o</span><span style="color: #fbbc05;">o</span><span style="color: #4285f4;">g</span><span style="color: #34a853;">l</span><span style="color: #ea4335;">e</span>
                    </div>
                    
                    <div style="margin-bottom: 25px;">
                        <input type="text" id="searchInput" placeholder="Rechercher sur le Web" 
                               style="width: 400px; height: 24px; border: 2px inset #C0C0C0; padding: 2px 8px; font-size: 12px;"
                               onkeypress="if(event.keyCode==13) performRealSearch()">
                    </div>
                    
                    <div style="margin-bottom: 30px;">
                        <button onclick="performRealSearch()" style="padding: 4px 12px; margin-right: 10px; background: #F0F0F0; border: 1px outset #C0C0C0; font-size: 11px; cursor: pointer;">Recherche Google</button>
                        <button onclick="feelingLucky()" style="padding: 4px 12px; background: #F0F0F0; border: 1px outset #C0C0C0; font-size: 11px; cursor: pointer;">J'ai de la chance</button>
                    </div>
                    
                    <div style="font-size: 10px; color: #666;">
                        <a href="#" onclick="navigateToUrl('http://www.google.com/advanced_search')" style="color: #0000EE;">Recherche avancée</a> | 
                        <a href="#" onclick="navigateToUrl('http://www.google.com/preferences')" style="color: #0000EE;">Préférences</a> | 
                        <a href="#" onclick="navigateToUrl('http://www.google.com/language_tools')" style="color: #0000EE;">Outils linguistiques</a>
                    </div>
                    
                    <div style="margin-top: 40px; font-size: 10px; color: #666;">
                        Effectuez vos recherches en 
                        <a href="#" style="color: #0000EE;">français</a> ou visitez 
                        <a href="#" style="color: #0000EE;">Google.com in English</a>
                    </div>
                </div>
            </div>
            
            <div id="results-page" class="page-content" style="display: none; padding: 20px;">
                <div style="margin-bottom: 15px;">
                    <div style="font-size: 14px; color: #666;">Résultats pour <strong id="searchTerm"></strong></div>
                </div>
                
                <div id="searchResults"></div>
            </div>
            
            <div id="loading-page" class="page-content" style="display: none; text-align: center; padding: 100px;">
                <div style="font-size: 14px; color: #666; margin-bottom: 20px;">Recherche en cours...</div>
                <div style="border: 2px inset #C0C0C0; height: 20px; width: 300px; margin: 0 auto; background: white;">
                    <div id="loadingBar" style="height: 100%; background: linear-gradient(to right, #316AC5, #6B9BD1); width: 0%;"></div>
                </div>
            </div>
            
        </div>
    </div>
    
    <div style="background: #ECE9D8; border-top: 1px solid #919B9C; padding: 2px 5px; font-size: 11px; display: flex;">
        <div id="statusText">Terminé</div>
        <div style="margin-left: auto;">Zone Internet | Protégé</div>
    </div>
</div>

<style>
.menu-item {
    padding: 3px 8px;
    cursor: pointer;
    display: inline-block;
}

.menu-item:hover {
    background: #316AC5;
    color: white;
}

.toolbar-btn {
    width: 24px;
    height: 22px;
    background: #F0F0F0;
    border: 1px solid transparent;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 2px;
}

.toolbar-btn:hover {
    border: 1px outset #C0C0C0;
    background: #E0E0E0;
}

.link-item {
    padding: 3px 5px;
    cursor: pointer;
    font-size: 11px;
    margin: 1px 0;
    border-radius: 0;
}

.link-item:hover {
    background: #316AC5;
    color: white;
}

.page-content {
    min-height: 100%;
}

a {
    text-decoration: underline;
    cursor: pointer;
}

a:hover {
    color: #FF0000;
}

.search-result {
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px dotted #E0E0E0;
}

.result-title {
    color: #0000EE;
    font-size: 13px;
    text-decoration: underline;
    cursor: pointer;
    margin-bottom: 3px;
    font-weight: normal;
}

.result-title:hover {
    color: #FF0000;
}

.result-url {
    color: #008000;
    font-size: 10px;
    margin-bottom: 5px;
}

.result-snippet {
    font-size: 11px;
    color: #000;
    line-height: 1.4;
}
</style>

<script>
let currentPage = 'google';
let searchHistory = [];

async function performRealSearch() {
    const query = document.getElementById('searchInput').value.trim();
    if (!query) return;
    
    document.getElementById('statusText').textContent = 'Recherche en cours...';
    document.getElementById('searchTerm').textContent = query;
    searchHistory.push(query);
    
    showLoading();
    
    try {
        const response = await fetch('https://api.duckduckgo.com/?q=' + encodeURIComponent(query) + '&format=json&no_html=1&skip_disambig=1');
        const data = await response.json();
        
        setTimeout(() => {
            displayRealResults(query, data);
            document.getElementById('statusText').textContent = 'Terminé';
        }, 1000);
        
    } catch (error) {
        console.error('Erreur de recherche:', error);
        setTimeout(() => {
            displayFallbackResults(query);
            document.getElementById('statusText').textContent = 'Terminé';
        }, 1000);
    }
}

function displayRealResults(query, data) {
    document.querySelectorAll('.page-content').forEach(page => {
        page.style.display = 'none';
    });
    document.getElementById('results-page').style.display = 'block';
    
    let resultsHtml = '';
    
    if (data.AbstractText) {
        resultsHtml += `
            <div class="search-result">
                <div class="result-title">${data.AbstractSource || 'Wikipédia'}</div>
                <div class="result-url">${data.AbstractURL || 'https://fr.wikipedia.org'}</div>
                <div class="result-snippet">${data.AbstractText}</div>
            </div>
        `;
    }
    
    if (data.RelatedTopics && data.RelatedTopics.length > 0) {
        data.RelatedTopics.slice(0, 8).forEach(topic => {
            if (topic.Text && topic.FirstURL) {
                resultsHtml += `
                    <div class="search-result">
                        <div class="result-title" onclick="openUrl('${topic.FirstURL}')">${topic.Text.split(' - ')[0]}</div>
                        <div class="result-url">${topic.FirstURL}</div>
                        <div class="result-snippet">${topic.Text}</div>
                    </div>
                `;
            }
        });
    }
    
    if (!resultsHtml) {
        displayFallbackResults(query);
        return;
    }
    
    document.getElementById('searchResults').innerHTML = resultsHtml;
}

function displayFallbackResults(query) {
    document.querySelectorAll('.page-content').forEach(page => {
        page.style.display = 'none';
    });
    document.getElementById('results-page').style.display = 'block';
    
    const fallbackResults = [
        {
            title: `${query} - Wikipédia`,
            url: `https://fr.wikipedia.org/wiki/${encodeURIComponent(query)}`,
            snippet: `Article Wikipédia sur ${query}. Découvrez des informations détaillées, l'histoire et les références concernant ${query}.`
        },
        {
            title: `Recherche ${query} - Actualités`,
            url: `https://news.google.com/search?q=${encodeURIComponent(query)}`,
            snippet: `Dernières actualités et nouvelles concernant ${query}. Restez informé des derniers développements.`
        },
        {
            title: `${query} - Images et photos`,
            url: `https://images.google.com/search?q=${encodeURIComponent(query)}`,
            snippet: `Collection d'images et photos liées à ${query}. Explorez une galerie visuelle complète.`
        },
        {
            title: `Guide complet sur ${query}`,
            url: `https://www.google.com/search?q=${encodeURIComponent(query + ' guide')}`,
            snippet: `Guide détaillé et tutoriels sur ${query}. Apprenez tout ce qu'il faut savoir avec nos experts.`
        },
        {
            title: `Forum et discussions ${query}`,
            url: `https://www.reddit.com/search/?q=${encodeURIComponent(query)}`,
            snippet: `Discussions communautaires et forums sur ${query}. Partagez vos expériences et posez vos questions.`
        }
    ];
    
    let resultsHtml = '';
    fallbackResults.forEach(result => {
        resultsHtml += `
            <div class="search-result">
                <div class="result-title" onclick="openUrl('${result.url}')">${result.title}</div>
                <div class="result-url">${result.url}</div>
                <div class="result-snippet">${result.snippet}</div>
            </div>
        `;
    });
    
    document.getElementById('searchResults').innerHTML = resultsHtml;
}

function openUrl(url) {
    window.open(url, '_blank');
}

function navigateTo() {
    const url = document.getElementById('addressBar').value;
    navigateToUrl(url);
}

function navigateToUrl(url) {
    document.getElementById('statusText').textContent = 'Ouverture de la page...';
    document.getElementById('addressBar').value = url;
    
    if (url.includes('google.com') || url === 'http://www.google.com') {
        showGooglePage();
        document.getElementById('statusText').textContent = 'Terminé';
    } else {
        window.open(url, '_blank');
        document.getElementById('statusText').textContent = 'Page ouverte dans un nouvel onglet';
    }
}

function showLoading() {
    document.querySelectorAll('.page-content').forEach(page => {
        page.style.display = 'none';
    });
    document.getElementById('loading-page').style.display = 'block';
    
    let progress = 0;
    const interval = setInterval(() => {
        progress += Math.random() * 15;
        if (progress > 100) {
            progress = 100;
            clearInterval(interval);
        }
        document.getElementById('loadingBar').style.width = progress + '%';
    }, 100);
}

function showGooglePage() {
    document.querySelectorAll('.page-content').forEach(page => {
        page.style.display = 'none';
    });
    document.getElementById('google-page').style.display = 'block';
    currentPage = 'google';
}

function feelingLucky() {
    const query = document.getElementById('searchInput').value.trim();
    if (query) {
        window.open(`https://www.google.com/search?q=${encodeURIComponent(query)}&btnI=1`, '_blank');
    }
}

function goBack() {
    if (currentPage === 'results') {
        showGooglePage();
    } else {
        alert('Aucune page précédente');
    }
}

function goForward() {
    alert('Aucune page suivante');
}

function goHome() {
    showGooglePage();
    document.getElementById('addressBar').value = 'http://www.google.com';
}

function refreshPage() {
    location.reload();
}

function stopLoading() {
    document.getElementById('statusText').textContent = 'Arrêté';
}

function showSearch() {
    document.getElementById('searchInput').focus();
}

function showFavorites() {
    alert('Favoris\n\nAucun favori enregistré');
}

function showHistory() {
    alert('Historique\n\n' + (searchHistory.length > 0 ? searchHistory.join('\n') : 'Aucun historique'));
}

function showMenu(menu) {
    const menus = {
        'fichier': 'Nouveau\nOuvrir\nEnregistrer\nImprimer\nQuitter',
        'edition': 'Copier\nColler\nSélectionner tout\nRechercher',
        'affichage': 'Actualiser\nArrêter\nPlein écran\nCode source',
        'favoris': 'Ajouter aux favoris\nOrganiser les favoris',
        'outils': 'Options Internet\nBloqueur de fenêtres popup\nEffacer l\'historique',
        'aide': 'Aide de Internet Explorer\nÀ propos de Internet Explorer'
    };
    alert(menus[menu] || 'Menu non disponible');
}

showGooglePage();
</script>
</body>
</html>