<?php
$appName = $_GET['app'] ?? 'Unknown';
?>

<div style="height: 100%; display: flex; flex-direction: column; background: #C0C0C0;">
    <div style="background: #0000AA; color: white; padding: 5px; text-align: center; font-family: monospace;">
        AWPO - Erreur d'application
    </div>

```
<div style="flex: 1; display: flex; justify-content: center; align-items: center; padding: 20px;">
    <div style="background: white; border: 2px solid #000; padding: 20px; max-width: 400px; box-shadow: 2px 2px 0 #808080;">
        <div style="display: flex; align-items: center; margin-bottom: 20px;">
            <div style="font-size: 48px; margin-right: 20px;">❌</div>
            <div>
                <h2 style="margin: 0; font-size: 16px;">Erreur d'exécution</h2>
                <p style="margin: 5px 0; font-size: 12px;">L'application demandée n'a pas pu être trouvée</p>
            </div>
        </div>
        
        <div style="background: #F0F0F0; border: 1px solid #808080; padding: 10px; margin-bottom: 15px; font-family: monospace; font-size: 11px;">
            <strong>Détails techniques:</strong><br>
            Application: <?= htmlspecialchars($appName) ?>.exe<br>
            Code erreur: 0x<?= strtoupper(substr(md5($appName), 0, 8)) ?><br>
            Module: KERNEL32.DLL<br>
            Exception: FILE_NOT_FOUND<br>
            <br>
            Stack trace:<br>
            at AWPO.System.LoadApplication()<br>
            at AWPO.Core.Execute()<br>
            at StartMenu.Launch()<br>
        </div>
        
        <div style="margin-bottom: 15px; font-size: 12px;">
            <strong>Causes possibles:</strong>
            <ul style="margin: 5px 0; padding-left: 20px;">
                <li>L'application n'est pas installée</li>
                <li>Le fichier a été supprimé ou déplacé</li>
                <li>Corruption des données système</li>
                <li>Interférence paranormale détectée</li>
            </ul>
        </div>
        
        <div style="text-align: center;">
            <button onclick="tryReload()" style="padding: 5px 15px; margin: 0 5px;">🔄 Réessayer</button>
            <button onclick="parent.closeWindow(window.frameElement.parentElement.id, '<?= htmlspecialchars($appName) ?>')" style="padding: 5px 15px; margin: 0 5px;">❌ Fermer</button>
            <button onclick="reportError()" style="padding: 5px 15px; margin: 0 5px;">📧 Signaler</button>
        </div>
    </div>
</div>

<div style="background: #808080; padding: 5px; text-align: center; font-size: 10px; border-top: 1px solid white;">
    Si le problème persiste, contactez votre administrateur système | Error ID: <?= uniqid('ERR_') ?>
</div>

</div>

<script>
function tryReload() {
    parent.showNotification('Erreur', 'Tentative de rechargement...', 'warning');
    setTimeout(() => {
        parent.showNotification('Erreur', 'L\'application <?= htmlspecialchars($appName) ?> est toujours introuvable', 'error');
    }, 1000);
}

function reportError() {
    parent.showNotification('Rapport d\'erreur', 'Le rapport a été envoyé à l\'administrateur', 'info');
    parent.gameState.errors++;
}

// Effet de glitch aléatoire sur la page d'erreur
setInterval(() => {
    if (Math.random() < 0.05) {
        document.body.style.filter = 'invert(1)';
        setTimeout(() => {
            document.body.style.filter = 'none';
        }, 100);
    }
}, 3000);
</script>