<?php
session_start();

if (!isset($_SESSION['conversations'])) {
    $_SESSION['conversations'] = generateInitialConversations();
}

function generateInitialConversations() {
    return [
        [
            'id' => 'conv_mitchell',
            'contact' => 'Dr. Mitchell',
            'avatar' => '👨‍⚕️',
            'status' => 'online',
            'messages' => [
                ['sender' => 'Dr. Mitchell', 'text' => "As-tu vérifié le dossier 47?", 'time' => '14:32'],
                ['sender' => 'Dr. Mitchell', 'text' => "C'est urgent!", 'time' => '14:33'],
                ['sender' => 'Dr. Mitchell', 'text' => "Réponds quand tu vois ce message", 'time' => '14:35']
            ]
        ],
        [
            'id' => 'conv_admin',
            'contact' => 'Admin Système',
            'avatar' => '🖥️',
            'status' => 'online',
            'messages' => [
                ['sender' => 'Admin Système', 'text' => "Maintenance prévue ce soir", 'time' => '10:15'],
                ['sender' => 'Admin Système', 'text' => "23h00 - 02h00", 'time' => '10:15'],
                ['sender' => 'Admin Système', 'text' => "Sauvegardez votre travail", 'time' => '10:16']
            ]
        ],
        [
            'id' => 'conv_unknown',
            'contact' => 'Inconnu',
            'avatar' => '❓',
            'status' => 'offline',
            'messages' => [
                ['sender' => 'Inconnu', 'text' => "Ils savent...", 'time' => '03:33'],
                ['sender' => 'Inconnu', 'text' => "Ne leur fais pas confiance", 'time' => '03:33'],
                ['sender' => 'Inconnu', 'text' => "01001000 01000101 01001100 01010000", 'time' => '03:34']
            ]
        ]
    ];
}

if (isset($_POST['action'])) {
    header('Content-Type: application/json');
    
    switch($_POST['action']) {
        case 'sendMessage':
            $convId = $_POST['convId'];
            $message = $_POST['message'];
            
            foreach ($_SESSION['conversations'] as &$conv) {
                if ($conv['id'] == $convId) {
                    $conv['messages'][] = [
                        'sender' => 'Vous',
                        'text' => $message,
                        'time' => date('H:i')
                    ];
                    
                    $response = generateAutoResponse($conv['contact'], $message);
                    if ($response) {
                        $conv['messages'][] = [
                            'sender' => $conv['contact'],
                            'text' => $response,
                            'time' => date('H:i', strtotime('+1 minute'))
                        ];
                    }
                    
                    echo json_encode(['success' => true, 'response' => $response]);
                    exit;
                }
            }
            break;
    }
}

function generateAutoResponse($contact, $userMessage) {
    $userMessage = strtolower($userMessage);
    
    switch($contact) {
        case 'Dr. Mitchell':
            if (strpos($userMessage, 'oui') !== false || strpos($userMessage, 'vérifié') !== false) {
                return "Bien. Assure-toi de suivre le protocole standard.";
            } elseif (strpos($userMessage, 'non') !== false) {
                return "Fais-le immédiatement! C'est prioritaire!";
            } elseif (strpos($userMessage, 'dossier') !== false) {
                return "Le dossier 47 contient des informations classifiées. Sois prudent.";
            } else {
                return "Je n'ai pas le temps pour ça. Concentre-toi sur le dossier 47.";
            }
            
        case 'Admin Système':
            return "Message automatique: Votre message a été enregistré. Un technicien vous répondra sous 24-48h.";
            
        case 'Inconnu':
            $responses = [
                "...",
                "Ils arrivent",
                "Tu ne peux pas leur échapper",
                "ERREUR ERREUR ERREUR",
                "La vérité est dans le code",
                "Ne regarde pas derrière toi"
            ];
            return $responses[array_rand($responses)];
            
        default:
            return null;
    }
}

$selectedConv = $_SESSION['conversations'][0];
if (isset($_GET['convId'])) {
    foreach ($_SESSION['conversations'] as $conv) {
        if ($conv['id'] == $_GET['convId']) {
            $selectedConv = $conv;
            break;
        }
    }
}
?>

<div style="height: 100%; display: flex; background: #ECE9D8;">
    <div style="width: 250px; background: #F0F0F0; border-right: 2px solid #999;">
        <div style="background: #4169C7; color: white; padding: 8px; font-weight: bold;">
            💬 Messages
        </div>
        
        <?php foreach ($_SESSION['conversations'] as $conv): ?>
            <div class="contact-item" 
                 onclick="selectConversation('<?= $conv['id'] ?>')"
                 data-conv-id="<?= $conv['id'] ?>"
                 style="padding: 10px; 
                        border-bottom: 1px solid #DDD; 
                        cursor: pointer;
                        background: <?= $conv['id'] == $selectedConv['id'] ? '#D0E0F0' : 'white' ?>;">
                <div style="display: flex; align-items: center;">
                    <span style="font-size: 28px; margin-right: 10px;"><?= $conv['avatar'] ?></span>
                    <div style="flex: 1;">
                        <div style="font-weight: bold;"><?= $conv['contact'] ?></div>
                        <div style="font-size: 10px; color: <?= $conv['status'] == 'online' ? 'green' : '#999' ?>;">
                            ● <?= $conv['status'] ?>
                        </div>
                        <div style="font-size: 11px; color: #666; margin-top: 2px;">
                            <?= end($conv['messages'])['text'] ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    
    <div style="flex: 1; display: flex; flex-direction: column;">
        <div style="background: linear-gradient(to bottom, #ECE9D8, #D4D0C8); 
                    padding: 10px; 
                    border-bottom: 1px solid #999;
                    display: flex;
                    align-items: center;">
            <span id="currentAvatar" style="font-size: 24px; margin-right: 10px;"><?= $selectedConv['avatar'] ?></span>
            <div>
                <div id="currentContact" style="font-weight: bold;"><?= $selectedConv['contact'] ?></div>
                <div id="currentStatus" style="font-size: 10px; color: <?= $selectedConv['status'] == 'online' ? 'green' : '#999' ?>;">
                    <?= $selectedConv['status'] ?>
                </div>
            </div>
        </div>
        
        <div id="messageArea" style="flex: 1; overflow-y: auto; padding: 10px; background: white;">
            <?php foreach ($selectedConv['messages'] as $msg): ?>
                <div style="margin: 8px 0; display: flex; justify-content: <?= $msg['sender'] == 'Vous' ? 'flex-end' : 'flex-start' ?>;">
                    <div style="max-width: 60%; 
                                background: <?= $msg['sender'] == 'Vous' ? '#DCF8C6' : '#E0E0E0' ?>; 
                                padding: 8px 12px; 
                                border-radius: 10px;">
                        <div style="font-size: 9px; color: #666; margin-bottom: 2px;">
                            <?= $msg['sender'] ?> - <?= $msg['time'] ?>
                        </div>
                        <div style="font-size: 12px;"><?= htmlspecialchars($msg['text']) ?></div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <div style="padding: 10px; background: #F0F0F0; border-top: 1px solid #999;">
            <div style="display: flex; gap: 5px;">
                <input type="text" 
                       id="messageInput" 
                       placeholder="Tapez votre message..." 
                       style="flex: 1; padding: 5px; border: 1px solid #999;"
                       onkeypress="if(event.key === 'Enter') sendMessage()">
                <button onclick="sendMessage()" style="padding: 5px 15px; background: #4169C7; color: white; border: none; cursor: pointer;">
                    Envoyer
                </button>
            </div>
            <div style="margin-top: 5px;">
                <button onclick="insertQuickReply('Oui')" style="padding: 2px 8px; margin: 0 2px; font-size: 10px;">Oui</button>
                <button onclick="insertQuickReply('Non')" style="padding: 2px 8px; margin: 0 2px; font-size: 10px;">Non</button>
                <button onclick="insertQuickReply('Je ne sais pas')" style="padding: 2px 8px; margin: 0 2px; font-size: 10px;">Je ne sais pas</button>
                <button onclick="insertQuickReply('Plus tard')" style="padding: 2px 8px; margin: 0 2px; font-size: 10px;">Plus tard</button>
                <button onclick="insertQuickReply('Compris')" style="padding: 2px 8px; margin: 0 2px; font-size: 10px;">Compris</button>
            </div>
        </div>
    </div>
</div>

<script>
let currentConvId = '<?= $selectedConv['id'] ?>';
let conversations = <?= json_encode($_SESSION['conversations']) ?>;
let messageCheckInterval;

function selectConversation(convId) {
    currentConvId = convId;
    const conv = conversations.find(c => c.id === convId);
    
    if (!conv) return;
    
    document.querySelectorAll('.contact-item').forEach(item => {
        item.style.background = item.dataset.convId === convId ? '#D0E0F0' : 'white';
    });
    
    document.getElementById('currentAvatar').textContent = conv.avatar;
    document.getElementById('currentContact').textContent = conv.contact;
    document.getElementById('currentStatus').textContent = conv.status;
    document.getElementById('currentStatus').style.color = conv.status === 'online' ? 'green' : '#999';
    
    const messageArea = document.getElementById('messageArea');
    messageArea.innerHTML = '';
    conv.messages.forEach(msg => {
        const msgDiv = document.createElement('div');
        msgDiv.style.margin = '8px 0';
        msgDiv.style.display = 'flex';
        msgDiv.style.justifyContent = msg.sender === 'Vous' ? 'flex-end' : 'flex-start';
        
        const bubble = document.createElement('div');
        bubble.style.maxWidth = '60%';
        bubble.style.background = msg.sender === 'Vous' ? '#DCF8C6' : '#E0E0E0';
        bubble.style.padding = '8px 12px';
        bubble.style.borderRadius = '10px';
        
        const senderInfo = document.createElement('div');
        senderInfo.style.fontSize = '9px';
        senderInfo.style.color = '#666';
        senderInfo.style.marginBottom = '2px';
        senderInfo.textContent = `${msg.sender} - ${msg.time}`;
        
        const textDiv = document.createElement('div');
        textDiv.style.fontSize = '12px';
        textDiv.textContent = msg.text;
        
        bubble.appendChild(senderInfo);
        bubble.appendChild(textDiv);
        msgDiv.appendChild(bubble);
        messageArea.appendChild(msgDiv);
    });
}

window.insertQuickReply = function(text) {
    const input = document.getElementById('messageInput');
    input.value = text;
    sendMessage();
}

function sendMessage() {
    const input = document.getElementById('messageInput');
    const message = input.value.trim();
    if (!message) return;
    
    input.value = '';
    
    fetch('', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams({
            action: 'sendMessage',
            convId: currentConvId,
            message: message
        })
    })
    .then(res => res.json())
    .then(data => {
        if (!data.success) return;
        
        const conv = conversations.find(c => c.id === currentConvId);
        conv.messages.push({
            sender: 'Vous',
            text: message,
            time: new Date().toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'})
        });
        
        if (data.response) {
            conv.messages.push({
                sender: conv.contact,
                text: data.response,
                time: new Date(Date.now() + 60000).toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'})
            });
        }
        
        selectConversation(currentConvId);
    });
}

selectConversation(currentConvId);
</script>
