<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($family['family_name']); ?> - Family Hub</title>
    <link rel="icon" type="image/png" href="/assets/images/favicon.png">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+KR:wght@300;400;500;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
</head>
<body class="bg-gray-50 font-sans">
    <div x-data="{ sidebarOpen: false }">
        <nav class="bg-white shadow-sm">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex">
                        <div class="flex-shrink-0 flex items-center">
                            <button @click="sidebarOpen = !sidebarOpen" class="md:hidden mr-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                                </svg>
                            </button>
                            <img class="h-8" src="/assets/images/logo.png" alt="Family Hub Logo">
                            <span class="ml-2 text-xl font-semibold text-gray-900"><?php echo htmlspecialchars($family['family_name']); ?></span>
                        </div>
                        <div class="hidden md:ml-6 md:flex md:space-x-8">
                            <a href="?page=home" class="<?php echo $page === 'home' ? 'border-b-2 border-indigo-500' : 'border-b-2 border-transparent'; ?> text-gray-900 inline-flex items-center px-1 pt-1 text-sm font-medium">Home</a>
                            <a href="?page=photos" class="<?php echo $page === 'photos' ? 'border-b-2 border-indigo-500' : 'border-b-2 border-transparent'; ?> text-gray-900 inline-flex items-center px-1 pt-1 text-sm font-medium">Photos</a>
                            <a href="?page=calendar" class="<?php echo $page === 'calendar' ? 'border-b-2 border-indigo-500' : 'border-b-2 border-transparent'; ?> text-gray-900 inline-flex items-center px-1 pt-1 text-sm font-medium">Calendar</a>
                            <a href="?page=members" class="<?php echo $page === 'members' ? 'border-b-2 border-indigo-500' : 'border-b-2 border-transparent'; ?> text-gray-900 inline-flex items-center px-1 pt-1 text-sm font-medium">Members</a>
                        </div>
                    </div>
                    <div class="flex items-center">
                        <div class="hidden md:ml-4 md:flex-shrink-0 md:flex md:items-center">
                            <div class="relative" x-data="{ open: false }">
                                <div>
                                    <button @click="open = !open" class="flex text-sm rounded-full focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                        <img class="h-8 w-8 rounded-full" src="/assets/images/default-avatar.png" alt="">
                                    </button>
                                </div>
                                <div x-show="open" @click.away="open = false" class="origin-top-right absolute right-0 mt-2 w-48 rounded-md shadow-lg py-1 bg-white ring-1 ring-black ring-opacity-5" style="display: none;">
                                    <a href="?page=settings" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Settings</a>
                                    <a href="/login/logout.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Sign out</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </nav>

        <div class="fixed inset-0 flex z-40 md:hidden" x-show="sidebarOpen" x-description="Off-canvas menu for mobile, show/hide based on off-canvas menu state." x-transition:enter="transition-opacity ease-linear duration-300" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="transition-opacity ease-linear duration-300" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" style="display: none;">
            <div class="fixed inset-0 bg-gray-600 bg-opacity-75" @click="sidebarOpen = false"></div>
            
            <div class="relative flex-1 flex flex-col max-w-xs w-full bg-white">
                <div class="absolute top-0 right-0 -mr-12 pt-2">
                    <button @click="sidebarOpen = false" class="ml-1 flex items-center justify-center h-10 w-10 rounded-full focus:outline-none focus:ring-2 focus:ring-inset focus:ring-white">
                        <span class="sr-only">Close sidebar</span>
                        <svg class="h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>
                
                <div class="flex-1 h-0 pt-5 pb-4 overflow-y-auto">
                    <div class="flex-shrink-0 flex items-center px-4">
                        <img class="h-8" src="/assets/images/logo.png" alt="Family Hub Logo">
                        <span class="ml-2 text-xl font-semibold text-gray-900"><?php echo htmlspecialchars($family['family_name']); ?></span>
                    </div>
                    <nav class="mt-5 px-2 space-y-1">
                        <a href="?page=home" class="<?php echo $page === 'home' ? 'bg-gray-100 text-gray-900' : 'text-gray-600 hover:bg-gray-50 hover:text-gray-900'; ?> group flex items-center px-2 py-2 text-base font-medium rounded-md">Home</a>
                        <a href="?page=photos" class="<?php echo $page === 'photos' ? 'bg-gray-100 text-gray-900' : 'text-gray-600 hover:bg-gray-50 hover:text-gray-900'; ?> group flex items-center px-2 py-2 text-base font-medium rounded-md">Photos</a>
                        <a href="?page=calendar" class="<?php echo $page === 'calendar' ? 'bg-gray-100 text-gray-900' : 'text-gray-600 hover:bg-gray-50 hover:text-gray-900'; ?> group flex items-center px-2 py-2 text-base font-medium rounded-md">Calendar</a>
                        <a href="?page=members" class="<?php echo $page === 'members' ? 'bg-gray-100 text-gray-900' : 'text-gray-600 hover:bg-gray-50 hover:text-gray-900'; ?> group flex items-center px-2 py-2 text-base font-medium rounded-md">Members</a>
                        <a href="?page=settings" class="text-gray-600 hover:bg-gray-50 hover:text-gray-900 group flex items-center px-2 py-2 text-base font-medium rounded-md">Settings</a>
                        <a href="/login/logout.php" class="text-gray-600 hover:bg-gray-50 hover:text-gray-900 group flex items-center px-2 py-2 text-base font-medium rounded-md">Sign out</a>
                    </nav>
                </div>
            </div>
        </div>

        <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">