<?php
$page_title = 'Family Calendar';
$family_id = $_SESSION['family_id'];

$month = isset($_GET['month']) ? intval($_GET['month']) : date('n');
$year = isset($_GET['year']) ? intval($_GET['year']) : date('Y');

$timestamp = mktime(0, 0, 0, $month, 1, $year);
$days_in_month = date('t', $timestamp);
$first_day = date('w', $timestamp);
$prev_month = $month == 1 ? 12 : $month - 1;
$prev_year = $month == 1 ? $year - 1 : $year;
$next_month = $month == 12 ? 1 : $month + 1;
$next_year = $month == 12 ? $year + 1 : $year;

$stmt = $db->prepare("SELECT * FROM events WHERE family_id = ? AND MONTH(date) = ? AND YEAR(date) = ? ORDER BY date, time");
$stmt->execute([$family_id, $month, $year]);
$events = $stmt->fetchAll();

$events_by_day = [];
foreach ($events as $event) {
    $day = intval(date('j', strtotime($event['date'])));
    if (!isset($events_by_day[$day])) {
        $events_by_day[$day] = [];
    }
    $events_by_day[$day][] = $event;
}

$action = isset($_GET['action']) ? $_GET['action'] : '';

if ($action == 'add_event' && $_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $_POST['title'];
    $date = $_POST['date'];
    $time = $_POST['time'] ?: null;
    $description = $_POST['description'] ?: null;
    
    $stmt = $db->prepare("INSERT INTO events (family_id, title, date, time, description, created_by) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->execute([$family_id, $title, $date, $time, $description, $_SESSION['user_id']]);
    
    header("Location: ?page=calendar&month=$month&year=$year");
    exit;
}
?>

<div class="container mx-auto px-4">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Family Calendar</h1>
        <a href="?page=calendar&action=create" class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-lg transition">
            Add New Event
        </a>
    </div>
    
    <div class="bg-white shadow rounded-lg overflow-hidden mb-6">
        <div class="flex justify-between items-center p-4 border-b">
            <a href="?page=calendar&month=<?php echo $prev_month; ?>&year=<?php echo $prev_year; ?>" class="text-gray-600 hover:text-indigo-600 transition">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                </svg>
            </a>
            <h2 class="text-xl font-medium"><?php echo date('F Y', $timestamp); ?></h2>
            <a href="?page=calendar&month=<?php echo $next_month; ?>&year=<?php echo $next_year; ?>" class="text-gray-600 hover:text-indigo-600 transition">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                </svg>
            </a>
        </div>
        
        <div class="grid grid-cols-7 text-center border-b">
            <div class="py-2 border-r font-medium">Sun</div>
            <div class="py-2 border-r font-medium">Mon</div>
            <div class="py-2 border-r font-medium">Tue</div>
            <div class="py-2 border-r font-medium">Wed</div>
            <div class="py-2 border-r font-medium">Thu</div>
            <div class="py-2 border-r font-medium">Fri</div>
            <div class="py-2 font-medium">Sat</div>
        </div>
        
        <div class="grid grid-cols-7">
            <?php
            $day_count = 1;
            $blank_days = $first_day;
            
            for ($i = 0; $i < ($days_in_month + $blank_days); $i++) {
                if ($i < $blank_days) {
                    echo '<div class="min-h-[100px] p-2 border-r border-b bg-gray-50"></div>';
                } else {
                    $current_day = $day_count;
                    $is_today = ($day_count == date('j') && $month == date('n') && $year == date('Y'));
                    
                    echo '<div class="min-h-[100px] p-2 border-r border-b relative' . ($is_today ? ' bg-indigo-50' : '') . '">';
                    echo '<div class="text-right ' . ($is_today ? 'font-bold text-indigo-600' : '') . '">' . $day_count . '</div>';
                    
                    if (isset($events_by_day[$current_day])) {
                        echo '<div class="mt-1 space-y-1">';
                        foreach ($events_by_day[$current_day] as $event) {
                            $time_display = $event['time'] ? date('g:i A', strtotime($event['time'])) : '';
                            echo '<a href="?page=calendar&action=view&id=' . $event['id'] . '" class="block text-xs p-1 bg-indigo-100 text-indigo-800 rounded truncate" title="' . htmlspecialchars($event['title']) . '">';
                            echo ($time_display ? $time_display . ' - ' : '') . htmlspecialchars($event['title']);
                            echo '</a>';
                        }
                        echo '</div>';
                    }
                    
                    echo '</div>';
                    $day_count++;
                }
            }
            
            $remaining_cells = 7 - (($days_in_month + $blank_days) % 7);
            if ($remaining_cells < 7) {
                for ($i = 0; $i < $remaining_cells; $i++) {
                    echo '<div class="min-h-[100px] p-2 border-r border-b bg-gray-50"></div>';
                }
            }
            ?>
        </div>
    </div>
</div>

<?php if ($action == 'create'): ?>
<div class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
    <div class="bg-white rounded-lg w-full max-w-md p-6">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-xl font-medium">Add New Event</h3>
            <a href="?page=calendar&month=<?php echo $month; ?>&year=<?php echo $year; ?>" class="text-gray-400 hover:text-gray-500">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </a>
        </div>
        
        <form action="?page=calendar&action=add_event&month=<?php echo $month; ?>&year=<?php echo $year; ?>" method="post">
            <div class="mb-4">
                <label for="title" class="block text-sm font-medium text-gray-700 mb-1">Event Title</label>
                <input type="text" id="title" name="title" required class="w-full px-3 py-2 border border-gray-300 rounded-md">
            </div>
            
            <div class="mb-4">
                <label for="date" class="block text-sm font-medium text-gray-700 mb-1">Date</label>
                <input type="date" id="date" name="date" required class="w-full px-3 py-2 border border-gray-300 rounded-md" value="<?php echo date('Y-m-d', $timestamp); ?>">
            </div>
            
            <div class="mb-4">
                <label for="time" class="block text-sm font-medium text-gray-700 mb-1">Time (optional)</label>
                <input type="time" id="time" name="time" class="w-full px-3 py-2 border border-gray-300 rounded-md">
            </div>
            
            <div class="mb-4">
                <label for="description" class="block text-sm font-medium text-gray-700 mb-1">Description (optional)</label>
                <textarea id="description" name="description" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-md"></textarea>
            </div>
            
            <div class="flex justify-end">
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded-lg transition">Add Event</button>
            </div>
        </form>
    </div>
</div>
<?php endif; ?>