<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['merchant_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non connecté']);
    exit();
}

require_once '../config/db_comm.php';

$merchant_id = $_SESSION['merchant_id'];
$subject = trim($_POST['subject'] ?? '');
$message = trim($_POST['message'] ?? '');

if (empty($subject) || empty($message)) {
    echo json_encode(['success' => false, 'message' => 'Sujet et message requis']);
    exit();
}

try {
    $stmt = $pdo_comm->prepare("INSERT INTO communications (merchant_id, subject, message) VALUES (?, ?, ?)");
    $stmt->execute([$merchant_id, $subject, $message]);
    
    echo json_encode(['success' => true, 'message' => 'Message envoyé à notre équipe avec succès']);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur lors de l\'envoi du message']);
}
?>