<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['merchant_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non connecté']);
    exit();
}

require_once '../config/db.php';

$shop_ids = json_decode($_SESSION['shop_ids'], true);
if (!$shop_ids || empty($shop_ids)) {
    echo json_encode(['success' => false, 'message' => 'Aucun commerce associé']);
    exit();
}

$shop_id = $shop_ids[0];

try {
    $stmt = $pdo->prepare("SELECT * FROM shops WHERE id = ?");
    $stmt->execute([$shop_id]);
    $shop = $stmt->fetch();
    
    if ($shop) {
        echo json_encode(['success' => true, 'shop' => $shop]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Commerce non trouvé']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur serveur']);
}
?>