<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Animated</title>
    <link href="https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;500&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { font-family: 'Kanit', sans-serif; }

        .modal {
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .modal.active {
            opacity: 1;
            visibility: visible;
        }

        .preview-area {
            display: none;
        }

        .preview-area.active {
            display: block;
        }

        #imagePreview {
            max-width: 100%;
            max-height: 70vh;
            transition: all 0.3s ease;
        }

        .gradient-bg {
            animation: gradientAnimation 8s ease infinite;
            background-size: 200% 200%;
        }

        @keyframes gradientAnimation {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Zone Upload -->
    <div id="uploadArea" class="min-h-screen flex flex-col">
        <main class="flex-1 flex items-center justify-center p-4">
            <div class="w-full max-w-md bg-white rounded-xl shadow-sm p-8 text-center cursor-pointer hover:shadow-md transition-all">
                <input type="file" id="fileInput" class="hidden" accept="image/*">
                <div class="mb-4">
                    <svg class="w-12 h-12 mx-auto text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                </div>
                <p class="text-gray-600">Cliquez pour choisir une image</p>
                <p class="text-sm text-gray-400 mt-2">ou glissez-la ici</p>
            </div>
        </main>

        <footer class="border-t border-gray-200 bg-white">
            <div class="container mx-auto px-6 py-4">
                <h1 class="text-xl font-medium">Animated</h1>
                <p class="text-gray-500 text-sm">Transformez vos images</p>
            </div>
        </footer>
    </div>

    <!-- Zone Preview -->
    <div id="previewArea" class="preview-area fixed inset-0 bg-white">
        <div class="min-h-screen flex flex-col">
            <!-- Image Preview -->
            <main class="flex-1 relative flex items-center justify-center p-6">
                <div id="gradientBackground" class="absolute inset-0 opacity-50"></div>
                <img id="imagePreview" class="relative">
            </main>

            <!-- Controls -->
            <div class="bg-white border-t border-gray-200 p-6">
                <div class="max-w-4xl mx-auto flex items-center justify-between">
                    <div class="flex items-center gap-6">
                        <!-- Border Radius -->
                        <div>
                            <label class="block text-sm text-gray-600 mb-2">Coins arrondis</label>
                            <input type="range" id="radiusControl" min="0" max="50" value="0" 
                                   class="w-32 h-2 bg-gray-200 rounded-lg appearance-none cursor-pointer">
                        </div>

                        <!-- Border Width -->
                        <div>
                            <label class="block text-sm text-gray-600 mb-2">Épaisseur bordure</label>
                            <input type="range" id="borderControl" min="0" max="20" value="0"
                                   class="w-32 h-2 bg-gray-200 rounded-lg appearance-none cursor-pointer">
                        </div>

                        <!-- Animation Toggle -->
                        <div>
                            <label class="block text-sm text-gray-600 mb-2">Animation</label>
                            <button id="animationToggle" 
                                    class="w-12 h-6 bg-gray-200 rounded-full relative">
                                <span class="absolute left-1 top-1 w-4 h-4 bg-white rounded-full shadow transition-transform"></span>
                            </button>
                        </div>
                    </div>

                    <button id="downloadBtn" 
                            class="px-6 py-2 bg-black text-white rounded-lg hover:bg-gray-800 transition-colors">
                        Télécharger
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        const uploadArea = document.getElementById('uploadArea');
        const fileInput = document.getElementById('fileInput');
        const previewArea = document.getElementById('previewArea');
        const imagePreview = document.getElementById('imagePreview');
        const gradientBackground = document.getElementById('gradientBackground');
        const radiusControl = document.getElementById('radiusControl');
        const borderControl = document.getElementById('borderControl');
        const animationToggle = document.getElementById('animationToggle');
        const downloadBtn = document.getElementById('downloadBtn');

        // Upload handlers
        uploadArea.addEventListener('click', () => fileInput.click());

        uploadArea.addEventListener('dragover', (e) => {
            e.preventDefault();
            uploadArea.classList.add('ring-2', 'ring-blue-500');
        });

        uploadArea.addEventListener('dragleave', () => {
            uploadArea.classList.remove('ring-2', 'ring-blue-500');
        });

        uploadArea.addEventListener('drop', (e) => {
            e.preventDefault();
            uploadArea.classList.remove('ring-2', 'ring-blue-500');
            handleFile(e.dataTransfer.files[0]);
        });

        fileInput.addEventListener('change', () => {
            handleFile(fileInput.files[0]);
        });

        function handleFile(file) {
            if (file && file.type.startsWith('image/')) {
                const reader = new FileReader();
                reader.onload = (e) => {
                    imagePreview.src = e.target.result;
                    uploadArea.style.display = 'none';
                    previewArea.classList.add('active');
                    
                    // Set default gradient
                    gradientBackground.style.background = 'linear-gradient(45deg, #ff6b6b, #4ecdc4, #45b7d1)';
                };
                reader.readAsDataURL(file);
            }
        }

        // Controls
        radiusControl.addEventListener('input', (e) => {
            imagePreview.style.borderRadius = `${e.target.value}px`;
        });

        borderControl.addEventListener('input', (e) => {
            imagePreview.style.border = `${e.target.value}px solid black`;
        });

        let isAnimated = false;
        animationToggle.addEventListener('click', () => {
            isAnimated = !isAnimated;
            const thumb = animationToggle.querySelector('span');
            
            if (isAnimated) {
                thumb.style.transform = 'translateX(24px)';
                animationToggle.classList.add('bg-black');
                gradientBackground.classList.add('gradient-bg');
            } else {
                thumb.style.transform = 'translateX(0)';
                animationToggle.classList.remove('bg-black');
                gradientBackground.classList.remove('gradient-bg');
            }
        });

        downloadBtn.addEventListener('click', () => {
            const link = document.createElement('a');
            link.download = 'animated-image.png';
            link.href = imagePreview.src;
            link.click();
        });
    </script>
</body>
</html>