<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Why AndWeare? | AndWeare</title>
    <link rel="icon" type="image/png" href="logo.png">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+KR:wght@300;400;500;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Noto Sans KR', sans-serif;
            background-color: #ffffff;
            overflow-x: hidden;
        }
        
        .content-container {
            position: relative;
            z-index: 10;
            max-width: 800px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .word {
            display: inline-block;
            opacity: 0;
            filter: blur(10px);
            transform: translateY(10px);
            margin-right: 8px;
            margin-bottom: 5px;
        }
        
        .title-word {
            display: inline-block;
            opacity: 0;
            filter: blur(10px);
            transform: translateY(20px);
            margin-right: 15px;
            margin-bottom: 10px;
        }
        
        .animate-button {
            opacity: 0;
            filter: blur(5px);
            transform: translateY(10px);
            transition: opacity 0.5s ease, filter 0.5s ease, transform 0.5s ease;
        }
        
        .animate-button.visible {
            opacity: 1;
            filter: blur(0);
            transform: translateY(0);
            transition-delay: 4s;
        }
    </style>
</head>
<body class="min-h-screen flex flex-col">
    <?php include 'header.php'; ?>
    
    <main class="flex-grow pt-32">
        <div class="content-container">
            <h1 class="text-4xl md:text-5xl font-bold mb-10 text-center" id="title-container">
                <!-- Le titre sera inséré ici par JavaScript -->
            </h1>
            
            <div class="text-lg text-gray-700 leading-relaxed mb-12" id="text-container">
                <!-- Le texte sera inséré ici par JavaScript -->
            </div>
            
            <div class="text-center mt-12">
                <a href="/hub" class="animate-button inline-block px-8 py-4 bg-black text-white rounded-full hover:bg-gray-800 transition-colors text-center text-lg">
                    Get Started
                </a>
            </div>
        </div>
    </main>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const titleText = "Why?";
            const mainText = "AndWeare was born from an analysis of today’s world: many are not necessarily in contact with their family every day. And it’s a mistake. To remedy this we present a product that brings together everything to set up a family hub for anyone, and leave Whatsapp the duty to be dedicated to the conversation (because yes, family groups are created there). It is crucial for us that our application becomes a place where the daily passage is frequent.";
            
            const titleContainer = document.getElementById('title-container');
            const textContainer = document.getElementById('text-container');
            
            // Fonction pour ajouter un délai aléatoire dans une plage
            function randomDelay(min, max) {
                return Math.random() * (max - min) + min;
            }
            
            // Créer les éléments du titre
            titleText.split(' ').forEach((word, index) => {
                const wordSpan = document.createElement('span');
                wordSpan.textContent = word;
                wordSpan.classList.add('title-word');
                titleContainer.appendChild(wordSpan);
                
                // Animation pour chaque mot du titre
                setTimeout(() => {
                    wordSpan.style.transition = 'opacity 0.5s ease, filter 0.5s ease, transform 0.5s ease';
                    wordSpan.style.opacity = '1';
                    wordSpan.style.filter = 'blur(0)';
                    wordSpan.style.transform = 'translateY(0)';
                }, 300 + index * 150);
            });
            
            // Créer les éléments du texte principal
            mainText.split(' ').forEach((word, index) => {
                const wordSpan = document.createElement('span');
                wordSpan.textContent = word;
                wordSpan.classList.add('word');
                textContainer.appendChild(wordSpan);
                
                // Animation pour chaque mot avec un délai croissant
                setTimeout(() => {
                    wordSpan.style.transition = 'opacity 0.4s ease, filter 0.4s ease, transform 0.4s ease';
                    wordSpan.style.opacity = '1';
                    wordSpan.style.filter = 'blur(0)';
                    wordSpan.style.transform = 'translateY(0)';
                }, 1500 + index * 40);  // Délai plus court pour que le texte apparaisse plus vite
            });
            
            // Animation du bouton
            setTimeout(function() {
                document.querySelector('.animate-button').classList.add('visible');
            }, 1000);
        });
    </script>
</body>
</html>