<div class="bg-white shadow rounded-lg p-6 mb-6">
    <h1 class="text-2xl font-bold mb-4"><?php echo htmlspecialchars($family['family_name']); ?> Family Hub</h1>
    <p class="text-gray-600 mb-4">Welcome to your family's private space. Share photos, track important dates, and stay connected with your loved ones.</p>
</div>

<div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
    <div class="bg-white shadow rounded-lg p-6">
        <h2 class="text-xl font-bold mb-4 flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2 text-indigo-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
            </svg>
            Upcoming Events
        </h2>
        <div class="divide-y divide-gray-200">
            <?php
            $stmt = $db->prepare("SELECT * FROM events WHERE family_id = ? AND date >= CURDATE() ORDER BY date LIMIT 5");
            $stmt->execute([$family_id]);
            $events = $stmt->fetchAll();
            
            if (count($events) > 0) {
                foreach ($events as $event) {
                    echo '<div class="py-3">';
                    echo '<div class="flex justify-between">';
                    echo '<div class="font-medium">' . htmlspecialchars($event['title']) . '</div>';
                    echo '<div class="text-sm text-gray-500">' . date('M j, Y', strtotime($event['date'])) . '</div>';
                    echo '</div>';
                    if (!empty($event['description'])) {
                        echo '<div class="text-sm text-gray-600 mt-1">' . htmlspecialchars($event['description']) . '</div>';
                    }
                    echo '</div>';
                }
            } else {
                echo '<p class="py-3 text-gray-500">No upcoming events. <a href="?page=calendar" class="text-indigo-500 hover:underline">Add one</a>?</p>';
            }
            ?>
        </div>
        <div class="mt-4">
            <a href="?page=calendar" class="text-indigo-600 hover:text-indigo-800 text-sm font-medium">View all events →</a>
        </div>
    </div>
    
    <div class="bg-white shadow rounded-lg p-6">
        <h2 class="text-xl font-bold mb-4 flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2 text-indigo-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
            </svg>
            Recent Photos
        </h2>
        <div class="grid grid-cols-3 gap-2">
            <?php
            $stmt = $db->prepare("SELECT * FROM photos WHERE family_id = ? ORDER BY uploaded_at DESC LIMIT 6");
            $stmt->execute([$family_id]);
            $photos = $stmt->fetchAll();
            
            if (count($photos) > 0) {
                foreach ($photos as $photo) {
                    echo '<a href="?page=photos&photo=' . $photo['id'] . '" class="aspect-square rounded overflow-hidden">';
                    echo '<img src="' . htmlspecialchars($cdn_url . '/' . $photo['file_path']) . '" alt="' . htmlspecialchars($photo['title']) . '" class="w-full h-full object-cover hover:opacity-90 transition">';
                    echo '</a>';
                }
            } else {
                echo '<div class="col-span-3 text-gray-500 py-3">No photos yet. <a href="?page=photos" class="text-indigo-500 hover:underline">Upload some</a>?</div>';
            }
            ?>
        </div>
        <div class="mt-4">
            <a href="?page=photos" class="text-indigo-600 hover:text-indigo-800 text-sm font-medium">View all photos →</a>
        </div>
    </div>
</div>

<div class="bg-white shadow rounded-lg p-6">
    <h2 class="text-xl font-bold mb-4 flex items-center">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2 text-indigo-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
        </svg>
        Family Members
    </h2>
    <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
        <?php foreach ($members as $member): ?>
            <div class="text-center">
                <div class="inline-block rounded-full overflow-hidden h-16 w-16 mb-2">
                    <img src="/assets/images/default-avatar.png" alt="<?php echo htmlspecialchars($member['username']); ?>" class="h-full w-full object-cover">
                </div>
                <div class="font-medium"><?php echo htmlspecialchars($member['username']); ?></div>
                <div class="text-sm text-gray-500"><?php echo ucfirst(htmlspecialchars($member['role'])); ?></div>
            </div>
        <?php endforeach; ?>
        
        <?php if ($is_admin): ?>
            <a href="?page=members&action=invite" class="flex flex-col items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg hover:border-gray-400 transition">
                <div class="h-16 w-16 rounded-full flex items-center justify-center bg-gray-100 text-gray-400 mb-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                    </svg>
                </div>
                <span class="text-sm font-medium text-indigo-600">Invite Member</span>
            </a>
        <?php endif; ?>
    </div>
</div>