<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="logo_new.png">
    <title>Admin - Vert Chasseur</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            background-color: #ffffff;
        }
        .dark body {
            background-color: #000000;
        }
        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
        }
        .tab-active {
            @apply border-b-2 border-stone-900 dark:border-white;
        }
        .tab-inactive {
            @apply border-b-2 border-transparent text-stone-500 dark:text-stone-400;
        }
    </style>
</head>
<body class="transition-colors duration-300">
<?php 
include 'db.php';

$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action']) && $_POST['action'] === 'create') {
        $title = $conn->real_escape_string($_POST['title']);
        $description = $conn->real_escape_string($_POST['description']);
        $category = $conn->real_escape_string($_POST['category']);
        $status = $conn->real_escape_string($_POST['status']);
        $budget = floatval($_POST['budget_estimated']);
        $date_planned = $conn->real_escape_string($_POST['date_planned']);
        
        $sql = "INSERT INTO projects (title, description, category, status, budget_estimated, date_planned, approval_count, rejection_count) 
                VALUES ('$title', '$description', '$category', '$status', $budget, '$date_planned', 0, 0)";
        
        if ($conn->query($sql)) {
            $message = 'Projet créé avec succès !';
            $message_type = 'success';
        } else {
            $message = 'Erreur lors de la création : ' . $conn->error;
            $message_type = 'error';
        }
    } elseif (isset($_POST['action']) && $_POST['action'] === 'update') {
        $id = intval($_POST['project_id']);
        $title = $conn->real_escape_string($_POST['title']);
        $description = $conn->real_escape_string($_POST['description']);
        $category = $conn->real_escape_string($_POST['category']);
        $status = $conn->real_escape_string($_POST['status']);
        $budget = floatval($_POST['budget_estimated']);
        $date_planned = $conn->real_escape_string($_POST['date_planned']);
        
        $sql = "UPDATE projects SET title='$title', description='$description', category='$category', status='$status', budget_estimated=$budget, date_planned='$date_planned' WHERE id=$id";
        
        if ($conn->query($sql)) {
            $message = 'Projet mis à jour avec succès !';
            $message_type = 'success';
        } else {
            $message = 'Erreur lors de la mise à jour : ' . $conn->error;
            $message_type = 'error';
        }
    } elseif (isset($_POST['action']) && $_POST['action'] === 'delete') {
        $id = intval($_POST['project_id']);
        $sql = "DELETE FROM projects WHERE id=$id";
        
        if ($conn->query($sql)) {
            $message = 'Projet supprimé avec succès !';
            $message_type = 'success';
        } else {
            $message = 'Erreur lors de la suppression : ' . $conn->error;
            $message_type = 'error';
        }
    }
}

$result = $conn->query("SELECT * FROM projects ORDER BY created_at DESC");
$projects = $result->fetch_all(MYSQLI_ASSOC);

$edit_project = null;
if (isset($_GET['edit'])) {
    $edit_id = intval($_GET['edit']);
    $edit_result = $conn->query("SELECT * FROM projects WHERE id=$edit_id");
    $edit_project = $edit_result->fetch_assoc();
}

$conn->close();
?>

<script>
    if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
        document.documentElement.classList.add('dark');
    }
    window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
        if (e.matches) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    });
</script>

<main class="min-h-screen px-8 md:px-16 py-16 max-w-7xl mx-auto">
    <div class="mb-12">
        <h1 class="text-4xl md:text-5xl font-light mb-2 text-stone-800 dark:text-white">Admin <span class="txt-chasseur font-normal">Vert Chasseur</span></h1>
        <p class="text-stone-600 dark:text-stone-400">Gère les projets et idées du quartier</p>
    </div>

    <?php if ($message): ?>
    <div class="mb-6 p-4 rounded-lg <?php echo $message_type === 'success' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200'; ?>">
        <?php echo htmlspecialchars($message); ?>
    </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <div class="lg:col-span-1">
            <div class="bg-white dark:bg-stone-900 border border-stone-200 dark:border-stone-800 rounded-xl p-8">
                <h2 class="text-2xl font-medium mb-6 text-stone-900 dark:text-white">
                    <?php echo $edit_project ? 'Modifier le projet' : 'Créer un projet'; ?>
                </h2>
                
                <form method="POST" class="space-y-4">
                    <input type="hidden" name="action" value="<?php echo $edit_project ? 'update' : 'create'; ?>">
                    <?php if ($edit_project): ?>
                    <input type="hidden" name="project_id" value="<?php echo $edit_project['id']; ?>">
                    <?php endif; ?>
                    
                    <div>
                        <label class="block text-xs text-stone-600 dark:text-stone-400 uppercase tracking-widest mb-2">Titre</label>
                        <input type="text" name="title" required value="<?php echo $edit_project ? htmlspecialchars($edit_project['title']) : ''; ?>" class="w-full px-4 py-2 border border-stone-200 dark:border-stone-800 rounded-lg bg-white dark:bg-stone-800 text-stone-900 dark:text-white">
                    </div>

                    <div>
                        <label class="block text-xs text-stone-600 dark:text-stone-400 uppercase tracking-widest mb-2">Description</label>
                        <textarea name="description" required rows="4" class="w-full px-4 py-2 border border-stone-200 dark:border-stone-800 rounded-lg bg-white dark:bg-stone-800 text-stone-900 dark:text-white"><?php echo $edit_project ? htmlspecialchars($edit_project['description']) : ''; ?></textarea>
                    </div>

                    <div>
                        <label class="block text-xs text-stone-600 dark:text-stone-400 uppercase tracking-widest mb-2">Catégorie</label>
                        <select name="category" required class="w-full px-4 py-2 border border-stone-200 dark:border-stone-800 rounded-lg bg-white dark:bg-stone-800 text-stone-900 dark:text-white">
                            <option value="">Sélectionne une catégorie</option>
                            <option value="Communication" <?php echo $edit_project && $edit_project['category'] === 'Communication' ? 'selected' : ''; ?>>Communication</option>
                            <option value="Infrastructure" <?php echo $edit_project && $edit_project['category'] === 'Infrastructure' ? 'selected' : ''; ?>>Infrastructure</option>
                            <option value="Aménagement" <?php echo $edit_project && $edit_project['category'] === 'Aménagement' ? 'selected' : ''; ?>>Aménagement</option>
                            <option value="Événements" <?php echo $edit_project && $edit_project['category'] === 'Événements' ? 'selected' : ''; ?>>Événements</option>
                            <option value="Environnement" <?php echo $edit_project && $edit_project['category'] === 'Environnement' ? 'selected' : ''; ?>>Environnement</option>
                            <option value="Technologie" <?php echo $edit_project && $edit_project['category'] === 'Technologie' ? 'selected' : ''; ?>>Technologie</option>
                            <option value="Culture" <?php echo $edit_project && $edit_project['category'] === 'Culture' ? 'selected' : ''; ?>>Culture</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-xs text-stone-600 dark:text-stone-400 uppercase tracking-widest mb-2">Statut</label>
                        <select name="status" required class="w-full px-4 py-2 border border-stone-200 dark:border-stone-800 rounded-lg bg-white dark:bg-stone-800 text-stone-900 dark:text-white">
                            <option value="pending" <?php echo $edit_project && $edit_project['status'] === 'pending' ? 'selected' : ''; ?>>En attente</option>
                            <option value="approved" <?php echo $edit_project && $edit_project['status'] === 'approved' ? 'selected' : ''; ?>>Approuvé</option>
                            <option value="in_progress" <?php echo $edit_project && $edit_project['status'] === 'in_progress' ? 'selected' : ''; ?>>En cours</option>
                            <option value="rejected" <?php echo $edit_project && $edit_project['status'] === 'rejected' ? 'selected' : ''; ?>>Rejeté</option>
                            <option value="completed" <?php echo $edit_project && $edit_project['status'] === 'completed' ? 'selected' : ''; ?>>Complété</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-xs text-stone-600 dark:text-stone-400 uppercase tracking-widest mb-2">Budget estimé (€)</label>
                        <input type="number" name="budget_estimated" step="0.01" value="<?php echo $edit_project ? htmlspecialchars($edit_project['budget_estimated']) : ''; ?>" class="w-full px-4 py-2 border border-stone-200 dark:border-stone-800 rounded-lg bg-white dark:bg-stone-800 text-stone-900 dark:text-white">
                    </div>

                    <div>
                        <label class="block text-xs text-stone-600 dark:text-stone-400 uppercase tracking-widest mb-2">Date prévue</label>
                        <input type="date" name="date_planned" required value="<?php echo $edit_project ? htmlspecialchars($edit_project['date_planned']) : ''; ?>" class="w-full px-4 py-2 border border-stone-200 dark:border-stone-800 rounded-lg bg-white dark:bg-stone-800 text-stone-900 dark:text-white">
                    </div>

                    <button type="submit" class="w-full px-4 py-3 bg-stone-900 dark:bg-white text-white dark:text-stone-900 rounded-lg font-medium hover:bg-stone-800 dark:hover:bg-stone-100 transition-colors">
                        <?php echo $edit_project ? 'Mettre à jour' : 'Créer'; ?>
                    </button>

                    <?php if ($edit_project): ?>
                    <a href="admin.php" class="block w-full px-4 py-3 bg-stone-200 dark:bg-stone-800 text-stone-900 dark:text-white rounded-lg font-medium text-center hover:bg-stone-300 dark:hover:bg-stone-700 transition-colors">
                        Annuler
                    </a>
                    <?php endif; ?>
                </form>
            </div>
        </div>

        <div class="lg:col-span-2">
            <div class="bg-white dark:bg-stone-900 border border-stone-200 dark:border-stone-800 rounded-xl p-8">
                <h2 class="text-2xl font-medium mb-6 text-stone-900 dark:text-white">Tous les projets</h2>
                
                <div class="space-y-4 max-h-96 overflow-y-auto">
                    <?php foreach ($projects as $project): ?>
                    <div class="border border-stone-200 dark:border-stone-800 rounded-lg p-4 flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                        <div class="flex-1 min-w-0">
                            <h3 class="font-medium text-stone-900 dark:text-white truncate">
                                <?php echo htmlspecialchars($project['title']); ?>
                            </h3>
                            <div class="flex gap-2 mt-2 flex-wrap">
                                <span class="text-xs px-2 py-1 bg-stone-100 dark:bg-stone-800 rounded text-stone-700 dark:text-stone-300">
                                    <?php echo htmlspecialchars($project['category']); ?>
                                </span>
                                <span class="text-xs px-2 py-1 bg-stone-100 dark:bg-stone-800 rounded text-stone-700 dark:text-stone-300">
                                    <?php 
                                        $status_labels = [
                                            'pending' => 'En attente',
                                            'approved' => 'Approuvé',
                                            'rejected' => 'Rejeté',
                                            'in_progress' => 'En cours',
                                            'completed' => 'Complété'
                                        ];
                                        echo $status_labels[$project['status']];
                                    ?>
                                </span>
                            </div>
                        </div>
                        <div class="flex gap-2">
                            <a href="admin.php?edit=<?php echo $project['id']; ?>" class="px-4 py-2 bg-blue-500 hover:bg-blue-600 text-white rounded-lg text-sm font-medium transition-colors">
                                <i class="fas fa-edit mr-1"></i>Modifier
                            </a>
                            <form method="POST" class="inline" onsubmit="return confirm('Es-tu sûr de vouloir supprimer ce projet ?');">
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="project_id" value="<?php echo $project['id']; ?>">
                                <button type="submit" class="px-4 py-2 bg-red-500 hover:bg-red-600 text-white rounded-lg text-sm font-medium transition-colors">
                                    <i class="fas fa-trash mr-1"></i>Supprimer
                                </button>
                            </form>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>

</main>

</body>
</html>