<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    function clean_input($data) {
        $data = trim($data);
        $data = stripslashes($data);
        $data = htmlspecialchars($data);
        return $data;
    }

    $nom = clean_input($_POST['nom']);
    $prenom = clean_input($_POST['prenom']);
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    $password = $_POST['password'];
    $dateNaissance = clean_input($_POST['dateNaissanceJour']) . '/' . clean_input($_POST['dateNaissanceMois']) . '/' . clean_input($_POST['dateNaissanceAnnee']);
    $matiere = clean_input($_POST['matiere']);
    $adresse = clean_input($_POST['adresse']);
    $userAddress = clean_input($_POST['userAddress']);

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        die("Invalid email format");
    }

    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    $email_content = "New teacher registration in Academ:\n\n";
    $email_content .= "Name: $nom\n";
    $email_content .= "First name: $prenom\n";
    $email_content .= "Email: $email\n";
    $email_content .= "Address of establishment: $password\n";
    $email_content .= "Date of birth: $dateNaissance\n";
    $email_content .= "Subjects taught: $matiere\n";
    $email_content .= "Address: $userAddress\n";
    $email_content .= "Address of establishment: $adresse\n";

    $uploadDir = 'uploads/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $attachments = [];
    $fileFields = ['carteRecto', 'carteVerso', 'diplome'];
    $allowedExtensions = ['jpg', 'jpeg', 'png', 'pdf'];
    $maxFileSize = 5 * 1024 * 1024;

    foreach ($fileFields as $field) {
        if (isset($_FILES[$field]) && $_FILES[$field]['error'] == 0) {
            $tmpName = $_FILES[$field]['tmp_name'];
            $fileName = basename($_FILES[$field]['name']);
            $fileSize = $_FILES[$field]['size'];
            $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

            if (!in_array($fileExt, $allowedExtensions)) {
                die("Unauthorized file type for $field.");
            }
            if ($fileSize > $maxFileSize) {
                die("File $field is too large.");
            }

            $newFileName = uniqid() . ".$fileExt";
            $destination = $uploadDir . $newFileName;

            if (move_uploaded_file($tmpName, $destination)) {
                $attachments[] = $destination;
                $email_content .= ucfirst($field) . ": $newFileName\n";
            } else {
                die("Error uploading file $field.");
            }
        }
    }

    function send_email($to, $subject, $message, $attachments = [], $isHTML = false) {
        $boundary = md5(time());
        
           $headers = "MIME-Version: 1.0" . "\r\n";
           $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
           $headers .= 'From: Academ <no-reply@imators.com>' . "\r\n";


        $body = "--$boundary\r\n";
        $body .= "Content-Type: text/" . ($isHTML ? "html" : "plain") . "; charset=\"UTF-8\"\r\n";
        $body .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
        $body .= $message . "\r\n";

        foreach ($attachments as $file) {
            if (file_exists($file)) {
                $content = file_get_contents($file);
                $content = chunk_split(base64_encode($content));
                $body .= "--$boundary\r\n";
                $body .= "Content-Type: application/octet-stream; name=\"".basename($file)."\"\r\n";
                $body .= "Content-Transfer-Encoding: base64\r\n";
                $body .= "Content-Disposition: attachment\r\n\r\n";
                $body .= $content . "\r\n";
            }
        }

        $body .= "--$boundary--";

        return mail($to, $subject, $body, $headers);
    }

    $to_management = 'management@imators.com';
    $subject_management = 'Academ | About a new Teacher';
    $mailSentManagement = send_email($to_management, $subject_management, $email_content, $attachments);

    $to_user = $email;
    $subject_user = 'Welcome to Academ!';
    $message_user = '
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Welcome to Academ</title>
        <style>
            .container { max-width: 600px; margin: 20px auto; background-color: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 0 20px rgba(0,0,0,0.1); }
            .header { background-color: #6B46C1; color: #fff; padding: 30px 20px; text-align: center; }
            .logo { max-width: 120px; margin-bottom: 15px; }
            .content { padding: 30px; }
            .button { display: inline-block; background-color: #6B46C1; color: #fff; padding: 12px 24px; text-decoration: none; border-radius: 5px; font-weight: bold; transition: background-color 0.3s ease; }
            .button:hover { background-color: #5a3aa8; }
            .footer { text-align: center; padding: 20px; background-color: #f9f9f9; font-size: 0.9em; color: #666; }
            h1 { margin: 0; font-size: 28px; }
            ul { padding-left: 20px; }
            .info-box { background-color: #e8e4f3; border-left: 4px solid #6B46C1; padding: 15px; margin: 20px 0; border-radius: 4px; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <img src="https://cdn.imators.com/Academ.png" alt="Academ Logo" class="logo">
                <h1>Welcome to Academ!</h1>
            </div>
            <div class="content">
                <p>Dear ' . htmlspecialchars($prenom) . ' ' . htmlspecialchars($nom) . ',</p>
                <p>We\'re thrilled to have you join Academ as a teacher! Your journey to inspiring and educating students begins here.</p>
                <p>Here\'s a quick overview of your registration:</p>
                <ul>
                    <li><strong>Name:</strong> ' . htmlspecialchars($prenom) . ' ' . htmlspecialchars($nom) . '</li>
                    <li><strong>Email:</strong> ' . htmlspecialchars($email) . '</li>
                    <li><strong>Courses you will teach:</strong> ' . htmlspecialchars($matiere) . '</li>
                    <li><strong>School Address:</strong> ' . htmlspecialchars($adresse) . '</li>
                </ul>
                <div class="info-box">
                    <p><strong>Important Information:</strong></p>
                    <ul>
                        <li>Your account will be activated within the next 24 hours.</li>
                        <li>You\'ll receive a confirmation email once your account is active.</li>
                        <li>In the meantime, feel free to gather any materials or ideas you\'d like to share on your profile.</li>
                    </ul>
                </div>
                <p>Once your account is active, you can start setting up your profile and exploring all that Academ has to offer.</p>
                <p>If you have any questions or need assistance, our support team is here to help. Just reply to this email, and we\'ll get back to you promptly.</p>
                <p>Welcome aboard!<br>The Academ Team</p>
            </div>
            <div class="footer">
                <p> 2024 Academ, by Imators LLC. All rights reserved. | <a href="https://imators.com/privacy" style="color: #6B46C1;">Privacy Policy</a> | <a href="https://imators.com/terms-of-use" style="color: #6B46C1;">Terms of Service</a></p>
            </div>
        </div>
    </body>
    </html>
    ';

    $mailSentUser = send_email($to_user, $subject_user, $message_user, [], true);

    foreach ($attachments as $file) {
        if (file_exists($file)) {
            unlink($file);
        }
    }

    if ($mailSentManagement && $mailSentUser) {
        header("Location: /success");
        exit();
    } else {
        header("Location: /?error=email_send_failed");
        exit();
    }
} else {
    header("Location: /");
    exit();
}
?>