<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>ISE Engine - Workspace</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v6.4.0/css/all.css">
</head>
<body class="bg-gray-50 min-h-screen">
    <header class="bg-white shadow-sm border-b">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center py-4">
                <div class="flex items-center space-x-4">
                    <h1 class="text-2xl font-bold text-gray-900">ISE Engine</h1>
                    <span class="text-sm text-gray-500">Workspace</span>
                </div>
                <div class="flex items-center space-x-6">
                    <div class="flex items-center space-x-2">
                        <div class="w-8 h-8 bg-blue-500 rounded-full flex items-center justify-center">
                            <span class="text-white text-sm font-medium">
                                {{ strtoupper(substr(session('username'), 0, 1)) }}
                            </span>
                        </div>
                        <span class="text-gray-700 font-medium">{{ session('username') }}</span>
                    </div>
                    <a href="/logout" class="text-red-500 hover:text-red-700 transition-colors">
                        <i class="fas fa-sign-out-alt"></i> Déconnexion
                    </a>
                </div>
            </div>
        </div>
    </header>

    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <div class="mb-8">
            <h2 class="text-3xl font-bold text-gray-900 mb-2">Bienvenue {{ session('username') }}</h2>
            <p class="text-gray-600">Accédez à tous vos outils ISE Engine depuis ce workspace.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
            <div class="bg-white rounded-lg shadow-sm border hover:shadow-md transition-shadow p-6">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-search text-blue-600 text-xl"></i>
                    </div>
                    <h3 class="ml-4 text-lg font-semibold text-gray-900">Search Engine</h3>
                </div>
                <p class="text-gray-600 mb-4">Moteur de recherche intelligent et personnalisé.</p>
                <button class="w-full bg-blue-600 text-white py-2 px-4 rounded-lg hover:bg-blue-700 transition-colors">
                    Accéder
                </button>
            </div>

            <div class="bg-white rounded-lg shadow-sm border hover:shadow-md transition-shadow p-6">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-chart-line text-green-600 text-xl"></i>
                    </div>
                    <h3 class="ml-4 text-lg font-semibold text-gray-900">Analytics</h3>
                </div>
                <p class="text-gray-600 mb-4">Statistiques et analyses détaillées.</p>
                <button class="w-full bg-green-600 text-white py-2 px-4 rounded-lg hover:bg-green-700 transition-colors">
                    Voir les stats
                </button>
            </div>

            <div class="bg-white rounded-lg shadow-sm border hover:shadow-md transition-shadow p-6">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-cogs text-purple-600 text-xl"></i>
                    </div>
                    <h3 class="ml-4 text-lg font-semibold text-gray-900">Configuration</h3>
                </div>
                <p class="text-gray-600 mb-4">Paramètres et configuration du système.</p>
                <button class="w-full bg-purple-600 text-white py-2 px-4 rounded-lg hover:bg-purple-700 transition-colors">
                    Configurer
                </button>
            </div>

            <div class="bg-white rounded-lg shadow-sm border hover:shadow-md transition-shadow p-6">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-yellow-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-database text-yellow-600 text-xl"></i>
                    </div>
                    <h3 class="ml-4 text-lg font-semibold text-gray-900">Data Manager</h3>
                </div>
                <p class="text-gray-600 mb-4">Gestion et organisation des données.</p>
                <button class="w-full bg-yellow-600 text-white py-2 px-4 rounded-lg hover:bg-yellow-700 transition-colors">
                    Gérer
                </button>
            </div>

            <div class="bg-white rounded-lg shadow-sm border hover:shadow-md transition-shadow p-6">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-shield-alt text-red-600 text-xl"></i>
                    </div>
                    <h3 class="ml-4 text-lg font-semibold text-gray-900">Security</h3>
                </div>
                <p class="text-gray-600 mb-4">Sécurité et contrôle d'accès.</p>
                <button class="w-full bg-red-600 text-white py-2 px-4 rounded-lg hover:bg-red-700 transition-colors">
                    Sécuriser
                </button>
            </div>

            <div class="bg-white rounded-lg shadow-sm border hover:shadow-md transition-shadow p-6">
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-indigo-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-users text-indigo-600 text-xl"></i>
                    </div>
                    <h3 class="ml-4 text-lg font-semibold text-gray-900">Team</h3>
                </div>
                <p class="text-gray-600 mb-4">Gestion d'équipe et collaboration.</p>
                <button class="w-full bg-indigo-600 text-white py-2 px-4 rounded-lg hover:bg-indigo-700 transition-colors">
                    Collaborer
                </button>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-sm border p-6">
            <h3 class="text-xl font-semibold text-gray-900 mb-4">Activité récente</h3>
            <div class="space-y-4">
                <div class="flex items-center justify-between py-3 border-b border-gray-100">
                    <div class="flex items-center space-x-3">
                        <div class="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-search text-blue-600 text-sm"></i>
                        </div>
                        <div>
                            <p class="font-medium text-gray-900">Nouvelle recherche effectuée</p>
                            <p class="text-sm text-gray-500">Il y a 2 minutes</p>
                        </div>
                    </div>
                </div>
                <div class="flex items-center justify-between py-3 border-b border-gray-100">
                    <div class="flex items-center space-x-3">
                        <div class="w-8 h-8 bg-green-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-check text-green-600 text-sm"></i>
                        </div>
                        <div>
                            <p class="font-medium text-gray-900">Connexion sécurisée établie</p>
                            <p class="text-sm text-gray-500">Il y a 5 minutes</p>
                        </div>
                    </div>
                </div>
                <div class="flex items-center justify-between py-3">
                    <div class="flex items-center space-x-3">
                        <div class="w-8 h-8 bg-purple-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-cog text-purple-600 text-sm"></i>
                        </div>
                        <div>
                            <p class="font-medium text-gray-900">Configuration mise à jour</p>
                            <p class="text-sm text-gray-500">Il y a 1 heure</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</body>
</html>