<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mix Header</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Space Grotesk', sans-serif;
        }
        @keyframes slideRight {
            from { transform: translateX(0); }
            to { transform: translateX(5px); }
        }
        .hover-slide:hover {
            animation: slideRight 0.3s forwards;
        }
        .menu-open {
            overflow: hidden;
        }
        .hamburger-icon {
            width: 30px;
            height: 20px;
            position: relative;
            transform: rotate(0deg);
            transition: .5s ease-in-out;
            cursor: pointer;
        }
        .hamburger-icon span {
            display: block;
            position: absolute;
            height: 2px;
            width: 100%;
            background: white;
            border-radius: 9px;
            opacity: 1;
            left: 0;
            transform: rotate(0deg);
            transition: .25s ease-in-out;
        }
        .hamburger-icon span:nth-child(1) {
            top: 0px;
        }
        .hamburger-icon span:nth-child(2) {
            top: 18px;
        }
        .hamburger-icon.active span:nth-child(1) {
            top: 9px;
            transform: rotate(135deg);
        }
        .hamburger-icon.active span:nth-child(2) {
            top: 9px;
            transform: rotate(-135deg);
        }
    </style>
</head>
<body class="flex flex-col min-h-screen bg-black text-gray-400">
    <header id="header" class="fixed w-full transition-all duration-300 ease-in-out z-50">
        <div class="container mx-auto px-4 py-4 flex justify-between items-center">
                    <a href="/">
            <img src="logo_mix.png" alt="Élégance Logo" class="h-16 mr-12">
        </a>
            <button id="menuToggle" class="z-50 focus:outline-none hamburger-icon">
                <span></span>
                <span></span>
            </button>
        </div>
    </header>

    <div id="menu" class="fixed inset-0 bg-black bg-opacity-95 z-40 hidden transition-all duration-500">
        <div class="h-full flex flex-col justify-center items-start pl-16 space-y-8">
            <a href="#" class="text-white text-2xl hover-slide transition-all duration-300">Home</a>
            <a href="#" class="text-white text-2xl hover-slide transition-all duration-300">About</a>
            <a href="#" class="text-white text-2xl hover-slide transition-all duration-300">Services</a>
            <a href="#" class="text-white text-2xl hover-slide transition-all duration-300">Contact</a>
        </div>
    </div>

    <script>
        const header = document.getElementById('header');
        const menuToggle = document.getElementById('menuToggle');
        const menu = document.getElementById('menu');

        window.addEventListener('scroll', () => {
            if (window.scrollY > 0) {
                header.classList.add('bg-white', 'shadow-md');
                menuToggle.querySelectorAll('span').forEach(span => span.style.background = 'black');
            } else {
                header.classList.remove('bg-white', 'shadow-md');
                menuToggle.querySelectorAll('span').forEach(span => span.style.background = 'white');
            }
        });

        function toggleMenu() {
            menu.classList.toggle('hidden');
            document.body.classList.toggle('menu-open');
            menuToggle.classList.toggle('active');
            if (!menu.classList.contains('hidden')) {
                menu.style.opacity = '0';
                setTimeout(() => {
                    menu.style.opacity = '1';
                }, 50);
            }
        }

        menuToggle.addEventListener('click', toggleMenu);

        // Ajout de l'animation pour les liens du menu
        const menuLinks = menu.querySelectorAll('a');
        menuLinks.forEach((link, index) => {
            link.style.opacity = '0';
            link.style.transform = 'translateY(20px)';
            link.style.transition = `opacity 0.3s ease ${index * 0.1}s, transform 0.3s ease ${index * 0.1}s`;
        });

        function animateMenuLinks() {
            menuLinks.forEach(link => {
                link.style.opacity = '1';
                link.style.transform = 'translateY(0)';
            });
        }

        menu.addEventListener('transitionend', (e) => {
            if (e.propertyName === 'opacity' && !menu.classList.contains('hidden')) {
                animateMenuLinks();
            }
        });
    </script>
</body>
</html>