<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AndWeare</title>
    <link rel="icon" type="image/png" href="logo.png">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+KR:wght@300;400;500;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Noto Sans KR', sans-serif;
            background-color: #ffffff;
            overflow-x: hidden;
        }
        
        .content-container {
            position: relative;
            z-index: 10;
        }
        
        .video-container {
            position: fixed;
            pointer-events: none;
        }
        
        .video-left {
            left: -10%;
            transform: perspective(1000px) rotateY(-10deg) rotateX(15deg);
        }
        
        .video-right {
            right: -10%;
            transform: perspective(1000px) rotateY(10deg) rotateX(15deg);
        }
        
        .blur-element {
            opacity: 0;
            filter: blur(10px);
            transform: translateY(20px);
            transition: opacity 0.8s ease, filter 0.8s ease, transform 0.8s ease;
        }
        
        .blur-element.visible {
            opacity: 1;
            filter: blur(0);
            transform: translateY(0);
        }
        
        .delay-100 {
            transition-delay: 0.1s;
        }
        
        .delay-200 {
            transition-delay: 0.3s;
        }
        
        .delay-300 {
            transition-delay: 0.5s;
        }
        
        .delay-400 {
            transition-delay: 0.7s;
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center p-4">
    <div class="video-container video-left hidden md:block">
        <video autoplay loop muted playsinline class="h-screen object-cover">
            <source src="https://placehold.co/1080x1920.mp4" type="video/mp4">
        </video>
    </div>
    
    <div class="video-container video-right hidden md:block">
        <video autoplay loop muted playsinline class="h-screen object-cover">
            <source src="253998_small.mp4" type="video/mp4">
        </video>
    </div>
    
    <div class="content-container max-w-2xl mx-auto text-center">
        <span class="blur-element inline-block px-4 py-2 bg-gray-100 rounded-full text-sm font-medium text-gray-800 mb-6">Where we'll all be</span>
        
        <h1 class="blur-element delay-100 text-5xl md:text-6xl font-bold mb-6">Your Family's Private Hub</h1>
        
        <p class="blur-element delay-200 text-xl text-gray-600 mb-10">
            Create a private online space where your family can connect, share, and organize your life together - no matter how far apart you are.
        </p>
        
        <a href="/hub" class="blur-element delay-300 inline-block px-8 py-4 bg-black text-white rounded-full hover:bg-gray-800 transition-colors text-center text-lg">
            Get Started
        </a>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(function() {
                const elements = document.querySelectorAll('.blur-element');
                elements.forEach(function(element) {
                    element.classList.add('visible');
                });
            }, 300);
        });
    </script>
</body>
</html>