<?php
require 'vendor/autoload.php';
require_once 'db.php';

use Ratchet\Server\IoServer;
use Ratchet\Http\HttpServer;
use Ratchet\WebSocket\WsServer;
use React\EventLoop\Factory;
use React\Socket\SecureServer;
use React\Socket\Server;

class BillboardSocket implements \Ratchet\MessageComponentInterface {
    protected $clients;
    protected $billboards;
    
    public function __construct() {
        $this->clients = new \SplObjectStorage;
        $this->billboards = [];
    }
    
    public function onOpen(\Ratchet\ConnectionInterface $conn) {
        $this->clients->attach($conn);
        echo "New connection! ({$conn->resourceId})\n";
    }
    
    public function onMessage(\Ratchet\ConnectionInterface $from, $msg) {
        $data = json_decode($msg, true);
        
        if (isset($data['type'])) {
            switch ($data['type']) {
                case 'register':
                    if (isset($data['serial'])) {
                        $this->billboards[$from->resourceId] = $data['serial'];
                        echo "Billboard registered: {$data['serial']} ({$from->resourceId})\n";
                    }
                    break;
                
                case 'broadcast':
                    if (isset($data['serial']) && isset($data['status'])) {
                        $this->broadcastStatus($data['serial'], $data['status'], $data['message'] ?? null);
                    }
                    break;
            }
        }
    }
    
    public function onClose(\Ratchet\ConnectionInterface $conn) {
        $this->clients->detach($conn);
        if (isset($this->billboards[$conn->resourceId])) {
            echo "Billboard disconnected: {$this->billboards[$conn->resourceId]} ({$conn->resourceId})\n";
            unset($this->billboards[$conn->resourceId]);
        }
    }
    
    public function onError(\Ratchet\ConnectionInterface $conn, \Exception $e) {
        echo "Error: {$e->getMessage()}\n";
        $conn->close();
    }
    
    public function broadcastStatus($serial, $status, $message = null) {
        foreach ($this->clients as $client) {
            $clientSerial = $this->billboards[$client->resourceId] ?? null;
            
            if ($clientSerial === $serial) {
                $client->send(json_encode([
                    'type' => 'status_update',
                    'serial' => $serial,
                    'status' => $status,
                    'message' => $message
                ]));
                
                echo "Status broadcast to $serial: $status\n";
            }
        }
    }
}