<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IMATORS BANK - Administration</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        [x-cloak] { display: none !important; }
    </style>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen bg-gray-100">
        <!-- Top Navigation -->
        <nav class="bg-gray-800">
            <div class="mx-auto px-4">
                <div class="flex h-16 justify-between">
                    <div class="flex items-center font-bold text-white text-xl">
                        IMATORS BANK
                    </div>
                    <div class="flex items-center">
                        <span class="text-gray-300 mr-4"><?= $_SESSION['role'] ?></span>
                        <a href="?logout=1" class="text-red-400 hover:text-red-300">Déconnexion</a>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <main class="p-4">
            <!-- Statistiques -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-8">
                <div class="bg-white p-6 rounded-lg shadow">
                    <div class="text-gray-500 text-sm">Balance Totale</div>
                    <div class="text-2xl font-bold text-gray-800"><?= format_number($stats['total_balance']) ?></div>
                </div>

                <div class="bg-white p-6 rounded-lg shadow">
                    <div class="text-gray-500 text-sm">Comptes Bloqués</div>
                    <div class="text-2xl font-bold text-gray-800"><?= $stats['blocked_accounts'] ?></div>
                </div>

                <div class="bg-white p-6 rounded-lg shadow">
                    <div class="text-gray-500 text-sm">Montants Suspects</div>
                    <div class="text-2xl font-bold text-gray-800"><?= format_number($stats['suspicious_amount']) ?></div>
                </div>

                <div class="bg-white p-6 rounded-lg shadow">
                    <div class="text-gray-500 text-sm">Total Utilisateurs</div>
                    <div class="text-2xl font-bold text-gray-800"><?= $stats['total_users'] ?></div>
                </div>
            </div>

            <!-- Tableau des Users -->
            <div class="bg-white rounded-lg shadow mb-8">
                <div class="p-4 border-b border-gray-200">
                    <div class="flex items-center justify-between">
                        <h2 class="text-xl font-semibold">Liste des Comptes</h2>
                        <div class="flex space-x-2">
                            <input type="text" id="searchClient" placeholder="Rechercher..." 
                                   class="border rounded px-3 py-1 text-sm">
                            <select id="filterStatus" class="border rounded px-3 py-1 text-sm">
                                <option value="all">Tous</option>
                                <option value="active">Actifs</option>
                                <option value="blocked">Bloqués</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="bg-gray-50 text-left">
                                <th class="p-4 font-medium text-gray-600">Client</th>
                                <th class="p-4 font-medium text-gray-600">Email</th>
                                <th class="p-4 font-medium text-gray-600 text-right">Balance</th>
                                <th class="p-4 font-medium text-gray-600 text-center">Statut</th>
                                <?php if($_SESSION['role'] === 'admin'): ?>
                                <th class="p-4 font-medium text-gray-600 text-center">Actions</th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($users as $user): ?>
                            <tr class="border-t border-gray-100">
                                <td class="p-4">
                                    <?= htmlspecialchars($user['firstname'] . ' ' . $user['lastname']) ?>
                                    <div class="text-xs text-gray-500">ID: <?= htmlspecialchars($user['userid']) ?></div>
                                </td>
                                <td class="p-4"><?= htmlspecialchars($user['email']) ?></td>
                                <td class="p-4 text-right font-medium"><?= format_number($user['balance']) ?></td>
                                <td class="p-4 text-center">
                                    <?php if($user['blocked-account'] == 'false'): ?>
                                        <span class="inline-flex px-2 py-1 text-xs rounded-full text-red-700 bg-red-100">Bloqué</span>
                                    <?php else: ?>
                                        <span class="inline-flex px-2 py-1 text-xs rounded-full text-green-700 bg-green-100">Actif</span>
                                    <?php endif; ?>
                                </td>
                                <?php if($_SESSION['role'] === 'admin'): ?>
                                <td class="p-4 text-center">
                                    <form method="POST" class="inline-block">
                                        <input type="hidden" name="userid" value="<?= htmlspecialchars($user['userid']) ?>">
                                        <?php if($user['blocked-account'] == 'false'): ?>
                                            <button type="submit" name="action" value="unblock" 
                                                    class="px-3 py-1 text-xs rounded-lg bg-green-100 text-green-700 hover:bg-green-200">
                                                Débloquer
                                            </button>
                                        <?php else: ?>
                                            <button type="submit" name="action" value="block"
                                                    onclick="return confirm('Confirmer le blocage du compte ?')"
                                                    class="px-3 py-1 text-xs rounded-lg bg-red-100 text-red-700 hover:bg-red-200">
                                                Bloquer
                                            </button>
                                        <?php endif; ?>
                                    </form>
                                </td>
                                <?php endif; ?>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Transactions Suspectes -->
            <div class="bg-white rounded-lg shadow">
                <div class="p-4 border-b border-gray-200">
                    <h2 class="text-xl font-semibold">Transactions Suspectes</h2>
                </div>

                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="bg-gray-50 text-left">
                                <th class="p-4 font-medium text-gray-600">Transaction</th>
                                <th class="p-4 font-medium text-gray-600">Expéditeur</th>
                                <th class="p-4 font-medium text-gray-600">Destinataire</th>
                                <th class="p-4 font-medium text-gray-600 text-right">Montant</th>
                                <th class="p-4 font-medium text-gray-600 text-right">Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($transactions as $trans): ?>
                            <tr class="border-t border-gray-100">
                                <td class="p-4">
                                    <div class="font-medium">#<?= htmlspecialchars($trans['id']) ?></div>
                                    <div class="text-xs text-gray-500"><?= htmlspecialchars($trans['type']) ?></div>
                                </td>
                                <td class="p-4">
                                    <div class="font-medium"><?= htmlspecialchars($trans['sender_firstname'] . ' ' . $trans['sender_lastname']) ?></div>
                                    <div class="text-xs text-gray-500">ID: <?= htmlspecialchars($trans['sender_id']) ?></div>
                                </td>
                                <td class="p-4">
                                    <div class="font-medium"><?= htmlspecialchars($trans['recipient_firstname'] . ' ' . $trans['recipient_lastname']) ?></div>
                                    <div class="text-xs text-gray-500">ID: <?= htmlspecialchars($trans['recipient_id']) ?></div>
                                </td>
                                <td class="p-4 text-right font-medium text-red-600">
                                    <?= format_number($trans['amount']) ?>
                                </td>
                                <td class="p-4 text-right text-gray-500">
                                    <?= time_ago($trans['created_at']) ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </main>
    </div>

    <script>
    // Simple search
    document.getElementById('searchClient').addEventListener('input', function(e) {
        const searchTerm = e.target.value.toLowerCase();
        const rows = document.querySelectorAll('tbody tr');
        
        rows.forEach(row => {
            const text = row.textContent.toLowerCase();
            row.style.display = text.includes(searchTerm) ? '' : 'none';
        });
    });

    // Simple filter
    document.getElementById('filterStatus').addEventListener('change', function(e) {
        const status = e.target.value;
        const rows = document.querySelectorAll('tbody tr');
        
        rows.forEach(row => {
            if (status === 'all') {
                row.style.display = '';
                return;
            }
            
            const isBlocked = row.querySelector('.text-red-700') !== null;
            const isActive = row.querySelector('.text-green-700') !== null;
            
            if (status === 'blocked' && isBlocked) row.style.display = '';
            else if (status === 'active' && isActive) row.style.display = '';
            else row.style.display = 'none';
        });
    });
    </script>
</body>
</html>