<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forum Post - Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
        }
        
        header {
            background-color: rgba(0, 0, 0, 0.8);
        }
        
        .separator {
            height: 1px;
            background-color: #333;
            width: 100%;
            margin: 30px 0;
        }
        
        a.text-link {
            position: relative;
            color: #FFFFFF;
            text-decoration: none;
            padding-bottom: 2px;
        }
        
        a.text-link::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 1px;
            bottom: 0;
            left: 0;
            background-color: #FFFFFF;
            transform: scaleX(0);
            transform-origin: bottom right;
            transition: transform 0.3s;
        }
        
        a.text-link:hover::after {
            transform: scaleX(1);
            transform-origin: bottom left;
        }
        
        .comment {
            border-bottom: 1px solid #333;
        }
        
        .comment:last-child {
            border-bottom: none;
        }
    </style>
</head>
<body>
    <?php include 'src/header.php'; ?>
    
    <div class="container px-4 mx-auto py-12">
        <?php
        require_once '/conn/db.php';
        
        if(!isset($_GET['id']) || strlen($_GET['id']) != 12) {
            echo '<div class="text-center py-10">
                <h2 class="text-2xl font-light mb-4">Post Not Found</h2>
                <p class="text-gray-400 mb-6">The post you\'re looking for doesn\'t exist or has been removed.</p>
                <a href="/forum" class="bg-white text-black px-4 py-2 rounded-md hover:bg-gray-200 transition">Back to Forum</a>
            </div>';
            include 'footer.php';
            exit;
        }
        
        $post_id = $_GET['id'];
        
        $conn->query("UPDATE posts SET views = views + 1 WHERE id = '$post_id'");
        
        $query = "SELECT p.id, p.title, p.content, p.created_at, p.views, u.username, u.avatar 
                 FROM posts p
                 JOIN users u ON p.user_id = u.id
                 WHERE p.id = '$post_id'";
        $result = $conn->query($query);
        
        if ($result->num_rows > 0) {
            $post = $result->fetch_assoc();
            $post_date = date("F j, Y", strtotime($post["created_at"]));
            ?>
            
            <div class="mb-6">
                <a href="/forum" class="text-link mb-8 inline-block"><i class="fas fa-arrow-left mr-2"></i> Back to Forum</a>
            </div>
            
            <article class="mb-10">
                <h1 class="text-4xl font-light mb-4"><?php echo $post["title"]; ?></h1>
                
                <div class="flex items-center mb-6">
                    <div class="w-10 h-10 rounded-full overflow-hidden mr-3">
                        <?php if($post["avatar"]): ?>
                            <img src="<?php echo $post["avatar"]; ?>" alt="<?php echo $post["username"]; ?>" class="w-full h-full object-cover">
                        <?php else: ?>
                            <div class="w-full h-full bg-gray-700 flex items-center justify-center">
                                <span class="text-sm"><?php echo strtoupper(substr($post["username"], 0, 1)); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div>
                        <p class="font-medium"><?php echo $post["username"]; ?></p>
                        <p class="text-sm text-gray-400"><?php echo $post_date; ?></p>
                    </div>
                    <div class="ml-auto text-sm text-gray-400">
                        <span class="mr-4"><i class="far fa-eye mr-1"></i> <?php echo $post["views"]; ?> views</span>
                    </div>
                </div>
                
                <div class="post-content text-gray-300 leading-relaxed">
                    <?php echo $post["content"]; ?>
                </div>
            </article>
            
            <div class="separator"></div>
            
            <div class="py-8">
                <h2 class="text-2xl font-light mb-6">Comments</h2>
                
                <?php
                $comments_query = "SELECT c.id, c.content, c.created_at, u.username, u.avatar 
                                  FROM comments c
                                  JOIN users u ON c.user_id = u.id
                                  WHERE c.post_id = '$post_id'
                                  ORDER BY c.created_at ASC";
                $comments_result = $conn->query($comments_query);
                
                if ($comments_result->num_rows > 0) {
                    while($comment = $comments_result->fetch_assoc()) {
                        $comment_date = date("M j, Y", strtotime($comment["created_at"]));
                        ?>
                        
                        <div class="comment py-6">
                            <div class="flex items-start">
                                <div class="w-10 h-10 rounded-full overflow-hidden mr-3">
                                    <?php if($comment["avatar"]): ?>
                                        <img src="<?php echo $comment["avatar"]; ?>" alt="<?php echo $comment["username"]; ?>" class="w-full h-full object-cover">
                                    <?php else: ?>
                                        <div class="w-full h-full bg-gray-700 flex items-center justify-center">
                                            <span class="text-sm"><?php echo strtoupper(substr($comment["username"], 0, 1)); ?></span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="flex-1">
                                    <div class="flex justify-between items-center mb-2">
                                        <p class="font-medium"><?php echo $comment["username"]; ?></p>
                                        <p class="text-sm text-gray-400"><?php echo $comment_date; ?></p>
                                    </div>
                                    <div class="text-gray-300">
                                        <?php echo $comment["content"]; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <?php
                    }
                } else {
                    echo '<div class="text-center py-8">
                        <p class="text-gray-400">No comments yet. Be the first to share your thoughts!</p>
                    </div>';
                }
                ?>
                
                <div class="mt-10">
                    <?php if(isset($_SESSION['user_id'])): ?>
                        <h3 class="text-xl font-light mb-4">Leave a Comment</h3>
                        <form action="/post-comment.php" method="post" class="mt-4">
                            <input type="hidden" name="post_id" value="<?php echo $post_id; ?>">
                            <textarea name="content" rows="4" class="w-full bg-gray-800 border border-gray-700 rounded-md p-3 text-white focus:outline-none focus:border-gray-500" placeholder="Share your thoughts..."></textarea>
                            <button type="submit" class="mt-4 bg-white text-black px-4 py-2 rounded-md hover:bg-gray-200 transition">Post Comment</button>
                        </form>
                    <?php else: ?>
                        <div class="bg-gray-800 rounded-md p-6 text-center">
                            <p class="text-gray-300 mb-4">You must be logged in to comment</p>
                            <a href="/login" class="bg-white text-black px-4 py-2 rounded-md hover:bg-gray-200 transition">Log In</a>
                            <span class="mx-2 text-gray-500">or</span>
                            <a href="/register" class="text-link">Create an Account</a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <?php
        } else {
            echo '<div class="text-center py-10">
                <h2 class="text-2xl font-light mb-4">Post Not Found</h2>
                <p class="text-gray-400 mb-6">The post you\'re looking for doesn\'t exist or has been removed.</p>
                <a href="/forum" class="bg-white text-black px-4 py-2 rounded-md hover:bg-gray-200 transition">Back to Forum</a>
            </div>';
        }
        ?>
    </div>

    <footer class="bg-black text-white"><div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Need Help?</h5>
        <a href="/support" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
        <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
        <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
    </div>
</div>

<div class="text-center py-4 border-t border-gray-800">
    <p class="text-sm mb-2">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs">
        Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.
    </p>
</div></footer>

    <script>
        document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.add('hidden');
        });
    </script>
</body>
</html>