<?php
require_once 'config.php';

if(!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

if(isset($_POST['upload'])) {
    $name = $_POST['name'];
    $description = $_POST['description'];
    $tags = $_POST['tags'];
    $time = $_POST['time'];
    $url_video = $_POST['url_video'];
    $picture_cover = $_POST['picture_cover'];
    
    $stmt = $pdo->prepare("INSERT INTO content (name, description, tags, time, url_video, picture_cover, author_id) VALUES (?, ?, ?, ?, ?, ?, ?)");
    
    try {
        $stmt->execute([$name, $description, $tags, $time, $url_video, $picture_cover, $_SESSION['user_id']]);
        header('Location: index.php');
        exit;
    } catch(PDOException $e) {
        $error = "Error uploading video";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload Video - ForMore</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gradient-to-br from-black to-blue-900 min-h-screen text-white p-8">
    <nav class="flex justify-between items-center mb-8">
        <h1 class="text-3xl font-bold">ForMore</h1>
        <a href="index.php" class="text-blue-400 hover:text-blue-300">Back to Home</a>
    </nav>

    <div class="max-w-2xl mx-auto">
        <form method="POST" class="bg-gray-800 rounded-lg p-6">
            <?php if(isset($error)): ?>
                <div class="bg-red-500 text-white p-3 rounded mb-4"><?= $error ?></div>
            <?php endif; ?>

            <div class="mb-4">
                <label class="block text-gray-300 text-sm font-bold mb-2">Video Title</label>
                <input type="text" name="name" required 
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            </div>

            <div class="mb-4">
                <label class="block text-gray-300 text-sm font-bold mb-2">Video URL</label>
                <input type="url" name="url_video" required 
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            </div>

            <div class="mb-4">
                <label class="block text-gray-300 text-sm font-bold mb-2">Cover Image URL</label>
                <input type="url" name="picture_cover" required 
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            </div>

            <div class="mb-4">
                <label class="block text-gray-300 text-sm font-bold mb-2">Duration (e.g. "5:30")</label>
                <input type="text" name="time" required pattern="[0-9]+:[0-9]+" 
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            </div>

            <div class="mb-4">
                <label class="block text-gray-300 text-sm font-bold mb-2">Tags (comma separated)</label>
                <input type="text" name="tags" required 
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            </div>

            <div class="mb-6">
                <label class="block text-gray-300 text-sm font-bold mb-2">Description</label>
                <textarea name="description" required rows="4" 
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline"></textarea>
            </div>

            <button type="submit" name="upload" 
                class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline w-full">
                Upload Video
            </button>
        </form>
    </div>
</body>
</html>