Route::get('/editor', function() {
    if (!session('authenticated')) {
        return redirect('/');
    }
    
    if (time() - session('auth_time', 0) > 3600) {
        session()->flush();
        return redirect('/')->with('error', 'Session expirée');
    }
    
    return view('editor');
})->name('editor');

Route::get('/editor/{document_id?}', function($document_id = null) {
    if (!session('authenticated')) {
        return redirect('/');
    }
    
    if (time() - session('auth_time', 0) > 3600) {
        session()->flush();
        return redirect('/')->with('error', 'Session expirée');
    }
    
    return view('editor', compact('document_id'));
})->name('editor.document');