<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Header - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/9.3.2/swiper-bundle.min.css" />
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            color: #FFFFFF;
            background-color: #000000;
        }

        .header {
            background-color: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1002;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
            height: 90px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: fixed;
            width: 100%;
            top: 0;
        }

        .header.with-banner {
            top: 40px;
        }

        .desktop-menu { display: none; }

        @media (min-width: 1024px) {
            .desktop-menu {
                display: flex;
            }

            .desktop-menu-item {
                position: relative;
                padding: 1.25rem 1.5rem;
                cursor: pointer;
                color: #FFFFFF;
                font-weight: 500;
                transition: all 0.4s ease;
                border-radius: 16px;
                font-size: 1.1rem;
            }

            .desktop-menu-item:hover {
                color: rgba(255, 255, 255, 0.9);
                background: rgba(255, 255, 255, 0.15);
            }
        }

        .desktop-submenu {
            position: absolute;
            top: calc(100% + 10px);
            left: 50%;
            transform: translateX(-50%) translateY(15px);
            background-color: rgba(0, 0, 0, 0.95);
            min-width: 280px;
            border-radius: 20px;
            opacity: 0;
            visibility: hidden;
            transition: all 0.4s ease;
            border: 1px solid rgba(255, 255, 255, 0.15);
            padding: 12px;
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.2);
        }

        .desktop-menu-item:hover .desktop-submenu {
            opacity: 1;
            visibility: visible;
            transform: translateX(-50%) translateY(0);
        }

        .desktop-submenu a {
            display: block;
            padding: 1rem 1.25rem;
            color: #FFFFFF;
            transition: all 0.3s ease;
            border-radius: 14px;
            text-align: center;
            font-size: 1.05rem;
        }

        .desktop-submenu a:hover {
            background-color: rgba(255, 255, 255, 0.15);
            transform: translateX(5px);
        }

        .mobile-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            backdrop-filter: blur(8px);
            -webkit-backdrop-filter: blur(8px);
            opacity: 0;
            visibility: hidden;
            transition: all 0.4s ease;
            z-index: 1000;
        }

        .mobile-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu {
            position: fixed;
            top: 90px;
            left: 0;
            width: 100%;
            height: calc(100vh - 90px);
            background: #000000;
            transform: translateY(-100%);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1001;
            opacity: 0;
            visibility: hidden;
            overflow-y: auto;
            -webkit-overflow-scrolling: touch;
        }

        .mobile-menu.with-banner {
            top: 130px;
            height: calc(100vh - 130px);
        }

        .mobile-menu.active {
            transform: translateY(0);
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu-header {
            position: sticky;
            top: 0;
            background: #000000;
            z-index: 2;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 25px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }

        .menu-title {
            font-size: 1.5rem;
            font-weight: 600;
        }

        .mobile-menu-items {
            padding: 25px;
            padding-bottom: 50px;
        }

        .mobile-menu-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 20px;
            margin-bottom: 15px;
            background: rgba(255, 255, 255, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.15);
            border-radius: 20px;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .mobile-menu-item:active {
            transform: scale(0.98);
            background: rgba(255, 255, 255, 0.15);
        }

        .mobile-submenu-panel {
            position: fixed;
            top: 90px;
            left: 0;
            width: 100%;
            height: calc(100vh - 90px);
            background: #000000;
            z-index: 1002;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            transform: translateX(100%);
            opacity: 0;
            visibility: hidden;
            overflow-y: auto;
        }

        .mobile-submenu-panel.with-banner {
            top: 130px;
            height: calc(100vh - 130px);
        }

        .mobile-submenu-panel.active {
            transform: translateX(0);
            opacity: 1;
            visibility: visible;
        }

        .mobile-submenu-header {
            position: sticky;
            top: 0;
            background: #000000;
            z-index: 2;
            display: flex;
            align-items: center;
            padding: 25px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            gap: 20px;
            backdrop-filter: blur(10px);
        }

        .mobile-submenu-content {
            padding: 25px;
            padding-bottom: 50px;
        }

        .mobile-submenu-link {
            display: block;
            padding: 20px;
            margin-bottom: 15px;
            background: rgba(255, 255, 255, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.15);
            border-radius: 20px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            font-size: 1.1rem;
        }

        .mobile-submenu-link:active {
            transform: scale(0.98);
            background: rgba(255, 255, 255, 0.15);
        }

        .hamburger {
            width: 48px;
            height: 48px;
            position: relative;
            cursor: pointer;
            z-index: 1003;
            display: none;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.25);
            border-radius: 50%;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        @media (max-width: 1023px) {
            .hamburger {
                display: flex;
            }
        }

        .hamburger span {
            display: block;
            position: absolute;
            height: 2px;
            width: 24px;
            background: #FFFFFF;
            border-radius: 2px;
            opacity: 1;
            left: 12px;
            transition: transform 0.4s ease-in-out;
        }

        .hamburger span:nth-child(1) {
            top: 17px;
            transform-origin: center;
        }

        .hamburger span:nth-child(2) {
            top: 29px;
            transform-origin: center;
        }

        .hamburger.active span:nth-child(1) {
            transform: translateY(6px) rotate(45deg);
        }

        .hamburger.active span:nth-child(2) {
            transform: translateY(-6px) rotate(-45deg);
        }

        .close-button {
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.25);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .featured-cards-section {
            padding: 25px;
            margin-bottom: 25px;
            opacity: 0;
            transform: translateY(20px);
            animation: fadeInUp 0.6s ease forwards;
        }

        .swiper {
            width: 100%;
            height: 220px;
            margin-left: auto;
            margin-right: auto;
            overflow: visible;
        }

        .swiper-slide {
            height: 200px;
            border-radius: 28px;
            padding: 25px;
            position: relative;
            overflow: hidden;
            transition: transform 0.4s ease;
        }

        .swiper-slide-active {
            transform: scale(1.03);
        }

        .card-content {
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            position: relative;
            z-index: 2;
        }

        .card-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 10px;
            opacity: 0;
            transform: translateY(-10px);
            animation: fadeInDown 0.6s ease forwards;
            animation-delay: 0.2s;
        }

        .card-description {
            font-size: 1rem;
            opacity: 0.9;
            max-width: 85%;
            opacity: 0;
            transform: translateY(10px);
            animation: fadeInUp 0.6s ease forwards;
            animation-delay: 0.4s;
        }

        .card-button {
            align-self: flex-end;
            padding: 10px 20px;
            background: rgba(255, 255, 255, 0.25);
            border-radius: 9999px;
            font-size: 1rem;
            font-weight: 500;
            transition: all 0.4s ease;
            opacity: 0;
            transform: translateY(10px);
            animation: fadeInUp 0.6s ease forwards;
            animation-delay: 0.6s;
        }

        .card-button:active {
            transform: scale(0.95);
            background: rgba(255, 255, 255, 0.35);
        }

        @keyframes fadeInUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes fadeInDown {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .swiper-pagination {
            position: relative;
            margin-top: 20px;
        }

        .swiper-pagination-bullet {
            width: 8px;
            height: 8px;
            background: rgba(255, 255, 255, 0.35);
            opacity: 1;
        }

        .swiper-pagination-bullet-active {
            background: #FFFFFF;
            transform: scale(1.3);
        }

        .imators-account-btn {
            display: inline-flex;
            align-items: center;
            padding: 0.75rem 1.5rem;
            font-weight: 500;
            color: #000000;
            background-color: #FFFFFF;
            border-radius: 14px;
            transition: all 0.3s ease;
            font-size: 1.1rem;
        }

        .imators-account-btn:hover {
            opacity: 0.9;
            transform: translateY(-2px);
        }
    </style>
</head>
<body class="h-full">
    [Rest of the HTML content remains exactly the same as in the original file]
</body>
</html>