<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Projects - Izhak</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://api.fontshare.com/v2/css?f[]=cabinet-grotesk@400,500,700,800&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-light: #ffffff;
            --bg-dark: #121212;
            --text-light: #121212;
            --text-dark: #f5f5f5;
            --border-light: rgba(0, 0, 0, 0.1);
            --border-dark: rgba(255, 255, 255, 0.1);
            --folder-light: #f8f8f8;
            --folder-dark: #1e1e1e;
        }

        @media (prefers-color-scheme: dark) {
            body {
                background-color: var(--bg-dark);
                color: var(--text-dark);
            }
            .header-border {
                border-top: 1px solid var(--text-dark);
                border-bottom: 1px solid var(--text-dark);
                background-color: rgba(18, 18, 18, 0.8);
            }
            .folder {
                background-color: var(--folder-dark);
                border: 1px solid var(--border-dark);
            }
            .project-details {
                background-color: var(--bg-dark);
                border: 1px solid var(--border-dark);
            }
        }

        @media (prefers-color-scheme: light) {
            body {
                background-color: var(--bg-light);
                color: var(--text-light);
            }
            .header-border {
                border-top: 1px solid var(--text-light);
                border-bottom: 1px solid var(--text-light);
                background-color: rgba(255, 255, 255, 0.8);
            }
            .folder {
                background-color: var(--folder-light);
                border: 1px solid var(--border-light);
            }
            .project-details {
                background-color: var(--bg-light);
                border: 1px solid var(--border-light);
            }
        }

        body {
            font-family: 'Cabinet Grotesk', sans-serif;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .header-border {
            backdrop-filter: blur(10px);
        }

        .main-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1rem;
        }

        .folder {
            transition: all 0.2s ease;
            cursor: pointer;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }

        .folder:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.08);
        }

        .project-details {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) scale(0.9);
            width: 90%;
            max-width: 800px;
            max-height: 85vh;
            overflow-y: auto;
            z-index: 1000;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
        }

        .project-details.show {
            opacity: 1;
            visibility: visible;
            transform: translate(-50%, -50%) scale(1);
        }

        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.3);
            z-index: 999;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .overlay.show {
            opacity: 1;
            visibility: visible;
        }

        .close-btn {
            position: absolute;
            top: 15px;
            right: 15px;
            width: 30px;
            height: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: opacity 0.2s ease;
        }

        .close-btn:hover {
            opacity: 0.7;
        }
    </style>
</head>
<body class="min-h-screen">
    <header class="header-border py-8 mb-16 sticky top-0 z-50">
        <div class="main-container">
            <div class="flex justify-between items-center">
                <h1 class="text-6xl md:text-7xl font-light italic tracking-tight">
                    Izhak
                </h1>
                <a href="index.html" class="text-sm hover:underline hover:font-semibold font-light max-w-xs text-right leading-relaxed">
                    <- MENU
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <section id="intro" class="mb-16">
            <div class="max-w-2xl">
                <span class="inline-block text-sm font-light tracking-wide mb-4">
                    Projects
                </span>
                <h2 class="text-4xl md:text-5xl font-light tracking-tight mb-6">
                    Double-click to explore
                </h2>
                <p class="text-lg font-light leading-relaxed mb-12">
                    Each folder represents a project category. Double-click to view the details.
                </p>
            </div>
        </section>

        <section id="projects" class="mb-16">
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-10">
                <!-- Folder 1 -->
                <div class="folder rounded-lg p-6 text-center" onclick="toggleProject('websites')">
                    <svg class="w-16 h-16 mx-auto mb-4 opacity-70" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M22 19C22 19.5304 21.7893 20.0391 21.4142 20.4142C21.0391 20.7893 20.5304 21 20 21H4C3.46957 21 2.96086 20.7893 2.58579 20.4142C2.21071 20.0391 2 19.5304 2 19V5C2 4.46957 2.21071 3.96086 2.58579 3.58579C2.96086 3.21071 3.46957 3 4 3H9L11 6H20C20.5304 6 21.0391 6.21071 21.4142 6.58579C21.7893 6.96086 22 7.46957 22 8V19Z" fill="currentColor"/>
                    </svg>
                    <h3 class="text-xl font-light">Websites</h3>
                    <p class="text-sm font-light opacity-60 mt-2">Web platforms & portals</p>
                </div>

                <!-- Folder 2 -->
                <div class="folder rounded-lg p-6 text-center" onclick="toggleProject('applications')">
                    <svg class="w-16 h-16 mx-auto mb-4 opacity-70" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M22 19C22 19.5304 21.7893 20.0391 21.4142 20.4142C21.0391 20.7893 20.5304 21 20 21H4C3.46957 21 2.96086 20.7893 2.58579 20.4142C2.21071 20.0391 2 19.5304 2 19V5C2 4.46957 2.21071 3.96086 2.58579 3.58579C2.96086 3.21071 3.46957 3 4 3H9L11 6H20C20.5304 6 21.0391 6.21071 21.4142 6.58579C21.7893 6.96086 22 7.46957 22 8V19Z" fill="currentColor"/>
                    </svg>
                    <h3 class="text-xl font-light">Applications</h3>
                    <p class="text-sm font-light opacity-60 mt-2">Mobile & desktop apps</p>
                </div>

                <!-- Folder 3 -->
                <div class="folder rounded-lg p-6 text-center" onclick="toggleProject('tools')">
                    <svg class="w-16 h-16 mx-auto mb-4 opacity-70" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M22 19C22 19.5304 21.7893 20.0391 21.4142 20.4142C21.0391 20.7893 20.5304 21 20 21H4C3.46957 21 2.96086 20.7893 2.58579 20.4142C2.21071 20.0391 2 19.5304 2 19V5C2 4.46957 2.21071 3.96086 2.58579 3.58579C2.96086 3.21071 3.46957 3 4 3H9L11 6H20C20.5304 6 21.0391 6.21071 21.4142 6.58579C21.7893 6.96086 22 7.46957 22 8V19Z" fill="currentColor"/>
                    </svg>
                    <h3 class="text-xl font-light">Tools</h3>
                    <p class="text-sm font-light opacity-60 mt-2">Utility & productivity tools</p>
                </div>
            </div>
        </section>
    </main>

    <!-- Overlay -->
    <div class="overlay" id="overlay" onclick="closeAllProjects()"></div>

    <!-- Project Details -->
    <!-- Websites Folder -->
    <div class="project-details rounded-lg p-8" id="websites">
        <div class="close-btn" onclick="closeAllProjects()">✕</div>
        <h2 class="text-3xl font-light mb-8 pb-4 border-b border-opacity-20 border-current">Websites</h2>
        
        <div class="space-y-12">
            <!-- Website 1 -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 items-start">
                <div class="md:col-span-1">
                    <img src="https://images.unsplash.com/photo-1551288049-bebda4e38f71?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                         class="w-full rounded-lg" alt="ForChange Platform">
                </div>
                <div class="md:col-span-2">
                    <h3 class="text-2xl font-light mb-2">ForChange Platform</h3>
                    <p class="text-base font-light opacity-80 mb-4">
                        A comprehensive platform created to connect communities and enable positive social change.
                    </p>
                    <p class="text-sm font-light opacity-60 mb-4">
                        Technologies: HTML, CSS, PHP, MySQL, JavaScript
                    </p>
                    <a href="https://forchange.me" class="text-sm underline hover:no-underline">Visit Website</a>
                </div>
            </div>
            
            <!-- Website 2 -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 items-start pt-8 border-t border-opacity-10 border-current">
                <div class="md:col-span-1">
                    <img src="https://images.unsplash.com/photo-1517245386807-bb43f82c33c4?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                         class="w-full rounded-lg" alt="Aktascorp Website">
                </div>
                <div class="md:col-span-2">
                    <h3 class="text-2xl font-light mb-2">Aktascorp Website</h3>
                    <p class="text-base font-light opacity-80 mb-4">
                        A modern, responsive website for the Aktascorp group showcasing their services and portfolio.
                    </p>
                    <p class="text-sm font-light opacity-60 mb-4">
                        Technologies: HTML, CSS, JavaScript, PHP
                    </p>
                    <a href="https://aktascorp.com" class="text-sm underline hover:no-underline">Visit Website</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Applications Folder -->
    <div class="project-details rounded-lg p-8" id="applications">
        <div class="close-btn" onclick="closeAllProjects()">✕</div>
        <h2 class="text-3xl font-light mb-8 pb-4 border-b border-opacity-20 border-current">Applications</h2>
        
        <div class="space-y-12">
            <!-- App 1 -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 items-start">
                <div class="md:col-span-1">
                    <img src="https://images.unsplash.com/photo-1526498460520-4c246339dccb?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                         class="w-full rounded-lg" alt="SmileyDay App">
                </div>
                <div class="md:col-span-2">
                    <h3 class="text-2xl font-light mb-2">SmileyDay App</h3>
                    <p class="text-base font-light opacity-80 mb-4">
                        A wellness application focused on promoting daily happiness through simple activities.
                    </p>
                    <p class="text-sm font-light opacity-60 mb-4">
                        Technologies: Swift (iOS), Java (Android), Firebase
                    </p>
                    <div class="space-x-4">
                        <a href="#" class="text-sm underline hover:no-underline">App Store</a>
                        <a href="#" class="text-sm underline hover:no-underline">Google Play</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tools Folder -->
    <div class="project-details rounded-lg p-8" id="tools">
        <div class="close-btn" onclick="closeAllProjects()">✕</div>
        <h2 class="text-3xl font-light mb-8 pb-4 border-b border-opacity-20 border-current">Tools</h2>
        
        <div class="space-y-12">
            <!-- Tool 1 -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 items-start">
                <div class="md:col-span-1">
                    <img src="https://images.unsplash.com/photo-1460925895917-afdab827c52f?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2015&q=80" 
                         class="w-full rounded-lg" alt="Imators Dashboard">
                </div>
                <div class="md:col-span-2">
                    <h3 class="text-2xl font-light mb-2">Imators Dashboard</h3>
                    <p class="text-base font-light opacity-80 mb-4">
                        A comprehensive admin dashboard for managing company resources and client projects.
                    </p>
                    <p class="text-sm font-light opacity-60 mb-4">
                        Technologies: HTML, CSS, PHP, JavaScript, MySQL
                    </p>
                    <a href="#" class="text-sm underline hover:no-underline">Private Tool</a>
                </div>
            </div>
            
            <!-- Tool 2 -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 items-start pt-8 border-t border-opacity-10 border-current">
                <div class="md:col-span-1">
                    <img src="https://images.unsplash.com/photo-1519389950473-47ba0277781c?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                         class="w-full rounded-lg" alt="TeamCollab Tool">
                </div>
                <div class="md:col-span-2">
                    <h3 class="text-2xl font-light mb-2">TeamCollab Tool</h3>
                    <p class="text-base font-light opacity-80 mb-4">
                        An internal collaboration tool for development teams with project tracking and real-time communication.
                    </p>
                    <p class="text-sm font-light opacity-60 mb-4">
                        Technologies: PHP, JavaScript, MySQL, WebSockets
                    </p>
                    <a href="#" class="text-sm underline hover:no-underline">Private Tool</a>
                </div>
            </div>
        </div>
    </div>

    <footer class="py-8 text-center text-sm font-light">
        <p>Designed with a smile.</p>
        <p>This website is protected by the <a href="https://aktascorp.com" class="underline">aktascorp group</a></p>
    </footer>

    <script>
        function toggleProject(projectId) {
            // Close any open projects first
            closeAllProjects();
            
            // Show the overlay
            document.getElementById('overlay').classList.add('show');
            
            // Show the selected project
            document.getElementById(projectId).classList.add('show');
        }
        
        function closeAllProjects() {
            // Hide the overlay
            document.getElementById('overlay').classList.remove('show');
            
            // Hide all projects
            const projects = document.querySelectorAll('.project-details');
            projects.forEach(project => {
                project.classList.remove('show');
            });
        }
        
        // Double-click handling for folders
        document.querySelectorAll('.folder').forEach(folder => {
            let clickCount = 0;
            let singleClickTimer;
            
            folder.addEventListener('click', function(e) {
                clickCount++;
                
                if (clickCount === 1) {
                    singleClickTimer = setTimeout(function() {
                        clickCount = 0;
                        // Single click action (can be left empty)
                    }, 300);
                } else if (clickCount === 2) {
                    clearTimeout(singleClickTimer);
                    clickCount = 0;
                    // Double click action - get the onclick attribute value
                    const projectId = this.getAttribute('onclick').match(/'([^']+)'/)[1];
                    toggleProject(projectId);
                }
            });
        });
    </script>
</body>
</html>