<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Produits OMP - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Urbanist:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Urbanist', sans-serif; }
        @keyframes scroll-text {
            0% { transform: translateX(100%) }
            100% { transform: translateX(-100%) }
        }
        .scroll-animation {
            animation: scroll-text 25s linear infinite;
        }
        .scroll-animation:hover {
            animation-play-state: paused;
        }
        .bg-parallax {
            background-attachment: fixed;
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
        }
        .status-beta { color: #6b7280; }
        .status-maintenance { color: #ef4444; }
        .status-online { color: #10b981; }
    </style>
</head>
<body class="bg-white">
    
    <section class="relative h-screen bg-parallax overflow-hidden" style="background-image: url('font_of_the_homepage.png')">
        <div class="absolute inset-0 bg-white bg-opacity-80"></div>        
        <div class="relative z-10 h-full flex flex-col justify-center px-12">
            <h1 class="text-8xl font-light text-black text-left tracking-tight">
                Modernise your shop without buying anything extra            
            </h1>
        </div>
        
        <div class="absolute bottom-0 left-0 right-0 h-12 flex items-center overflow-hidden border-t border-gray-100">
            <div class="scroll-animation whitespace-nowrap text-black text-sm font-light tracking-wide">
                Solutions • Technologies • Innovation • Performance • Expertise • Support • Solutions • Technologies • Innovation • Performance • Expertise • Support
            </div>
        </div>
    </section>

    <section class="py-20 bg-white">
        <div class="w-full">
            <div id="products-list" class="space-y-1">
                
            </div>
        </div>
    </section>

    <script>
        const products = [
            {
                name: "OMP seatment / For restaurant",
                description: "Make your customers pay at the table, and even allow them to order before they arrive, so that everything is ready when they come."
            },
            {
                name: "OMP store / For groceries",
                description: "Infrastructure cloud sécurisée et scalable pour héberger vos applications critiques avec haute disponibilité."
            },
            {
                name: "OMP Security",
                description: "Suite de sécurité complète incluant monitoring, détection d'intrusions et protection contre les cybermenaces."
            },
            {
                name: "OMP Workflow",
                description: "Automatisation des processus métier avec designer visuel et intégrations natives aux principaux ERP."
            }
        ];

        let productStatuses = {};

        async function loadProductStatuses() {
            try {
                const response = await fetch('status.json');
                if (response.ok) {
                    productStatuses = await response.json();
                } else {
                    console.warn('Fichier status.json non trouvé, utilisation des statuts par défaut');
                    productStatuses = {
                        "OMP seatment": "online",
                        "OMP Cloud": "online", 
                        "OMP Security": "maintenance",
                        "OMP Workflow": "beta"
                    };
                }
            } catch (error) {
                console.error('Erreur lors du chargement des statuts:', error);
                productStatuses = {
                    "OMP seatment": "online",
                    "OMP Cloud": "online", 
                    "OMP Security": "maintenance", 
                    "OMP Workflow": "beta"
                };
            }
        }

        function getStatusDisplay(status) {
            const statusMap = {
                'beta': { text: 'beta', class: 'status-beta' },
                'maintenance': { text: 'maintenance', class: 'status-maintenance' },
                'online': { text: 'online', class: 'status-online' }
            };
            return statusMap[status] || { text: 'unknown', class: 'status-beta' };
        }

        function renderProducts() {
            const productsList = document.getElementById('products-list');
            productsList.innerHTML = '';
            
            products.forEach(product => {
                const status = productStatuses[product.name] || 'online';
                const statusInfo = getStatusDisplay(status);
                
                const productDiv = document.createElement('div');
                productDiv.className = 'py-12 px-12 flex items-center justify-between border-b border-gray-100 hover:bg-gray-50 transition-colors duration-200';
                
                productDiv.innerHTML = `
                    <div class="flex-1">
                        <h3 class="text-4xl font-light text-black">${product.name}</h3>
                        <p class="text-lg text-gray-500 font-light mt-2">${product.description}</p>
                    </div>
                    <div class="flex items-center space-x-12">
                        <span class="text-base font-light ${statusInfo.class}">${statusInfo.text}</span>
                        <div class="w-12 h-12 bg-black rounded-full"></div>
                    </div>
                `;
                
                productsList.appendChild(productDiv);
            });
        }

        async function updateStatuses() {
            await loadProductStatuses();
            renderProducts();
        }

        updateStatuses();
        setInterval(updateStatuses, 1000);
    </script>

</body>
</html>