<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peerkinton - Communauté haut de gamme</title>
    <link href="https://fonts.googleapis.com/css2?family=Work+Sans:wght@300;400;500&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <style>
        body {
            font-family: 'Work Sans', sans-serif;
            font-weight: 300;
        }
        #map {
            height: 500px;
            width: 100%;
        }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#1e3a8a',
                        secondary: '#e5e7eb',
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-50 text-gray-800">
    <?php include 'db.php'; ?>
    
    <header class="bg-white shadow-sm">
        <div class="container mx-auto px-4 py-6">
            <div class="flex justify-between items-center">
                <h1 class="text-3xl font-light text-primary">Peerkinton</h1>
                <nav>
                    <ul class="flex space-x-6">
                        <li><a href="#" class="text-gray-600 hover:text-primary transition">Accueil</a></li>
                        <li><a href="#map-section" class="text-gray-600 hover:text-primary transition">Carte</a></li>
                        <li><a href="#about" class="text-gray-600 hover:text-primary transition">À propos</a></li>
                        <li><a href="#contact" class="text-gray-600 hover:text-primary transition">Contact</a></li>
                    </ul>
                </nav>
            </div>
        </div>
    </header>

    <section class="py-16 bg-primary text-white">
        <div class="container mx-auto px-4 text-center">
            <h2 class="text-4xl font-light mb-6">Bienvenue dans la communauté Peerkinton</h2>
            <p class="text-xl max-w-2xl mx-auto">Découvrez un monde où vous définissez vos propres chemins et créez votre propre cartographie exclusive.</p>
        </div>
    </section>

    <section id="about" class="py-16">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
                <div>
                    <h2 class="text-3xl font-light mb-6">Une expérience cartographique unique</h2>
                    <p class="mb-4">Peerkinton révolutionne la façon dont nous naviguons dans notre communauté. Oubliez les cartes traditionnelles et les adresses conventionnelles.</p>
                    <p class="mb-4">Notre plateforme permet à chaque membre de créer ses propres routes, quartiers et destinations. Une expérience personnalisée qui préserve la confidentialité et l'exclusivité de notre communauté.</p>
                    <p>Rejoignez-nous et participez à la création d'un nouveau monde cartographique qui reflète les valeurs et l'identité unique de Peerkinton.</p>
                </div>
                <div class="bg-gray-100 p-8 rounded-lg shadow-inner">
                    <h3 class="text-2xl font-light mb-4">Fonctionnalités principales</h3>
                    <ul class="space-y-3">
                        <li class="flex items-start">
                            <svg class="h-6 w-6 text-primary mr-2 mt-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                            <span>Création de routes personnalisées</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="h-6 w-6 text-primary mr-2 mt-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                            <span>Définition de lieux et quartiers exclusifs</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="h-6 w-6 text-primary mr-2 mt-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                            <span>Navigation intuitive en temps réel</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="h-6 w-6 text-primary mr-2 mt-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                            <span>Protection de la confidentialité</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <section id="map-section" class="py-16 bg-gray-100">
        <div class="container mx-auto px-4">
            <h2 class="text-3xl font-light mb-6 text-center">Notre carte interactive</h2>
            <p class="text-center max-w-2xl mx-auto mb-8">Explorez et contribuez à notre cartographie exclusive. Cliquez sur la carte pour créer vos propres routes, lieux et quartiers.</p>
            
            <div class="bg-white p-4 rounded-lg shadow-md mb-6">
                <div id="map"></div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h3 class="text-xl font-light mb-4">Créer une route</h3>
                    <form id="route-form" class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Nom de la route</label>
                            <input type="text" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary" name="route_name">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                            <textarea class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary" name="route_description" rows="2"></textarea>
                        </div>
                        <button type="submit" class="w-full bg-primary text-white py-2 px-4 rounded-md hover:bg-blue-900 transition">Enregistrer</button>
                    </form>
                </div>
                
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h3 class="text-xl font-light mb-4">Créer un lieu</h3>
                    <form id="place-form" class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Nom du lieu</label>
                            <input type="text" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary" name="place_name">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Adresse personnalisée</label>
                            <input type="text" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary" name="place_address">
                        </div>
                        <button type="submit" class="w-full bg-primary text-white py-2 px-4 rounded-md hover:bg-blue-900 transition">Enregistrer</button>
                    </form>
                </div>
                
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h3 class="text-xl font-light mb-4">Créer un quartier</h3>
                    <form id="district-form" class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Nom du quartier</label>
                            <input type="text" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary" name="district_name">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                            <textarea class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary" name="district_description" rows="2"></textarea>
                        </div>
                        <button type="submit" class="w-full bg-primary text-white py-2 px-4 rounded-md hover:bg-blue-900 transition">Enregistrer</button>
                    </form>
                </div>
            </div>
            
            <div class="mt-8 p-6 bg-white rounded-lg shadow-md">
                <h3 class="text-xl font-light mb-4">Instructions de navigation</h3>
                <div id="navigation-instructions" class="bg-gray-50 p-4 rounded-md min-h-16">
                    Sélectionnez un point de départ et une destination sur la carte pour obtenir des instructions.
                </div>
            </div>
        </div>
    </section>

    <section id="contact" class="py-16">
        <div class="container mx-auto px-4">
            <h2 class="text-3xl font-light mb-6 text-center">Nous contacter</h2>
            <div class="max-w-xl mx-auto">
                <form class="space-y-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Nom complet</label>
                        <input type="text" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                        <input type="email" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Message</label>
                        <textarea rows="4" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary"></textarea>
                    </div>
                    <button type="submit" class="w-full bg-primary text-white py-2 px-4 rounded-md hover:bg-blue-900 transition">Envoyer</button>
                </form>
            </div>
        </div>
    </section>

    <footer class="bg-gray-800 text-white py-12">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-12">
                <div>
                    <h3 class="text-xl font-light mb-4">Peerkinton</h3>
                    <p>Une communauté haut de gamme avec sa propre cartographie personnalisée.</p>
                </div>
                <div>
                    <h3 class="text-xl font-light mb-4">Liens rapides</h3>
                    <ul class="space-y-2">
                        <li><a href="#" class="hover:text-blue-300 transition">Accueil</a></li>
                        <li><a href="#map-section" class="hover:text-blue-300 transition">Carte</a></li>
                        <li><a href="#about" class="hover:text-blue-300 transition">À propos</a></li>
                        <li><a href="#contact" class="hover:text-blue-300 transition">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h3 class="text-xl font-light mb-4">Contact</h3>
                    <p>contact@peerkinton.com</p>
                    <div class="flex space-x-4 mt-4">
                        <a href="#" class="hover:text-blue-300 transition">
                            <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M24 4.557c-.883.392-1.832.656-2.828.775 1.017-.609 1.798-1.574 2.165-2.724-.951.564-2.005.974-3.127 1.195-.897-.957-2.178-1.555-3.594-1.555-3.179 0-5.515 2.966-4.797 6.045-4.091-.205-7.719-2.165-10.148-5.144-1.29 2.213-.129-1.26 2.605 0-3.302 2.447 1.26 4.81 1.996 1.7 4.726 2.717 7.66 2.83-4.5 2.913-.872 5.4 2.804 5.4 5.775 0 1.134-.333 2.18-.877 3.082 2.369-.462 4.527-1.365 6.378-2.63.738 2.223 1.169 4.61 1.169 7.107 0 10.001-8.178 18.124-18.253 18.124-10.086 0-18.253-8.123-18.253-18.124 0-10.008 8.167-18.124 18.253-18.124z"/>
                            </svg>
                        </a>
                        <a href="#" class="hover:text-blue-300 transition">
                            <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                            </svg>
                        </a>
                        <a href="#" class="hover:text-blue-300 transition">
                            <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M19 0h-14c-2.761 0-5 2.239-5 5v14c0 2.761 2.239 5 5 5h14c2.762 0 5-2.239 5-5v-14c0-2.761-2.238-5-5-5zm-11 19h-3v-11h3v11zm-1.5-12.268c-.966 0-1.75-.79-1.75-1.764s.784-1.764 1.75-1.764 1.75.79 1.75 1.764-.783 1.764-1.75 1.764zm13.5 12.268h-3v-5.604c0-3.368-4-3.113-4 0v5.604h-3v-11h3v1.765c1.396-2.586 7-2.777 7 2.476v6.759z"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <div class="mt-8 pt-8 border-t border-gray-700 text-center">
                <p>&copy; <?php echo date('Y'); ?> Peerkinton. Tous droits réservés.</p>
            </div>
        </div>
    </footer>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialisation de la carte avec Leaflet
            var map = L.map('map').setView([48.8566, 2.3522], 13); // Paris par défaut
            
            // Ajout d'une couche OpenStreetMap
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
            }).addTo(map);
            
            // Variables pour stocker les points de la route
            var routePoints = [];
            var markers = [];
            var polyline = null;
            var startPoint = null;
            var endPoint = null;
            
            // Gestion des clics sur la carte
            map.on('click', function(e) {
                var latlng = e.latlng;
                
                // Ajouter un marqueur
                var marker = L.marker(latlng).addTo(map);
                markers.push(marker);
                
                // Ajouter le point à la route
                routePoints.push([latlng.lat, latlng.lng]);
                
                // Si c'est le premier point, le définir comme point de départ
                if (!startPoint) {
                    startPoint = latlng;
                    marker.bindPopup("Point de départ").openPopup();
                } else {
                    // Si c'est le deuxième point ou plus, mettre à jour la polyline
                    endPoint = latlng;
                    
                    if (routePoints.length > 1) {
                        if (polyline) {
                            map.removeLayer(polyline);
                        }
                        
                        polyline = L.polyline(routePoints, {color: 'blue'}).addTo(map);
                        
                        // Afficher les instructions de navigation
                        updateNavigationInstructions();
                    }
                }
            });
            
            // Fonction pour mettre à jour les instructions de navigation
            function updateNavigationInstructions() {
                if (routePoints.length < 2) return;
                
                var instructions = document.getElementById('navigation-instructions');
                var html = "<strong>Itinéraire:</strong><br>";
                
                // Calculer la distance totale
                var distance = 0;
                for (var i = 1; i < routePoints.length; i++) {
                    var from = L.latLng(routePoints[i-1][0], routePoints[i-1][1]);
                    var to = L.latLng(routePoints[i][0], routePoints[i][1]);
                    distance += from.distanceTo(to);
                }
                
                html += "Distance totale: " + (distance / 1000).toFixed(2) + " km<br><br>";
                html += "<ol class='list-decimal pl-5'>";
                
                // Générer des instructions simples
                html += "<li>Partez du point de départ</li>";
                
                for (var i = 1; i < routePoints.length - 1; i++) {
                    html += "<li>Continuez jusqu'au point " + (i + 1) + "</li>";
                }
                
                html += "<li>Arrivez à destination</li>";
                html += "</ol>";
                
                instructions.innerHTML = html;
            }
            
            // Gérer le formulaire de création de route
            document.getElementById('route-form').addEventListener('submit', function(e) {
                e.preventDefault();
                
                var routeName = this.elements['route_name'].value;
                var routeDescription = this.elements['route_description'].value;
                
                if (!routeName || routePoints.length < 2) {
                    alert('Veuillez donner un nom à la route et sélectionner au moins deux points sur la carte.');
                    return;
                }
                
                // Envoyer les données au serveur (à implémenter)
                saveRouteToDatabase(routeName, routeDescription, routePoints);
                
                alert('Route "' + routeName + '" créée avec succès!');
                this.reset();
            });
            
            // Gérer le formulaire de création de lieu
            document.getElementById('place-form').addEventListener('submit', function(e) {
                e.preventDefault();
                
                var placeName = this.elements['place_name'].value;
                var placeAddress = this.elements['place_address'].value;
                
                if (!placeName || !placeAddress || routePoints.length < 1) {
                    alert('Veuillez remplir tous les champs et sélectionner un point sur la carte.');
                    return;
                }
                
                // Utiliser le dernier point sélectionné comme emplacement du lieu
                var location = routePoints[routePoints.length - 1];
                
                // Envoyer les données au serveur (à implémenter)
                savePlaceToDatabase(placeName, placeAddress, location);
                
                alert('Lieu "' + placeName + '" créé avec succès!');
                this.reset();
            });
            
            // Gérer le formulaire de création de quartier
            document.getElementById('district-form').addEventListener('submit', function(e) {
                e.preventDefault();
                
                var districtName = this.elements['district_name'].value;
                var districtDescription = this.elements['district_description'].value;
                
                if (!districtName || routePoints.length < 3) {
                    alert('Veuillez donner un nom au quartier et sélectionner au moins trois points sur la carte pour définir son périmètre.');
                    return;
                }
                
                // Envoyer les données au serveur (à implémenter)
                saveDistrictToDatabase(districtName, districtDescription, routePoints);
                
                alert('Quartier "' + districtName + '" créé avec succès!');
                this.reset();
            });
            
            // Fonction pour enregistrer une route dans la base de données
            function saveRouteToDatabase(name, description, points) {
                // Création de l'objet à envoyer
                var routeData = {
                    name: name,
                    description: description,
                    points: points
                };
                
                // Envoi des données via AJAX (à adapter selon votre configuration)
                var xhr = new XMLHttpRequest();
                xhr.open('POST', 'save_route.php', true);
                xhr.setRequestHeader('Content-Type', 'application/json');
                xhr.onload = function() {
                    if (xhr.status === 200) {
                        console.log('Route enregistrée avec succès');
                    } else {
                        console.error('Erreur lors de l\'enregistrement de la route');
                    }
                };
                xhr.send(JSON.stringify(routeData));
            }
            
            // Fonction pour enregistrer un lieu dans la base de données
            function savePlaceToDatabase(name, address, location) {
                // Création de l'objet à envoyer
                var placeData = {
                    name: name,
                    address: address,
                    location: location
                };
                
                // Envoi des données via AJAX (à adapter selon votre configuration)
                var xhr = new XMLHttpRequest();
                xhr.open('POST', 'save_place.php', true);
                xhr.setRequestHeader('Content-Type', 'application/json');
                xhr.onload = function() {
                    if (xhr.status === 200) {
                        console.log('Lieu enregistré avec succès');
                    } else {
                        console.error('Erreur lors de l\'enregistrement du lieu');
                    }
                };
                xhr.send(JSON.stringify(placeData));
            }
            
            // Fonction pour enregistrer un quartier dans la base de données
            function saveDistrictToDatabase(name, description, points) {
                // Création de l'objet à envoyer
                var districtData = {
                    name: name,
                    description: description,
                    points: points
                };
                
                // Envoi des données via AJAX (à adapter selon votre configuration)
                var xhr = new XMLHttpRequest();
                xhr.open('POST', 'save_district.php', true);
                xhr.setRequestHeader('Content-Type', 'application/json');
                xhr.onload = function() {
                    if (xhr.status === 200) {
                        console.log('Quartier enregistré avec succès');
                    } else {
                        console.error('Erreur lors de l\'enregistrement du quartier');
                    }
                };
                xhr.send(JSON.stringify(districtData));
            }
            
            // Géolocalisation
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function(position) {
                    var userLocation = [position.coords.latitude, position.coords.longitude];
                    map.setView(userLocation, 15);
                    
                    // Ajouter un marqueur pour la position de l'utilisateur
                    L.marker(userLocation).addTo(map)
                        .bindPopup('Votre position actuelle')
                        .openPopup();
                });
            }
        });
    </script>
</body>
</html>