<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>The Peerkinton Village</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Underdog&display=swap" rel="stylesheet">
</head>
<body class="bg-black text-white">
    <div class="relative h-screen overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-br from-black via-black/80 to-black/50 z-10"></div>
        
        <div class="absolute top-0 left-0 w-full h-full opacity-30">
            <div class="absolute w-64 h-64 bg-white/10 rounded-full blur-3xl -top-16 -left-16 animate-pulse"></div>
            <div class="absolute w-96 h-96 bg-white/10 rounded-full blur-3xl bottom-0 right-0 animate-pulse delay-500"></div>
        </div>

        <div class="relative z-20 container mx-auto px-4 h-full flex flex-col justify-center">
            <div class="text-center">
                <h1 class="text-6xl md:text-8xl font-['Underdog'] mb-6 relative">
                    <span class="absolute -left-8 -top-4 text-4xl opacity-50">✦</span>
                    Peerkinton Village
                    <span class="absolute -right-8 -bottom-4 text-4xl opacity-50">✦</span>
                </h1>
                <p class="text-xl md:text-2xl max-w-3xl mx-auto mb-10 font-light tracking-wide">
                    Voyage dans le temps. Immersion totale. Une expérience historique où vous êtes le protagoniste.
                </p>
                <div class="flex justify-center space-x-4">
                    <a href="#" class="px-8 py-3 bg-white text-black rounded-full hover:bg-gray-200 transition duration-300 transform hover:-translate-y-1 shadow-lg">
                        Découvrir
                    </a>
                    <a href="#" class="px-8 py-3 border border-white rounded-full hover:bg-white/10 transition duration-300 transform hover:-translate-y-1">
                        Réserver
                    </a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>