<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="logo_new.png">
    <title>Vert Chasseur</title>    
    <meta name="description" content="Vert Chasseur est un quartier à Uccle où vous trouverez de la joie et un havre de paix accueillant. Découvrez les commerces partenaire du quartier et les événements qui pourrait vous intéresser.">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {}
            }
        }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
    <script defer src="https://cloud.umami.is/script.js" data-website-id="6ec552ef-4a61-4f71-a55f-4464703af623"></script>
    <style>
        body {
            font-family: 'Inter', sans-serif;
            letter-spacing: -0.01em;
        }
        .backdrop-blur {
            backdrop-filter: blur(10px);
        }
        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
            font-style: normal;
        }
        .nav-link {
            position: relative;
            transition: all 0.3s ease;
        }
        .nav-link::after {
            content: '';
            position: absolute;
            bottom: -4px;
            left: 50%;
            width: 0;
            height: 2px;
            background: currentColor;
            transition: all 0.3s ease;
            transform: translateX(-50%);
        }
        .nav-link:hover::after {
            width: 100%;
        }
        .account-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            transition: all 0.3s ease;
        }
        .account-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        }
        .mobile-nav-item {
            transition: all 0.3s ease;
        }
        .mobile-nav-item:hover {
            transform: translateX(8px);
        }
    </style>
</head>
<body class="bg-gray-50 dark:bg-gray-900 text-gray-900 dark:text-white transition-colors duration-300">

<header id="header" class="fixed w-full top-0 z-50 transition-all duration-500 bg-white/80 dark:bg-gray-900/80 backdrop-blur border-b border-gray-200/50 dark:border-gray-700/50">
    <div class="container mx-auto px-6 py-4">
        <div class="flex justify-between items-center">
            <div>
                <a href="/" class="flex items-center group">
                    <img src="logo_new.png" alt="Vert Chasseur" class="h-10 block dark:hidden transition-transform duration-300 group-hover:scale-105">
                    <img src="logo_dark.png" alt="Vert Chasseur" class="h-10 hidden dark:block transition-transform duration-300 group-hover:scale-105">
                </a>
            </div>
            
            <nav class="hidden lg:flex items-center space-x-8">
                <a href="/media" class="nav-link text-gray-700 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white text-sm font-medium">Actualité</a>
                <a href="/shop" class="nav-link text-gray-700 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white text-sm font-medium">Commerce</a>
                <a href="https://imators.com/support" class="nav-link text-gray-700 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white text-sm font-medium">Contact</a>
                
                <div class="h-6 w-px bg-gray-300 dark:bg-gray-600"></div>
                
                <a href="/compte" class="account-btn inline-flex items-center px-4 py-2 rounded-full text-white text-sm font-medium">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                    </svg>
                    Compte
                </a>
            </nav>

            <button id="menuBtn" class="lg:hidden p-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                </svg>
            </button>
        </div>
    </div>

    <div id="mobileMenu" class="fixed inset-0 bg-white/95 dark:bg-gray-900/95 backdrop-blur-xl transform translate-x-full transition-transform duration-500 lg:hidden">
        <div class="flex justify-between items-center p-6 border-b border-gray-200 dark:border-gray-700">
            <img src="logo_new.png" alt="Vert Chasseur" class="h-8 block dark:hidden">
            <img src="logo_dark.png" alt="Vert Chasseur" class="h-8 hidden dark:block">
            <button id="closeBtn" class="p-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                </svg>
            </button>
        </div>
        
        <nav class="p-6 space-y-6">
            <a href="/media" class="mobile-nav-item flex items-center text-lg font-medium text-gray-900 dark:text-white hover:text-blue-600 dark:hover:text-blue-400">
                <svg class="w-5 h-5 mr-3 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/>
                </svg>
                Actualité
            </a>
            
            <a href="/shop" class="mobile-nav-item flex items-center text-lg font-medium text-gray-900 dark:text-white hover:text-blue-600 dark:hover:text-blue-400">
                <svg class="w-5 h-5 mr-3 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                </svg>
                Commerce
            </a>
            
            <a href="https://imators.com/support" class="mobile-nav-item flex items-center text-lg font-medium text-gray-900 dark:text-white hover:text-blue-600 dark:hover:text-blue-400">
                <svg class="w-5 h-5 mr-3 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                </svg>
                Contact
            </a>
            
            <div class="pt-6 border-t border-gray-200 dark:border-gray-700">
                <a href="/compte" class="mobile-nav-item flex items-center text-lg font-medium bg-gradient-to-r from-blue-600 to-purple-600 text-white px-4 py-3 rounded-xl">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                    </svg>
                    Mon Compte
                </a>
            </div>
        </nav>
    </div>
</header>

<main class="pt-20 min-h-screen bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-900 dark:to-gray-800">
    <div class="container mx-auto px-6 py-20">
        <div class="text-center">
            <h1 class="text-4xl md:text-6xl font-light mb-6 text-gray-900 dark:text-white">
                Bienvenue à <span class="txt-chasseur text-blue-600 dark:text-blue-400">Vert Chasseur</span>
            </h1>
            <p class="text-xl text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                Un havre de paix moderne où tradition et innovation se rencontrent
            </p>
        </div>
    </div>
</main>

<script>
    if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
        document.documentElement.classList.add('dark');
    }
    window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
        if (e.matches) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    });

    const header = document.getElementById('header');
    const menuBtn = document.getElementById('menuBtn');
    const closeBtn = document.getElementById('closeBtn');
    const mobileMenu = document.getElementById('mobileMenu');

    window.addEventListener('scroll', () => {
        if (window.scrollY > 50) {
            header.classList.add('bg-white/95', 'dark:bg-gray-900/95', 'shadow-lg', 'shadow-gray-200/50', 'dark:shadow-gray-800/50');
            header.classList.remove('bg-white/80', 'dark:bg-gray-900/80');
        } else {
            header.classList.remove('bg-white/95', 'dark:bg-gray-900/95', 'shadow-lg', 'shadow-gray-200/50', 'dark:shadow-gray-800/50');
            header.classList.add('bg-white/80', 'dark:bg-gray-900/80');
        }
    });

    menuBtn.addEventListener('click', () => {
        mobileMenu.classList.remove('translate-x-full');
        document.body.style.overflow = 'hidden';
    });
    
    closeBtn.addEventListener('click', () => {
        mobileMenu.classList.add('translate-x-full');
        document.body.style.overflow = 'auto';
    });

    document.addEventListener('click', (e) => {
        if (e.target === mobileMenu) {
            mobileMenu.classList.add('translate-x-full');
            document.body.style.overflow = 'auto';
        }
    });
</script>

</body>
</html>